/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent;

import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OpenTelemetryAgent {
    private static final Class<?> thisClass = OpenTelemetryAgent.class;

    public static void premain(String agentArgs, Instrumentation inst) {
        OpenTelemetryAgent.agentmain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        try {
            File javaagentFile = OpenTelemetryAgent.installBootstrapJar(inst);
            AgentInitializer.initialize(inst, javaagentFile);
        }
        catch (Throwable ex) {
            System.err.println("ERROR " + thisClass.getName());
            ex.printStackTrace();
        }
    }

    private static synchronized File installBootstrapJar(Instrumentation inst) throws IOException, URISyntaxException {
        File javaagentFile;
        CodeSource codeSource = thisClass.getProtectionDomain().getCodeSource();
        if (codeSource != null && (javaagentFile = new File(codeSource.getLocation().toURI())).isFile()) {
            JarFile agentJar = new JarFile(javaagentFile, false);
            OpenTelemetryAgent.verifyJarManifestMainClassIsThis(javaagentFile, agentJar);
            inst.appendToBootstrapClassLoaderSearch(agentJar);
            return javaagentFile;
        }
        System.out.println("Could not get bootstrap jar from code source, using -javaagent arg");
        List<String> arguments = OpenTelemetryAgent.getVmArgumentsThroughReflection();
        String agentArgument = null;
        for (String arg : arguments) {
            if (!arg.startsWith("-javaagent")) continue;
            if (agentArgument == null) {
                agentArgument = arg;
                continue;
            }
            throw new IllegalStateException("Multiple javaagents specified and code source unavailable, not installing tracing agent");
        }
        if (agentArgument == null) {
            throw new IllegalStateException("Could not find javaagent parameter and code source unavailable, not installing tracing agent");
        }
        Matcher matcher = Pattern.compile("-javaagent:([^=]+).*").matcher(agentArgument);
        if (!matcher.matches()) {
            throw new IllegalStateException("Unable to parse javaagent parameter: " + agentArgument);
        }
        File javaagentFile2 = new File(matcher.group(1));
        if (!javaagentFile2.isFile()) {
            throw new IllegalStateException("Unable to find javaagent file: " + javaagentFile2);
        }
        JarFile agentJar = new JarFile(javaagentFile2, false);
        OpenTelemetryAgent.verifyJarManifestMainClassIsThis(javaagentFile2, agentJar);
        inst.appendToBootstrapClassLoaderSearch(agentJar);
        return javaagentFile2;
    }

    private static List<String> getVmArgumentsThroughReflection() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            Object vmManagement;
            Class<?> managementFactoryHelperClass = classLoader.loadClass("sun.management.ManagementFactoryHelper");
            Class<?> vmManagementClass = classLoader.loadClass("sun.management.VMManagement");
            try {
                vmManagement = managementFactoryHelperClass.getDeclaredMethod("getVMManagement", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Field field = managementFactoryHelperClass.getDeclaredField("jvm");
                field.setAccessible(true);
                vmManagement = field.get(null);
                field.setAccessible(false);
            }
            return (List)vmManagementClass.getMethod("getVmArguments", new Class[0]).invoke(vmManagement, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            try {
                Class<?> vmClass = classLoader.loadClass("com.ibm.oti.vm.VM");
                String[] argArray = (String[])vmClass.getMethod("getVMArgs", new Class[0]).invoke(null, new Object[0]);
                return Arrays.asList(argArray);
            }
            catch (ReflectiveOperationException e1) {
                System.out.println("WARNING: Unable to get VM args through reflection. A custom java.util.logging.LogManager may not work correctly");
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        }
    }

    private static void verifyJarManifestMainClassIsThis(File jarFile, JarFile agentJar) throws IOException {
        Manifest manifest = agentJar.getManifest();
        if (manifest.getMainAttributes().getValue("Premain-Class") == null) {
            throw new IllegalStateException("The agent was not installed, because the agent was found in '" + jarFile + "', which doesn't contain a Premain-Class manifest attribute. Make sure that you haven't included the agent jar file inside of an application uber jar.");
        }
    }

    public static void main(String ... args) {
        try {
            System.out.println(OpenTelemetryAgent.class.getPackage().getImplementationVersion());
        }
        catch (RuntimeException e) {
            System.out.println("Failed to parse agent version");
            e.printStackTrace();
        }
    }

    private OpenTelemetryAgent() {
    }
}

