/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.nio.ByteBuffer;

public class DefineClassHelper {
    private static volatile Handler handler;

    public static Handler.DefineClassContext beforeDefineClass(ClassLoader classLoader, String className, byte[] classBytes, int offset, int length) {
        return handler.beforeDefineClass(classLoader, className, classBytes, offset, length);
    }

    public static Handler.DefineClassContext beforeDefineClass(ClassLoader classLoader, String className, ByteBuffer byteBuffer) {
        int length = byteBuffer.remaining();
        if (byteBuffer.hasArray()) {
            return DefineClassHelper.beforeDefineClass(classLoader, className, byteBuffer.array(), byteBuffer.position() + byteBuffer.arrayOffset(), length);
        }
        byte[] classBytes = new byte[length];
        byteBuffer.duplicate().get(classBytes);
        return DefineClassHelper.beforeDefineClass(classLoader, className, classBytes, 0, length);
    }

    public static void afterDefineClass(Handler.DefineClassContext context) {
        handler.afterDefineClass(context);
    }

    public static void internalSetHandler(Handler handler) {
        if (DefineClassHelper.handler != null) {
            return;
        }
        DefineClassHelper.handler = handler;
    }

    private DefineClassHelper() {
    }

    public static interface Handler {
        public DefineClassContext beforeDefineClass(ClassLoader var1, String var2, byte[] var3, int var4, int var5);

        public void afterDefineClass(DefineClassContext var1);

        public static interface DefineClassContext {
            public void exit();
        }
    }
}

