/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInitializer {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[opentelemetry.auto.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.defaultLogLevel";
    private static final String SIMPLE_LOGGER_MUZZLE_LOG_LEVEL_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.log.muzzleMatcher";
    private static final Logger log;
    private static ClassLoader AGENT_CLASSLOADER;

    public static void initialize(Instrumentation inst, URL bootstrapUrl) {
        AgentInitializer.startAgent(inst, bootstrapUrl);
        boolean appUsingCustomLogManager = AgentInitializer.isAppUsingCustomLogManager();
        if (AgentInitializer.isJavaBefore9WithJfr() && appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying Agent Tracer initialization.");
            AgentInitializer.registerLogManagerCallback(new InstallAgentTracerCallback());
        } else {
            AgentInitializer.installAgentTracer();
        }
    }

    private static void registerLogManagerCallback(ClassLoadCallBack callback) {
        try {
            Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass("io.opentelemetry.javaagent.tooling.AgentInstaller");
            Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
            registerCallbackMethod.invoke(null, "java.util.logging.LogManager", callback);
        }
        catch (Exception ex) {
            log.error("Error registering callback for " + callback.getName(), (Throwable)ex);
        }
    }

    private static synchronized void startAgent(Instrumentation inst, URL bootstrapUrl) {
        if (AGENT_CLASSLOADER == null) {
            try {
                ClassLoader agentClassLoader = AgentInitializer.createAgentClassLoader("inst", bootstrapUrl);
                Class<?> agentInstallerClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentInstaller");
                Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
                agentInstallerMethod.invoke(null, inst);
                AGENT_CLASSLOADER = agentClassLoader;
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while installing the agent", ex);
            }
        }
    }

    private static synchronized void installAgentTracer() {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Agent should have been started already");
        }
        try {
            Class<?> tracerInstallerClass = AGENT_CLASSLOADER.loadClass("io.opentelemetry.javaagent.tooling.TracerInstaller");
            Method tracerInstallerMethod = tracerInstallerClass.getMethod("installAgentTracer", new Class[0]);
            tracerInstallerMethod.invoke(null, new Object[0]);
            Method logVersionInfoMethod = tracerInstallerClass.getMethod("logVersionInfo", new Class[0]);
            logVersionInfoMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while installing the agent tracer", ex);
        }
    }

    private static void configureLogger() {
        AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (AgentInitializer.isDebugMode()) {
            AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
        } else {
            AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_MUZZLE_LOG_LEVEL_PROPERTY, "OFF");
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static ClassLoader createAgentClassLoader(String innerJarFilename, URL bootstrapUrl) throws Exception {
        ClassLoader agentParent = AgentInitializer.isJavaBefore9() ? null : AgentInitializer.getPlatformClassLoader();
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("io.opentelemetry.javaagent.bootstrap.AgentClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class);
        return (ClassLoader)constructor.newInstance(bootstrapUrl, innerJarFilename, agentParent);
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "otel.javaagent.debug";
        String tracerDebugLevelProp = System.getProperty(tracerDebugLevelSysprop);
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv(tracerDebugLevelSysprop.replace('.', '_').toUpperCase());
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    private static boolean isAppUsingCustomLogManager() {
        String tracerCustomLogManSysprop = "otel.app.customlogmanager";
        String customLogManagerProp = System.getProperty(tracerCustomLogManSysprop);
        String customLogManagerEnv = System.getenv(tracerCustomLogManSysprop.replace('.', '_').toUpperCase());
        if (customLogManagerProp != null || customLogManagerEnv != null) {
            log.debug("Prop - customlogmanager: " + customLogManagerProp);
            log.debug("Env - customlogmanager: " + customLogManagerEnv);
            return Boolean.parseBoolean(customLogManagerProp) || Boolean.parseBoolean(customLogManagerEnv);
        }
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            log.debug("Env - jboss: " + jbossHome);
            return true;
        }
        String logManagerProp = System.getProperty("java.util.logging.manager");
        if (logManagerProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(logManagerProp.replaceAll("\\.", "/") + ".class") != null;
            log.debug("Prop - logging.manager: " + logManagerProp);
            log.debug("logging.manager on system classpath: " + onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }

    private static boolean isJavaBefore9WithJfr() {
        if (!AgentInitializer.isJavaBefore9()) {
            return false;
        }
        String jfrClassResourceName = "jdk.jfr.Recording".replace('.', '/') + ".class";
        return Thread.currentThread().getContextClassLoader().getResource(jfrClassResourceName) != null;
    }

    static {
        AgentInitializer.configureLogger();
        log = LoggerFactory.getLogger(AgentInitializer.class);
        AGENT_CLASSLOADER = null;
    }

    protected static class InstallAgentTracerCallback
    extends ClassLoadCallBack {
        protected InstallAgentTracerCallback() {
        }

        @Override
        public String getName() {
            return "agent-tracer";
        }

        @Override
        public void execute() {
            AgentInitializer.installAgentTracer();
        }
    }

    protected static abstract class ClassLoadCallBack
    implements Runnable {
        protected ClassLoadCallBack() {
        }

        @Override
        public void run() {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        this.execute();
                    }
                    catch (Exception e) {
                        log.error("Failed to run class loader callback {}", (Object)this.getName(), (Object)e);
                    }
                }
            });
            thread.setName("agent-startup-" + this.getName());
            thread.setDaemon(true);
            thread.start();
        }

        public abstract String getName();

        public abstract void execute();
    }
}

