/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.stacktrace;

import com.google.auto.service.AutoService;
import io.opentelemetry.contrib.stacktrace.StackTraceSpanProcessor;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@AutoService(value={AutoConfigurationCustomizerProvider.class})
public class StackTraceAutoConfig
implements AutoConfigurationCustomizerProvider {
    private static final Logger log = Logger.getLogger(StackTraceAutoConfig.class.getName());
    static final String PREFIX = "otel.java.experimental.span-stacktrace.";
    static final String CONFIG_MIN_DURATION = "otel.java.experimental.span-stacktrace.min.duration";
    private static final Duration CONFIG_MIN_DURATION_DEFAULT = Duration.ofMillis(5L);
    private static final String CONFIG_FILTER = "otel.java.experimental.span-stacktrace.filter";

    public void customize(AutoConfigurationCustomizer config) {
        config.addTracerProviderCustomizer((providerBuilder, properties) -> {
            if (StackTraceAutoConfig.getMinDuration(properties) >= 0L) {
                providerBuilder.addSpanProcessor((SpanProcessor)StackTraceAutoConfig.create(properties));
            }
            return providerBuilder;
        });
    }

    static StackTraceSpanProcessor create(ConfigProperties properties) {
        return new StackTraceSpanProcessor(StackTraceAutoConfig.getMinDuration(properties), StackTraceAutoConfig.getFilterPredicate(properties));
    }

    static long getMinDuration(ConfigProperties properties) {
        long minDuration = properties.getDuration(CONFIG_MIN_DURATION, CONFIG_MIN_DURATION_DEFAULT).toNanos();
        if (minDuration < 0L) {
            log.fine("Stack traces capture is disabled");
        } else {
            log.log(Level.FINE, "Stack traces will be added to spans with a minimum duration of {0} nanos", minDuration);
        }
        return minDuration;
    }

    static Predicate<ReadableSpan> getFilterPredicate(ConfigProperties properties) {
        Class<?> filterType;
        String filterClass = properties.getString(CONFIG_FILTER);
        Predicate<ReadableSpan> filter = null;
        if (filterClass != null && (filterType = StackTraceAutoConfig.getFilterType(filterClass)) != null) {
            filter = StackTraceAutoConfig.getFilterInstance(filterType);
        }
        if (filter == null) {
            Level disabledLogLevel = filterClass != null ? Level.SEVERE : Level.FINE;
            log.log(disabledLogLevel, "Span stacktrace filtering disabled");
            return span -> true;
        }
        log.fine("Span stacktrace filtering enabled with: " + filterClass);
        return filter;
    }

    @Nullable
    private static Class<?> getFilterType(String filterClass) {
        try {
            Class<?> filterType = Class.forName(filterClass);
            if (!Predicate.class.isAssignableFrom(filterType)) {
                log.severe("Filter must be a subclass of java.util.function.Predicate");
                return null;
            }
            return filterType;
        }
        catch (ClassNotFoundException e) {
            log.severe("Unable to load filter class: " + filterClass);
            return null;
        }
    }

    @Nullable
    private static Predicate<ReadableSpan> getFilterInstance(Class<?> filterType) {
        try {
            Constructor<?> constructor = filterType.getConstructor(new Class[0]);
            return (Predicate)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.severe("Unable to create filter instance with no-arg constructor: " + filterType);
            return null;
        }
    }
}

