/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.stacktrace.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.contrib.stacktrace.internal.MutableSpanData;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.SpanData;
import javax.annotation.Nullable;

public class MutableSpan
implements ReadableSpan {
    private final ReadableSpan delegate;
    @Nullable
    private MutableSpanData mutableSpanData = null;
    @Nullable
    private SpanData cachedDelegateSpanData = null;
    private boolean frozen;

    private MutableSpan(ReadableSpan delegate) {
        if (!delegate.hasEnded()) {
            throw new IllegalArgumentException("The provided span has not ended yet!");
        }
        this.delegate = delegate;
    }

    public static MutableSpan makeMutable(ReadableSpan span) {
        if (span instanceof MutableSpan && !((MutableSpan)span).frozen) {
            return (MutableSpan)span;
        }
        return new MutableSpan(span);
    }

    public ReadableSpan getOriginalSpan() {
        return this.delegate;
    }

    private SpanData getDelegateSpanData() {
        if (this.cachedDelegateSpanData == null) {
            this.cachedDelegateSpanData = this.delegate.toSpanData();
        }
        return this.cachedDelegateSpanData;
    }

    public SpanData toSpanData() {
        this.frozen = true;
        if (this.mutableSpanData != null) {
            return this.mutableSpanData;
        }
        return this.getDelegateSpanData();
    }

    private MutableSpanData mutate() {
        if (this.frozen) {
            throw new IllegalStateException("toSpanData() has already been called on this span, it is no longer mutable!");
        }
        if (this.mutableSpanData == null) {
            this.mutableSpanData = new MutableSpanData(this.getDelegateSpanData());
        }
        return this.mutableSpanData;
    }

    @Nullable
    public <T> T getAttribute(AttributeKey<T> key) {
        if (this.mutableSpanData != null) {
            return this.mutableSpanData.getAttribute(key);
        }
        return (T)this.delegate.getAttribute(key);
    }

    public <T> void removeAttribute(AttributeKey<T> key) {
        this.mutate().setAttribute(key, null);
    }

    public <T> void setAttribute(AttributeKey<T> key, @Nullable T value) {
        this.mutate().setAttribute(key, value);
    }

    public String getName() {
        if (this.mutableSpanData != null) {
            return this.mutableSpanData.getName();
        }
        return this.delegate.getName();
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mutate().setName(name);
    }

    public SpanContext getSpanContext() {
        return this.delegate.getSpanContext();
    }

    public SpanContext getParentSpanContext() {
        return this.delegate.getParentSpanContext();
    }

    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.delegate.getInstrumentationLibraryInfo();
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.delegate.getInstrumentationScopeInfo();
    }

    public boolean hasEnded() {
        return this.delegate.hasEnded();
    }

    public long getLatencyNanos() {
        return this.delegate.getLatencyNanos();
    }

    public SpanKind getKind() {
        return this.delegate.getKind();
    }
}

