/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class OtelTraceState {
    public static final String TRACE_STATE_KEY = "ot";
    private static final String SUBKEY_RANDOM_VALUE = "rv";
    private static final String SUBKEY_THRESHOLD = "th";
    private static final int TRACE_STATE_SIZE_LIMIT = 256;
    private long randomValue;
    private long threshold;
    private final List<String> otherKeyValuePairs;

    private OtelTraceState(long randomValue, long threshold, List<String> otherKeyValuePairs) {
        this.randomValue = randomValue;
        this.threshold = threshold;
        this.otherKeyValuePairs = otherKeyValuePairs;
    }

    private OtelTraceState() {
        this(ConsistentSamplingUtil.getInvalidRandomValue(), ConsistentSamplingUtil.getInvalidThreshold(), Collections.emptyList());
    }

    public long getRandomValue() {
        return this.randomValue;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public boolean hasValidRandomValue() {
        return ConsistentSamplingUtil.isValidRandomValue(this.randomValue);
    }

    public boolean hasValidThreshold() {
        return ConsistentSamplingUtil.isValidThreshold(this.threshold);
    }

    public void invalidateRandomValue() {
        this.randomValue = ConsistentSamplingUtil.getInvalidRandomValue();
    }

    public void invalidateThreshold() {
        this.threshold = ConsistentSamplingUtil.getInvalidThreshold();
    }

    public void setThreshold(long threshold) {
        if (ConsistentSamplingUtil.isValidThreshold(threshold)) {
            this.threshold = threshold;
        } else {
            this.invalidateThreshold();
        }
    }

    public void setRandomValue(long randomValue) {
        if (ConsistentSamplingUtil.isValidRandomValue(randomValue)) {
            this.randomValue = randomValue;
        } else {
            this.invalidateRandomValue();
        }
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        if (this.hasValidThreshold() && this.threshold < ConsistentSamplingUtil.getMaxThreshold()) {
            sb.append(SUBKEY_THRESHOLD).append(':');
            ConsistentSamplingUtil.appendLast56BitHexEncodedWithoutTrailingZeros(sb, this.threshold);
        }
        if (this.hasValidRandomValue()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(SUBKEY_RANDOM_VALUE).append(':');
            ConsistentSamplingUtil.appendLast56BitHexEncoded(sb, this.randomValue);
        }
        for (String pair : this.otherKeyValuePairs) {
            int ex = sb.length();
            if (ex != 0) {
                ++ex;
            }
            if (ex + pair.length() > 256) break;
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(pair);
        }
        return sb.toString();
    }

    private static boolean isValueByte(char c) {
        return OtelTraceState.isLowerCaseAlphaNum(c) || OtelTraceState.isUpperCaseAlpha(c) || c == '.' || c == '_' || c == '-';
    }

    private static boolean isLowerCaseAlphaNum(char c) {
        return OtelTraceState.isLowerCaseAlpha(c) || OtelTraceState.isDigit(c);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLowerCaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isUpperCaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static long parseRandomValue(String s, int startIncl, int endIncl) {
        int len = endIncl - startIncl;
        if (len != 14) {
            return ConsistentSamplingUtil.getInvalidRandomValue();
        }
        return OtelTraceState.parseHex(s, startIncl, len, ConsistentSamplingUtil.getInvalidRandomValue());
    }

    private static long parseThreshold(String s, int startIncl, int endIncl) {
        int len = endIncl - startIncl;
        if (len > 14) {
            return ConsistentSamplingUtil.getInvalidThreshold();
        }
        return OtelTraceState.parseHex(s, startIncl, len, ConsistentSamplingUtil.getInvalidThreshold());
    }

    static long parseHex(String s, int startIncl, int len, long invalidReturnValue) {
        long r = 0L;
        for (int i = 0; i < len; ++i) {
            long x;
            long c = s.charAt(startIncl + i);
            if (c >= 48L && c <= 57L) {
                x = c - 48L;
            } else if (c >= 97L && c <= 102L) {
                x = c - 97L + 10L;
            } else {
                return invalidReturnValue;
            }
            r |= x << 52 - (i << 2);
        }
        return r;
    }

    public static OtelTraceState parse(@Nullable String ts) {
        long randomValue;
        long threshold;
        ArrayList<String> otherKeyValuePairs;
        block12: {
            int separatorPos;
            otherKeyValuePairs = null;
            threshold = ConsistentSamplingUtil.getInvalidThreshold();
            randomValue = ConsistentSamplingUtil.getInvalidRandomValue();
            if (ts == null || ts.isEmpty()) {
                return new OtelTraceState();
            }
            if (ts.length() > 256) {
                return new OtelTraceState();
            }
            int startPos = 0;
            int len = ts.length();
            do {
                char c;
                int colonPos;
                for (colonPos = startPos; colonPos < len && (OtelTraceState.isLowerCaseAlpha(c = ts.charAt(colonPos)) || OtelTraceState.isDigit(c) && colonPos != startPos); ++colonPos) {
                }
                if (colonPos == startPos || colonPos == len || ts.charAt(colonPos) != ':') {
                    return new OtelTraceState();
                }
                for (separatorPos = colonPos + 1; separatorPos < len && OtelTraceState.isValueByte(ts.charAt(separatorPos)); ++separatorPos) {
                }
                if (colonPos - startPos == SUBKEY_THRESHOLD.length() && ts.startsWith(SUBKEY_THRESHOLD, startPos)) {
                    threshold = OtelTraceState.parseThreshold(ts, colonPos + 1, separatorPos);
                } else if (colonPos - startPos == SUBKEY_RANDOM_VALUE.length() && ts.startsWith(SUBKEY_RANDOM_VALUE, startPos)) {
                    randomValue = OtelTraceState.parseRandomValue(ts, colonPos + 1, separatorPos);
                } else {
                    if (otherKeyValuePairs == null) {
                        otherKeyValuePairs = new ArrayList<String>();
                    }
                    otherKeyValuePairs.add(ts.substring(startPos, separatorPos));
                }
                if (separatorPos < len && ts.charAt(separatorPos) != ';') {
                    return new OtelTraceState();
                }
                if (separatorPos == len) break block12;
            } while ((startPos = separatorPos + 1) != len);
            return new OtelTraceState();
        }
        return new OtelTraceState(randomValue, threshold, otherKeyValuePairs != null ? otherKeyValuePairs : Collections.emptyList());
    }
}

