/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.ComposableSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.OtelTraceState;
import io.opentelemetry.contrib.sampler.consistent56.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConsistentParentBasedSampler
extends ConsistentSampler {
    private final ComposableSampler rootSampler;
    private final String description;

    ConsistentParentBasedSampler(ComposableSampler rootSampler) {
        this.rootSampler = Objects.requireNonNull(rootSampler);
        this.description = "ConsistentParentBasedSampler{rootSampler=" + rootSampler.getDescription() + '}';
    }

    @Override
    public SamplingIntent getSamplingIntent(Context parentContext, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        boolean isRoot;
        Span parentSpan = Span.fromContext((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        boolean bl = isRoot = !parentSpanContext.isValid();
        if (isRoot) {
            return this.rootSampler.getSamplingIntent(parentContext, name, spanKind, attributes, parentLinks);
        }
        TraceState parentTraceState = parentSpanContext.getTraceState();
        String otelTraceStateString = parentTraceState.get("ot");
        OtelTraceState otelTraceState = OtelTraceState.parse(otelTraceStateString);
        long parentThreshold = otelTraceState.hasValidThreshold() ? otelTraceState.getThreshold() : ConsistentSamplingUtil.getInvalidThreshold();
        return () -> parentThreshold;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

