/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.RandomValueGenerator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import javax.annotation.concurrent.Immutable;

final class ConsistentRateLimitingSampler
extends ConsistentSampler {
    private static final double NANOS_IN_SECONDS = 1.0E-9;
    private final String description;
    private final LongSupplier nanoTimeSupplier;
    private final double inverseAdaptationTimeNanos;
    private final double targetSpansPerNanosecondLimit;
    private final AtomicReference<State> state;

    ConsistentRateLimitingSampler(double targetSpansPerSecondLimit, double adaptationTimeSeconds, RandomValueGenerator randomValueGenerator, LongSupplier nanoTimeSupplier) {
        super(randomValueGenerator);
        if (targetSpansPerSecondLimit < 0.0) {
            throw new IllegalArgumentException("Limit for sampled spans per second must be nonnegative!");
        }
        if (adaptationTimeSeconds < 0.0) {
            throw new IllegalArgumentException("Adaptation rate must be nonnegative!");
        }
        this.description = "ConsistentRateLimitingSampler{targetSpansPerSecondLimit=" + targetSpansPerSecondLimit + ", adaptationTimeSeconds=" + adaptationTimeSeconds + "}";
        this.nanoTimeSupplier = Objects.requireNonNull(nanoTimeSupplier);
        this.inverseAdaptationTimeNanos = 1.0E-9 / adaptationTimeSeconds;
        this.targetSpansPerNanosecondLimit = 1.0E-9 * targetSpansPerSecondLimit;
        this.state = new AtomicReference<State>(new State(0.0, 0.0, nanoTimeSupplier.getAsLong()));
    }

    private State updateState(State oldState, long currentNanoTime) {
        if (currentNanoTime <= oldState.lastNanoTime) {
            return new State(oldState.effectiveWindowCount + 1.0, oldState.effectiveWindowNanos, oldState.lastNanoTime);
        }
        long nanoTimeDelta = currentNanoTime - oldState.lastNanoTime;
        double decayFactor = Math.exp((double)(-nanoTimeDelta) * this.inverseAdaptationTimeNanos);
        double currentEffectiveWindowCount = oldState.effectiveWindowCount * decayFactor + 1.0;
        double currentEffectiveWindowNanos = oldState.effectiveWindowNanos * decayFactor + (double)nanoTimeDelta;
        return new State(currentEffectiveWindowCount, currentEffectiveWindowNanos, currentNanoTime);
    }

    @Override
    protected long getThreshold(long parentThreshold, boolean isRoot) {
        long currentNanoTime = this.nanoTimeSupplier.getAsLong();
        State currentState = this.state.updateAndGet(s -> this.updateState((State)s, currentNanoTime));
        double samplingProbability = currentState.effectiveWindowNanos * this.targetSpansPerNanosecondLimit / currentState.effectiveWindowCount;
        if (samplingProbability >= 1.0) {
            return ConsistentSamplingUtil.getMinThreshold();
        }
        return ConsistentSamplingUtil.calculateThreshold(samplingProbability);
    }

    public String getDescription() {
        return this.description;
    }

    @Immutable
    private static final class State {
        private final double effectiveWindowCount;
        private final double effectiveWindowNanos;
        private final long lastNanoTime;

        public State(double effectiveWindowCount, double effectiveWindowNanos, long lastNanoTime) {
            this.effectiveWindowCount = effectiveWindowCount;
            this.effectiveWindowNanos = effectiveWindowNanos;
            this.lastNanoTime = lastNanoTime;
        }
    }
}

