/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class ConsistentSamplingUtil {
    private static final int RANDOM_VALUE_BITS = 56;
    private static final long MAX_THRESHOLD = 0x100000000000000L;
    private static final long MAX_RANDOM_VALUE = 0xFFFFFFFFFFFFFFL;
    private static final long INVALID_THRESHOLD = -1L;
    private static final long INVALID_RANDOM_VALUE = -1L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ConsistentSamplingUtil() {
    }

    public static double calculateSamplingProbability(long threshold) {
        ConsistentSamplingUtil.checkThreshold(threshold);
        return (double)threshold * 1.3877787807814457E-17;
    }

    public static long calculateThreshold(double samplingProbability) {
        ConsistentSamplingUtil.checkProbability(samplingProbability);
        return Math.round(samplingProbability * 7.205759403792794E16);
    }

    public static double calculateAdjustedCount(long threshold) {
        if (ConsistentSamplingUtil.isValidThreshold(threshold)) {
            if (threshold > 0L) {
                return 7.205759403792794E16 / (double)threshold;
            }
            return 0.0;
        }
        return 1.0;
    }

    public static long getInvalidRandomValue() {
        return -1L;
    }

    public static long getInvalidThreshold() {
        return -1L;
    }

    public static long getMaxRandomValue() {
        return 0xFFFFFFFFFFFFFFL;
    }

    public static long getMaxThreshold() {
        return 0x100000000000000L;
    }

    public static boolean isValidRandomValue(long randomValue) {
        return 0L <= randomValue && randomValue <= ConsistentSamplingUtil.getMaxRandomValue();
    }

    public static boolean isValidThreshold(long threshold) {
        return 0L <= threshold && threshold <= ConsistentSamplingUtil.getMaxThreshold();
    }

    public static boolean isValidProbability(double probability) {
        return 0.0 <= probability && probability <= 1.0;
    }

    static void checkThreshold(long threshold) {
        if (!ConsistentSamplingUtil.isValidThreshold(threshold)) {
            throw new IllegalArgumentException("The threshold must be in the range [0,2^56]!");
        }
    }

    static void checkProbability(double probability) {
        if (!ConsistentSamplingUtil.isValidProbability(probability)) {
            throw new IllegalArgumentException("The probability must be in the range [0,1]!");
        }
    }

    @CanIgnoreReturnValue
    static StringBuilder appendLast56BitHexEncoded(StringBuilder sb, long l) {
        return ConsistentSamplingUtil.appendLast56BitHexEncodedHelper(sb, l, 0);
    }

    @CanIgnoreReturnValue
    static StringBuilder appendLast56BitHexEncodedWithoutTrailingZeros(StringBuilder sb, long l) {
        int numTrailingBits = Long.numberOfTrailingZeros(l | 0x80000000000000L);
        return ConsistentSamplingUtil.appendLast56BitHexEncodedHelper(sb, l, numTrailingBits);
    }

    @CanIgnoreReturnValue
    private static StringBuilder appendLast56BitHexEncodedHelper(StringBuilder sb, long l, int numTrailingZeroBits) {
        for (int i = 52; i >= numTrailingZeroBits - 3; i -= 4) {
            sb.append(HEX_DIGITS[(int)(l >>> i & 0xFL)]);
        }
        return sb;
    }
}

