/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.samplers;

import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongSupplier;

final class RandomGenerator {
    private final LongSupplier threadSafeRandomLongSupplier;
    private static final ThreadLocal<ThreadLocalData> THREAD_LOCAL_DATA = ThreadLocal.withInitial(() -> new ThreadLocalData());
    private static final RandomGenerator INSTANCE = new RandomGenerator(() -> ThreadLocalRandom.current().nextLong());

    private RandomGenerator(LongSupplier threadSafeRandomLongSupplier) {
        this.threadSafeRandomLongSupplier = Objects.requireNonNull(threadSafeRandomLongSupplier);
    }

    public static RandomGenerator create(LongSupplier threadSafeRandomLongSupplier) {
        return new RandomGenerator(threadSafeRandomLongSupplier);
    }

    public static RandomGenerator getDefault() {
        return INSTANCE;
    }

    public boolean nextBoolean(double probability) {
        return RandomGenerator.THREAD_LOCAL_DATA.get().generateRandomBoolean(this.threadSafeRandomLongSupplier, probability);
    }

    public int numberOfLeadingZerosOfRandomLong() {
        return RandomGenerator.THREAD_LOCAL_DATA.get().numberOfLeadingZerosOfRandomLong(this.threadSafeRandomLongSupplier);
    }

    private static final class ThreadLocalData {
        private long randomBits = 0L;
        private int bitCount = 0;

        private ThreadLocalData() {
        }

        private boolean nextRandomBit(LongSupplier threadSafeRandomLongSupplier) {
            if ((this.bitCount & 0x3F) == 0) {
                this.randomBits = threadSafeRandomLongSupplier.getAsLong();
            }
            boolean randomBit = (this.randomBits >>> this.bitCount & 1L) != 0L;
            ++this.bitCount;
            return randomBit;
        }

        private boolean generateRandomBoolean(LongSupplier threadSafeRandomLongSupplier, double probability) {
            while (!(probability <= 0.0)) {
                boolean b;
                if (probability >= 1.0) {
                    return true;
                }
                boolean bl = b = probability > 0.5;
                if (this.nextRandomBit(threadSafeRandomLongSupplier)) {
                    return b;
                }
                probability += probability;
                if (!b) continue;
                probability -= 1.0;
            }
            return false;
        }

        private int numberOfLeadingZerosOfRandomLong(LongSupplier threadSafeRandomLongSupplier) {
            int count;
            for (count = 0; count < 64 && this.nextRandomBit(threadSafeRandomLongSupplier); ++count) {
            }
            return count;
        }
    }
}

