/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.unsafe.ContextUtils;

final class CurrentTagMapUtils {
    private CurrentTagMapUtils() {
    }

    static TagContext getCurrentTagMap() {
        return ContextUtils.getValue((Context)Context.current());
    }

    static Scope withTagMap(TagContext tags) {
        return new WithTagMap(tags);
    }

    private static final class WithTagMap
    implements Scope {
        private final Context orig;

        private WithTagMap(TagContext tags) {
            this.orig = ContextUtils.withValue((Context)Context.current(), (TagContext)tags).attach();
        }

        public void close() {
            Context.current().detach(this.orig);
        }
    }
}

