/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.export;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.common.Duration;
import io.opencensus.implcore.internal.DaemonThreadFactory;
import io.opencensus.implcore.trace.RecordEventsSpanImpl;
import io.opencensus.trace.export.ExportComponent;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public final class SpanExporterImpl
extends SpanExporter {
    private static final Logger logger = Logger.getLogger(ExportComponent.class.getName());
    private final Worker worker;
    private final Thread workerThread;

    static SpanExporterImpl create(int bufferSize, Duration scheduleDelay) {
        Worker worker = new Worker(bufferSize, scheduleDelay);
        return new SpanExporterImpl(worker);
    }

    public void addSpan(RecordEventsSpanImpl span) {
        this.worker.addSpan(span);
    }

    public void registerHandler(String name, SpanExporter.Handler handler) {
        this.worker.registerHandler(name, handler);
    }

    public void unregisterHandler(String name) {
        this.worker.unregisterHandler(name);
    }

    void flush() {
        this.worker.flush();
    }

    void shutdown() {
        this.flush();
        this.workerThread.interrupt();
    }

    private SpanExporterImpl(Worker worker) {
        this.workerThread = new DaemonThreadFactory("ExportComponent.ServiceExporterThread").newThread(worker);
        this.workerThread.start();
        this.worker = worker;
    }

    @VisibleForTesting
    Thread getServiceExporterThread() {
        return this.workerThread;
    }

    private static final class Worker
    implements Runnable {
        private final Object monitor = new Object();
        @GuardedBy(value="monitor")
        private final List<RecordEventsSpanImpl> spans;
        private final Map<String, SpanExporter.Handler> serviceHandlers = new ConcurrentHashMap<String, SpanExporter.Handler>();
        private final int bufferSize;
        private final long scheduleDelayMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSpan(RecordEventsSpanImpl span) {
            Object object = this.monitor;
            synchronized (object) {
                this.spans.add(span);
                if (this.spans.size() > this.bufferSize) {
                    this.monitor.notifyAll();
                }
            }
        }

        private void registerHandler(String name, SpanExporter.Handler serviceHandler) {
            this.serviceHandlers.put(name, serviceHandler);
        }

        private void unregisterHandler(String name) {
            this.serviceHandlers.remove(name);
        }

        private void onBatchExport(List<SpanData> spanDataList) {
            for (Map.Entry<String, SpanExporter.Handler> it : this.serviceHandlers.entrySet()) {
                try {
                    it.getValue().export(spanDataList);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exception thrown by the service export " + it.getKey(), e);
                }
            }
        }

        private Worker(int bufferSize, Duration scheduleDelay) {
            this.spans = new ArrayList<RecordEventsSpanImpl>(bufferSize);
            this.bufferSize = bufferSize;
            this.scheduleDelayMillis = scheduleDelay.toMillis();
        }

        private static List<SpanData> fromSpanImplToSpanData(List<RecordEventsSpanImpl> spans) {
            ArrayList<SpanData> spanDatas = new ArrayList<SpanData>(spans.size());
            for (RecordEventsSpanImpl span : spans) {
                spanDatas.add(span.toSpanData());
            }
            return Collections.unmodifiableList(spanDatas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ArrayList<RecordEventsSpanImpl> spansCopy;
                Object object = this.monitor;
                synchronized (object) {
                    if (this.spans.size() < this.bufferSize) {
                        do {
                            try {
                                this.monitor.wait(this.scheduleDelayMillis);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        } while (this.spans.isEmpty());
                    }
                    spansCopy = new ArrayList<RecordEventsSpanImpl>(this.spans);
                    this.spans.clear();
                }
                List<SpanData> spanDataList = Worker.fromSpanImplToSpanData(spansCopy);
                if (spanDataList.isEmpty()) continue;
                this.onBatchExport(spanDataList);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flush() {
            ArrayList<RecordEventsSpanImpl> spansCopy;
            Object object = this.monitor;
            synchronized (object) {
                spansCopy = new ArrayList<RecordEventsSpanImpl>(this.spans);
                this.spans.clear();
            }
            List<SpanData> spanDataList = Worker.fromSpanImplToSpanData(spansCopy);
            if (!spanDataList.isEmpty()) {
                this.onBatchExport(spanDataList);
            }
        }
    }
}

