/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.temporary.metrics;

import io.opencensus.common.Timestamp;
import io.opencensus.implcore.temporary.metrics.AutoValue_Distribution;
import io.opencensus.implcore.temporary.metrics.AutoValue_Distribution_Bucket;
import io.opencensus.implcore.temporary.metrics.AutoValue_Distribution_Exemplar;
import io.opencensus.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Distribution {
    Distribution() {
    }

    public static Distribution create(double mean, long count, double sumOfSquaredDeviations, List<Double> bucketBoundaries, List<Bucket> buckets) {
        Utils.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count should be non-negative.");
        Utils.checkArgument((sumOfSquaredDeviations >= 0.0 ? 1 : 0) != 0, (Object)"sum of squared deviations should be non-negative.");
        if (count == 0L) {
            Utils.checkArgument((mean == 0.0 ? 1 : 0) != 0, (Object)"mean should be 0 if count is 0.");
            Utils.checkArgument((sumOfSquaredDeviations == 0.0 ? 1 : 0) != 0, (Object)"sum of squared deviations should be 0 if count is 0.");
        }
        return new AutoValue_Distribution(mean, count, sumOfSquaredDeviations, Distribution.copyBucketBounds(bucketBoundaries), Distribution.copyBucketCount(buckets));
    }

    private static List<Double> copyBucketBounds(List<Double> bucketBoundaries) {
        Utils.checkNotNull(bucketBoundaries, (Object)"bucketBoundaries list should not be null.");
        ArrayList<Double> bucketBoundariesCopy = new ArrayList<Double>(bucketBoundaries);
        if (bucketBoundariesCopy.size() > 1) {
            double lower = (Double)bucketBoundariesCopy.get(0);
            for (int i = 1; i < bucketBoundariesCopy.size(); ++i) {
                double next = (Double)bucketBoundariesCopy.get(i);
                Utils.checkArgument((lower < next ? 1 : 0) != 0, (Object)"bucket boundaries not sorted.");
                lower = next;
            }
        }
        return Collections.unmodifiableList(bucketBoundariesCopy);
    }

    private static List<Bucket> copyBucketCount(List<Bucket> buckets) {
        Utils.checkNotNull(buckets, (Object)"bucket list should not be null.");
        ArrayList<Bucket> bucketsCopy = new ArrayList<Bucket>(buckets);
        for (Bucket bucket : bucketsCopy) {
            Utils.checkNotNull((Object)bucket, (Object)"bucket should not be null.");
        }
        return Collections.unmodifiableList(bucketsCopy);
    }

    public abstract double getMean();

    public abstract long getCount();

    public abstract double getSumOfSquaredDeviations();

    public abstract List<Double> getBucketBoundaries();

    public abstract List<Bucket> getBuckets();

    @Immutable
    public static abstract class Exemplar {
        Exemplar() {
        }

        public abstract double getValue();

        public abstract Timestamp getTimestamp();

        public abstract Map<String, String> getAttachments();

        public static Exemplar create(double value, Timestamp timestamp, Map<String, String> attachments) {
            Utils.checkNotNull(attachments, (Object)"attachments");
            Map<String, String> attachmentsCopy = Collections.unmodifiableMap(new HashMap<String, String>(attachments));
            for (Map.Entry<String, String> entry : attachmentsCopy.entrySet()) {
                Utils.checkNotNull((Object)entry.getKey(), (Object)"key of attachments");
                Utils.checkNotNull((Object)entry.getValue(), (Object)"value of attachments");
            }
            return new AutoValue_Distribution_Exemplar(value, timestamp, attachmentsCopy);
        }
    }

    @Immutable
    public static abstract class Bucket {
        Bucket() {
        }

        public static Bucket create(long count) {
            Utils.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"bucket count should be non-negative.");
            return new AutoValue_Distribution_Bucket(count, null);
        }

        public static Bucket create(long count, Exemplar exemplar) {
            Utils.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"bucket count should be non-negative.");
            Utils.checkNotNull((Object)exemplar, (Object)"exemplar");
            return new AutoValue_Distribution_Bucket(count, exemplar);
        }

        public abstract long getCount();

        @Nullable
        public abstract Exemplar getExemplar();
    }
}

