/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.internal;

import com.google.common.base.Preconditions;
import io.opencensus.implcore.internal.CheckerFrameworkUtils;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentIntrusiveList<T extends Element<T>> {
    private int size = 0;
    @Nullable
    private T head = null;

    public synchronized void addElement(T element) {
        Preconditions.checkArgument((element.getNext() == null && element.getPrev() == null && element != this.head ? 1 : 0) != 0, (Object)"Element already in a list.");
        ++this.size;
        if (this.head == null) {
            this.head = element;
        } else {
            this.head.setPrev(element);
            element.setNext(this.head);
            this.head = element;
        }
    }

    public synchronized void removeElement(T element) {
        Preconditions.checkArgument((element.getNext() != null || element.getPrev() != null || element == this.head ? 1 : 0) != 0, (Object)"Element not in the list.");
        --this.size;
        if (element.getPrev() == null) {
            this.head = element.getNext();
            if (this.head != null) {
                this.head.setPrev(null);
                element.setNext(null);
            }
        } else if (element.getNext() == null) {
            ((Element)CheckerFrameworkUtils.castNonNull(element.getPrev())).setNext(null);
            element.setPrev(null);
        } else {
            ((Element)CheckerFrameworkUtils.castNonNull(element.getPrev())).setNext(element.getNext());
            ((Element)CheckerFrameworkUtils.castNonNull(element.getNext())).setPrev(element.getPrev());
            element.setNext(null);
            element.setPrev(null);
        }
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized Collection<T> getAll() {
        ArrayList<T> all = new ArrayList<T>(this.size);
        for (T e = this.head; e != null; e = e.getNext()) {
            all.add(e);
        }
        return all;
    }

    public static interface Element<T extends Element<T>> {
        @Nullable
        public T getNext();

        public void setNext(@Nullable T var1);

        @Nullable
        public T getPrev();

        public void setPrev(@Nullable T var1);
    }
}

