/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.opencensus.common.Duration;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.implcore.internal.CheckerFrameworkUtils;
import io.opencensus.implcore.stats.IntervalBucket;
import io.opencensus.implcore.stats.MutableAggregation;
import io.opencensus.implcore.tags.TagContextImpl;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.Measure;
import io.opencensus.stats.StatsCollectionState;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

abstract class MutableViewData {
    @Nullable
    @VisibleForTesting
    static final TagValue UNKNOWN_TAG_VALUE = null;
    @VisibleForTesting
    static final Timestamp ZERO_TIMESTAMP = Timestamp.create((long)0L, (int)0);
    private final View view;

    private MutableViewData(View view) {
        this.view = view;
    }

    static MutableViewData create(View view, Timestamp start) {
        return (MutableViewData)view.getWindow().match((Function)new CreateCumulative(view, start), (Function)new CreateInterval(view, start), Functions.throwAssertionError());
    }

    View getView() {
        return this.view;
    }

    abstract void record(TagContext var1, double var2, Timestamp var4);

    void record(TagContext tags, long value, Timestamp timestamp) {
        this.record(tags, (double)value, timestamp);
    }

    abstract ViewData toViewData(Timestamp var1, StatsCollectionState var2);

    abstract void clearStats();

    abstract void resumeStatsCollection(Timestamp var1);

    private static Map<TagKey, TagValue> getTagMap(TagContext ctx) {
        if (ctx instanceof TagContextImpl) {
            return ((TagContextImpl)ctx).getTags();
        }
        HashMap tags = Maps.newHashMap();
        Iterator i = InternalUtils.getTags((TagContext)ctx);
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            tags.put(tag.getKey(), tag.getValue());
        }
        return tags;
    }

    @VisibleForTesting
    static List<TagValue> getTagValues(Map<? extends TagKey, ? extends TagValue> tags, List<? extends TagKey> columns) {
        ArrayList<TagValue> tagValues = new ArrayList<TagValue>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            TagKey tagKey = columns.get(i);
            if (!tags.containsKey(tagKey)) {
                tagValues.add(UNKNOWN_TAG_VALUE);
                continue;
            }
            tagValues.add(tags.get(tagKey));
        }
        return tagValues;
    }

    @VisibleForTesting
    static MutableAggregation createMutableAggregation(Aggregation aggregation) {
        return (MutableAggregation)aggregation.match((Function)CreateMutableSum.INSTANCE, (Function)CreateMutableCount.INSTANCE, (Function)CreateMutableDistribution.INSTANCE, (Function)CreateMutableLastValue.INSTANCE, (Function)AggregationDefaultFunction.INSTANCE);
    }

    @VisibleForTesting
    static AggregationData createAggregationData(MutableAggregation aggregation, Measure measure) {
        return aggregation.match(new CreateSumData(measure), CreateCountData.INSTANCE, CreateMeanData.INSTANCE, CreateDistributionData.INSTANCE, new CreateLastValueData(measure));
    }

    private static <T> Map<T, AggregationData> createAggregationMap(Map<T, MutableAggregation> tagValueAggregationMap, Measure measure) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<T, MutableAggregation> entry : tagValueAggregationMap.entrySet()) {
            map.put(entry.getKey(), MutableViewData.createAggregationData(entry.getValue(), measure));
        }
        return map;
    }

    private static final class CreateInterval
    implements Function<View.AggregationWindow.Interval, MutableViewData> {
        private final View view;
        private final Timestamp start;

        public MutableViewData apply(View.AggregationWindow.Interval arg) {
            return new IntervalMutableViewData(this.view, this.start);
        }

        private CreateInterval(View view, Timestamp start) {
            this.view = view;
            this.start = start;
        }
    }

    private static final class CreateCumulative
    implements Function<View.AggregationWindow.Cumulative, MutableViewData> {
        private final View view;
        private final Timestamp start;

        public MutableViewData apply(View.AggregationWindow.Cumulative arg) {
            return new CumulativeMutableViewData(this.view, this.start);
        }

        private CreateCumulative(View view, Timestamp start) {
            this.view = view;
            this.start = start;
        }
    }

    private static final class CreateLastValueData
    implements Function<MutableAggregation.MutableLastValue, AggregationData> {
        private final Measure measure;

        private CreateLastValueData(Measure measure) {
            this.measure = measure;
        }

        public AggregationData apply(MutableAggregation.MutableLastValue arg) {
            return (AggregationData)this.measure.match(Functions.returnConstant((Object)AggregationData.LastValueDataDouble.create((double)arg.getLastValue())), Functions.returnConstant((Object)AggregationData.LastValueDataLong.create((long)Math.round(arg.getLastValue()))), Functions.throwAssertionError());
        }
    }

    private static final class CreateDistributionData
    implements Function<MutableAggregation.MutableDistribution, AggregationData> {
        private static final CreateDistributionData INSTANCE = new CreateDistributionData();

        private CreateDistributionData() {
        }

        public AggregationData apply(MutableAggregation.MutableDistribution arg) {
            ArrayList<Long> boxedBucketCounts = new ArrayList<Long>();
            for (long bucketCount : arg.getBucketCounts()) {
                boxedBucketCounts.add(bucketCount);
            }
            return AggregationData.DistributionData.create((double)arg.getMean(), (long)arg.getCount(), (double)arg.getMin(), (double)arg.getMax(), (double)arg.getSumOfSquaredDeviations(), boxedBucketCounts);
        }
    }

    private static final class CreateMeanData
    implements Function<MutableAggregation.MutableMean, AggregationData> {
        private static final CreateMeanData INSTANCE = new CreateMeanData();

        private CreateMeanData() {
        }

        public AggregationData apply(MutableAggregation.MutableMean arg) {
            return AggregationData.MeanData.create((double)arg.getMean(), (long)arg.getCount());
        }
    }

    private static final class CreateCountData
    implements Function<MutableAggregation.MutableCount, AggregationData> {
        private static final CreateCountData INSTANCE = new CreateCountData();

        private CreateCountData() {
        }

        public AggregationData apply(MutableAggregation.MutableCount arg) {
            return AggregationData.CountData.create((long)arg.getCount());
        }
    }

    private static final class CreateSumData
    implements Function<MutableAggregation.MutableSum, AggregationData> {
        private final Measure measure;

        private CreateSumData(Measure measure) {
            this.measure = measure;
        }

        public AggregationData apply(MutableAggregation.MutableSum arg) {
            return (AggregationData)this.measure.match(Functions.returnConstant((Object)AggregationData.SumDataDouble.create((double)arg.getSum())), Functions.returnConstant((Object)AggregationData.SumDataLong.create((long)Math.round(arg.getSum()))), Functions.throwAssertionError());
        }
    }

    private static final class CreateMutableLastValue
    implements Function<Aggregation.LastValue, MutableAggregation> {
        private static final CreateMutableLastValue INSTANCE = new CreateMutableLastValue();

        private CreateMutableLastValue() {
        }

        public MutableAggregation apply(Aggregation.LastValue arg) {
            return MutableAggregation.MutableLastValue.create();
        }
    }

    private static final class CreateMutableDistribution
    implements Function<Aggregation.Distribution, MutableAggregation> {
        private static final CreateMutableDistribution INSTANCE = new CreateMutableDistribution();

        private CreateMutableDistribution() {
        }

        public MutableAggregation apply(Aggregation.Distribution arg) {
            return MutableAggregation.MutableDistribution.create(arg.getBucketBoundaries());
        }
    }

    private static final class AggregationDefaultFunction
    implements Function<Aggregation, MutableAggregation> {
        private static final AggregationDefaultFunction INSTANCE = new AggregationDefaultFunction();

        private AggregationDefaultFunction() {
        }

        public MutableAggregation apply(Aggregation arg) {
            if (arg instanceof Aggregation.Mean) {
                return MutableAggregation.MutableMean.create();
            }
            throw new IllegalArgumentException("Unknown Aggregation.");
        }
    }

    private static final class CreateMutableCount
    implements Function<Aggregation.Count, MutableAggregation> {
        private static final CreateMutableCount INSTANCE = new CreateMutableCount();

        private CreateMutableCount() {
        }

        public MutableAggregation apply(Aggregation.Count arg) {
            return MutableAggregation.MutableCount.create();
        }
    }

    private static final class CreateMutableSum
    implements Function<Aggregation.Sum, MutableAggregation> {
        private static final CreateMutableSum INSTANCE = new CreateMutableSum();

        private CreateMutableSum() {
        }

        public MutableAggregation apply(Aggregation.Sum arg) {
            return MutableAggregation.MutableSum.create();
        }
    }

    private static final class IntervalMutableViewData
    extends MutableViewData {
        private static final int N = 4;
        private final LinkedList<IntervalBucket> buckets = new LinkedList();
        private final Duration totalDuration;
        private final Duration bucketDuration;

        private IntervalMutableViewData(View view, Timestamp start) {
            super(view);
            Duration totalDuration;
            this.totalDuration = totalDuration = ((View.AggregationWindow.Interval)view.getWindow()).getDuration();
            this.bucketDuration = Duration.fromMillis((long)(totalDuration.toMillis() / 4L));
            this.shiftBucketList(5L, start);
        }

        @Override
        void record(TagContext context, double value, Timestamp timestamp) {
            List<TagValue> tagValues = IntervalMutableViewData.getTagValues(MutableViewData.getTagMap(context), ((MutableViewData)this).view.getColumns());
            this.refreshBucketList(timestamp);
            CheckerFrameworkUtils.castNonNull(this.buckets.peekLast()).record(tagValues, value);
        }

        @Override
        ViewData toViewData(Timestamp now, StatsCollectionState state) {
            this.refreshBucketList(now);
            if (state == StatsCollectionState.ENABLED) {
                return ViewData.create((View)((MutableViewData)this).view, this.combineBucketsAndGetAggregationMap(now), (ViewData.AggregationWindowData)ViewData.AggregationWindowData.IntervalData.create((Timestamp)now));
            }
            return ViewData.create((View)((MutableViewData)this).view, Collections.emptyMap(), (ViewData.AggregationWindowData)ViewData.AggregationWindowData.IntervalData.create((Timestamp)ZERO_TIMESTAMP));
        }

        @Override
        void clearStats() {
            for (IntervalBucket bucket : this.buckets) {
                bucket.clearStats();
            }
        }

        @Override
        void resumeStatsCollection(Timestamp now) {
            this.refreshBucketList(now);
        }

        private void refreshBucketList(Timestamp now) {
            if (this.buckets.size() != 5) {
                throw new AssertionError((Object)"Bucket list must have exactly 5 buckets.");
            }
            Timestamp startOfLastBucket = CheckerFrameworkUtils.castNonNull(this.buckets.peekLast()).getStart();
            Preconditions.checkArgument((now.compareTo(startOfLastBucket) >= 0 ? 1 : 0) != 0, (Object)"Current time must be within or after the last bucket.");
            long elapsedTimeMillis = now.subtractTimestamp(startOfLastBucket).toMillis();
            long numOfPadBuckets = elapsedTimeMillis / this.bucketDuration.toMillis();
            this.shiftBucketList(numOfPadBuckets, now);
        }

        private void shiftBucketList(long numOfPadBuckets, Timestamp now) {
            Timestamp startOfNewBucket = !this.buckets.isEmpty() ? CheckerFrameworkUtils.castNonNull(this.buckets.peekLast()).getStart().addDuration(this.bucketDuration) : IntervalMutableViewData.subtractDuration(now, this.totalDuration);
            if (numOfPadBuckets > 5L) {
                startOfNewBucket = IntervalMutableViewData.subtractDuration(now, this.totalDuration);
                numOfPadBuckets = 5L;
            }
            int i = 0;
            while ((long)i < numOfPadBuckets) {
                this.buckets.add(new IntervalBucket(startOfNewBucket, this.bucketDuration, ((MutableViewData)this).view.getAggregation()));
                startOfNewBucket = startOfNewBucket.addDuration(this.bucketDuration);
                ++i;
            }
            while (this.buckets.size() > 5) {
                this.buckets.pollFirst();
            }
        }

        private Map<List<TagValue>, AggregationData> combineBucketsAndGetAggregationMap(Timestamp now) {
            LinkedHashMultimap multimap = LinkedHashMultimap.create();
            LinkedList<IntervalBucket> shallowCopy = new LinkedList<IntervalBucket>(this.buckets);
            Aggregation aggregation = ((MutableViewData)this).view.getAggregation();
            IntervalMutableViewData.putBucketsIntoMultiMap(shallowCopy, (Multimap<List<TagValue>, MutableAggregation>)multimap, aggregation, now);
            Map singleMap = IntervalMutableViewData.aggregateOnEachTagValueList(multimap, aggregation);
            return MutableViewData.createAggregationMap(singleMap, super.getView().getMeasure());
        }

        private static void putBucketsIntoMultiMap(LinkedList<IntervalBucket> buckets, Multimap<List<TagValue>, MutableAggregation> multimap, Aggregation aggregation, Timestamp now) {
            IntervalBucket head = CheckerFrameworkUtils.castNonNull(buckets.peekFirst());
            IntervalBucket tail = CheckerFrameworkUtils.castNonNull(buckets.peekLast());
            double fractionTail = tail.getFraction(now);
            Preconditions.checkArgument((0.0 <= fractionTail && fractionTail <= 1.0 ? 1 : 0) != 0, (Object)("Fraction " + fractionTail + " should be within [0.0, 1.0]."));
            double fractionHead = 1.0 - fractionTail;
            IntervalMutableViewData.putFractionalMutableAggregationsToMultiMap(head.getTagValueAggregationMap(), multimap, aggregation, fractionHead);
            boolean shouldSkipFirst = true;
            for (IntervalBucket bucket : buckets) {
                if (shouldSkipFirst) {
                    shouldSkipFirst = false;
                    continue;
                }
                for (Map.Entry<List<TagValue>, MutableAggregation> entry : bucket.getTagValueAggregationMap().entrySet()) {
                    multimap.put(entry.getKey(), (Object)entry.getValue());
                }
            }
        }

        private static <T> void putFractionalMutableAggregationsToMultiMap(Map<T, MutableAggregation> mutableAggrMap, Multimap<T, MutableAggregation> multimap, Aggregation aggregation, double fraction) {
            for (Map.Entry<T, MutableAggregation> entry : mutableAggrMap.entrySet()) {
                MutableAggregation fractionalMutableAgg = IntervalMutableViewData.createMutableAggregation(aggregation);
                fractionalMutableAgg.combine(entry.getValue(), fraction);
                multimap.put(entry.getKey(), (Object)fractionalMutableAgg);
            }
        }

        private static <T> Map<T, MutableAggregation> aggregateOnEachTagValueList(Multimap<T, MutableAggregation> multimap, Aggregation aggregation) {
            HashMap map = Maps.newHashMap();
            for (Object tagValues : multimap.keySet()) {
                MutableAggregation combinedAggregation = IntervalMutableViewData.createMutableAggregation(aggregation);
                for (MutableAggregation mutableAggregation : multimap.get(tagValues)) {
                    combinedAggregation.combine(mutableAggregation, 1.0);
                }
                map.put(tagValues, combinedAggregation);
            }
            return map;
        }

        private static Timestamp subtractDuration(Timestamp timestamp, Duration duration) {
            return timestamp.addDuration(Duration.create((long)(-duration.getSeconds()), (int)(-duration.getNanos())));
        }
    }

    private static final class CumulativeMutableViewData
    extends MutableViewData {
        private Timestamp start;
        private final Map<List<TagValue>, MutableAggregation> tagValueAggregationMap = Maps.newHashMap();

        private CumulativeMutableViewData(View view, Timestamp start) {
            super(view);
            this.start = start;
        }

        @Override
        void record(TagContext context, double value, Timestamp timestamp) {
            List<TagValue> tagValues = CumulativeMutableViewData.getTagValues(MutableViewData.getTagMap(context), ((MutableViewData)this).view.getColumns());
            if (!this.tagValueAggregationMap.containsKey(tagValues)) {
                this.tagValueAggregationMap.put(tagValues, CumulativeMutableViewData.createMutableAggregation(((MutableViewData)this).view.getAggregation()));
            }
            this.tagValueAggregationMap.get(tagValues).add(value);
        }

        @Override
        ViewData toViewData(Timestamp now, StatsCollectionState state) {
            if (state == StatsCollectionState.ENABLED) {
                return ViewData.create((View)((MutableViewData)this).view, (Map)MutableViewData.createAggregationMap(this.tagValueAggregationMap, ((MutableViewData)this).view.getMeasure()), (ViewData.AggregationWindowData)ViewData.AggregationWindowData.CumulativeData.create((Timestamp)this.start, (Timestamp)now));
            }
            return ViewData.create((View)((MutableViewData)this).view, Collections.emptyMap(), (ViewData.AggregationWindowData)ViewData.AggregationWindowData.CumulativeData.create((Timestamp)ZERO_TIMESTAMP, (Timestamp)ZERO_TIMESTAMP));
        }

        @Override
        void clearStats() {
            this.tagValueAggregationMap.clear();
        }

        @Override
        void resumeStatsCollection(Timestamp now) {
            this.start = now;
        }
    }
}

