/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags.propagation;

import io.opencensus.implcore.tags.CurrentTaggingState;
import io.opencensus.implcore.tags.TagContextImpl;
import io.opencensus.implcore.tags.propagation.SerializationUtils;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TaggingState;
import io.opencensus.tags.propagation.TagContextBinarySerializer;
import io.opencensus.tags.propagation.TagContextDeserializationException;
import io.opencensus.tags.propagation.TagContextSerializationException;

final class TagContextBinarySerializerImpl
extends TagContextBinarySerializer {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final CurrentTaggingState state;

    TagContextBinarySerializerImpl(CurrentTaggingState state) {
        this.state = state;
    }

    public byte[] toByteArray(TagContext tags) throws TagContextSerializationException {
        return this.state.getInternal() == TaggingState.DISABLED ? EMPTY_BYTE_ARRAY : SerializationUtils.serializeBinary(tags);
    }

    public TagContext fromByteArray(byte[] bytes) throws TagContextDeserializationException {
        return this.state.getInternal() == TaggingState.DISABLED ? TagContextImpl.EMPTY : SerializationUtils.deserializeBinary(bytes);
    }
}

