/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.stackdriver;

import com.google.auth.Credentials;
import com.google.cloud.ServiceOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.exporter.trace.stackdriver.StackdriverV2ExporterHandler;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import java.io.IOException;
import javax.annotation.concurrent.GuardedBy;

public final class StackdriverExporter {
    private static final String REGISTER_NAME = StackdriverExporter.class.getName();
    private static final Object monitor = new Object();
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegisterWithCredentialsAndProjectId(Credentials credentials, String projectId) throws IOException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Stackdriver exporter is already registered.");
            handler = StackdriverV2ExporterHandler.createWithCredentials(credentials, projectId);
            StackdriverExporter.register(Tracing.getExportComponent().getSpanExporter(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegisterWithProjectId(String projectId) throws IOException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Stackdriver exporter is already registered.");
            handler = StackdriverV2ExporterHandler.create(projectId);
            StackdriverExporter.register(Tracing.getExportComponent().getSpanExporter(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister() throws IOException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Stackdriver exporter is already registered.");
            handler = StackdriverV2ExporterHandler.create(ServiceOptions.getDefaultProjectId());
            StackdriverExporter.register(Tracing.getExportComponent().getSpanExporter(), handler);
        }
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler != null ? 1 : 0) != 0, (Object)"Stackdriver exporter is not registered.");
            StackdriverExporter.unregister(Tracing.getExportComponent().getSpanExporter());
            handler = null;
        }
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }

    private StackdriverExporter() {
    }
}

