/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.logcorrelation.stackdriver;

import com.google.cloud.ServiceOptions;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.unsafe.ContextUtils;
import java.util.logging.LogManager;
import javax.annotation.Nullable;

public final class OpenCensusTraceLoggingEnhancer
implements LoggingEnhancer {
    public static final String PROJECT_ID_PROPERTY_NAME = "io.opencensus.contrib.logcorrelation.stackdriver.OpenCensusTraceLoggingEnhancer.projectId";
    @Nullable
    private final String projectId;
    private final String tracePrefix;

    public OpenCensusTraceLoggingEnhancer() {
        this(OpenCensusTraceLoggingEnhancer.lookUpProjectId());
    }

    OpenCensusTraceLoggingEnhancer(@Nullable String projectId) {
        this.projectId = projectId;
        this.tracePrefix = "projects/" + (projectId == null ? "" : projectId) + "/traces/";
    }

    @Nullable
    private static String lookUpProjectId() {
        String projectIdProperty = OpenCensusTraceLoggingEnhancer.lookUpProperty(PROJECT_ID_PROPERTY_NAME);
        return projectIdProperty == null || projectIdProperty.isEmpty() ? ServiceOptions.getDefaultProjectId() : projectIdProperty;
    }

    @Nullable
    private static String lookUpProperty(String name) {
        String property = LogManager.getLogManager().getProperty(name);
        return property == null || property.isEmpty() ? System.getProperty(name) : property;
    }

    @Nullable
    String getProjectId() {
        return this.projectId;
    }

    public void enhanceLogEntry(LogEntry.Builder builder) {
        OpenCensusTraceLoggingEnhancer.addTracingData(this.tracePrefix, OpenCensusTraceLoggingEnhancer.getCurrentSpanContext(), builder);
    }

    private static SpanContext getCurrentSpanContext() {
        Span span = (Span)ContextUtils.CONTEXT_SPAN_KEY.get();
        return span == null ? SpanContext.INVALID : span.getContext();
    }

    private static void addTracingData(String tracePrefix, SpanContext span, LogEntry.Builder builder) {
        builder.setTrace(OpenCensusTraceLoggingEnhancer.formatTraceId(tracePrefix, span.getTraceId()));
        builder.setSpanId(span.getSpanId().toLowerBase16());
        builder.setTraceSampled(span.getTraceOptions().isSampled());
    }

    private static String formatTraceId(String tracePrefix, TraceId traceId) {
        return tracePrefix + traceId.toLowerBase16();
    }
}

