/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import io.grpc.Context;
import io.opencensus.common.NonThrowingCloseable;
import io.opencensus.trace.Span;

public final class ContextUtils {
    public static final Context.Key<Span> CONTEXT_SPAN_KEY = Context.key((String)"instrumentation-trace-key");

    private ContextUtils() {
    }

    static Span getCurrentSpan() {
        return (Span)CONTEXT_SPAN_KEY.get(Context.current());
    }

    static NonThrowingCloseable withSpan(Span span) {
        return new WithSpan(span, CONTEXT_SPAN_KEY);
    }

    private static final class WithSpan
    implements NonThrowingCloseable {
        private final Context origContext;

        WithSpan(Span span, Context.Key<Span> contextKey) {
            this.origContext = Context.current().withValue(contextKey, (Object)span).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.origContext);
        }
    }
}

