/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import io.opencensus.internal.Utils;
import java.util.Arrays;

final class LowerCaseBase16Encoding {
    private static final String ALPHABET = "0123456789abcdef";
    private static final int ASCII_CHARACTERS = 128;
    private static final char[] ENCODING = LowerCaseBase16Encoding.buildEncodingArray();
    private static final byte[] DECODING = LowerCaseBase16Encoding.buildDecodingArray();

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    static String encodeToString(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder(bytes.length * 2);
        for (byte byteVal : bytes) {
            int b = byteVal & 0xFF;
            stringBuilder.append(ENCODING[b]);
            stringBuilder.append(ENCODING[b | 0x100]);
        }
        return stringBuilder.toString();
    }

    static byte[] decodeToBytes(CharSequence chars) {
        Utils.checkArgument(chars.length() % 2 == 0, "Invalid input length " + chars.length());
        int bytesWritten = 0;
        byte[] bytes = new byte[chars.length() / 2];
        for (int i = 0; i < chars.length(); i += 2) {
            bytes[bytesWritten++] = LowerCaseBase16Encoding.decodeByte(chars.charAt(i), chars.charAt(i + 1));
        }
        return bytes;
    }

    private static byte decodeByte(char hi, char lo) {
        Utils.checkArgument(lo < '\u0080' && DECODING[lo] != -1, "Invalid character " + lo);
        Utils.checkArgument(hi < '\u0080' && DECODING[hi] != -1, "Invalid character " + hi);
        int decoded = DECODING[hi] << 4 | DECODING[lo];
        return (byte)decoded;
    }

    private LowerCaseBase16Encoding() {
    }
}

