/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.BoxStore;
import io.objectbox.Cursor;
import io.objectbox.EntityInfo;
import io.objectbox.KeyValueCursor;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.exception.DbException;
import io.objectbox.internal.CursorFactory;
import java.io.Closeable;
import javax.annotation.concurrent.NotThreadSafe;

@Internal
@NotThreadSafe
public class Transaction
implements Closeable {
    @Internal
    static boolean TRACK_CREATION_STACK;
    private final long transaction;
    private final BoxStore store;
    private final boolean readOnly;
    private final Throwable creationThrowable;
    private int initialCommitCount;
    private volatile boolean closed;

    native void nativeDestroy(long var1);

    native int[] nativeCommit(long var1);

    native void nativeAbort(long var1);

    native void nativeReset(long var1);

    native void nativeRecycle(long var1);

    native void nativeRenew(long var1);

    native long nativeCreateKeyValueCursor(long var1);

    native long nativeCreateCursor(long var1, String var3, Class<?> var4);

    native boolean nativeIsActive(long var1);

    native boolean nativeIsOwnerThread(long var1);

    native boolean nativeIsRecycled(long var1);

    native boolean nativeIsReadOnly(long var1);

    public Transaction(BoxStore store, long transaction, int initialCommitCount) {
        this.store = store;
        this.transaction = transaction;
        this.initialCommitCount = initialCommitCount;
        this.readOnly = this.nativeIsReadOnly(transaction);
        this.creationThrowable = TRACK_CREATION_STACK ? new Throwable() : null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("Transaction is closed");
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            boolean isActive;
            this.closed = true;
            this.store.unregisterTransaction(this);
            boolean isOwnerThread = this.nativeIsOwnerThread(this.transaction);
            if (!isOwnerThread) {
                isActive = this.nativeIsActive(this.transaction);
                boolean isRecycled = this.nativeIsRecycled(this.transaction);
                if (isActive || isRecycled) {
                    String msgPostfix = " (initial commit count: " + this.initialCommitCount + ").";
                    if (isActive) {
                        System.err.println("Transaction is still active" + msgPostfix);
                    } else {
                        System.out.println("Hint: use closeThreadResources() to avoid finalizing recycled transactions" + msgPostfix);
                        System.out.flush();
                    }
                    if (this.creationThrowable != null) {
                        System.err.println("Transaction was initially created here:");
                        this.creationThrowable.printStackTrace();
                    }
                    System.err.flush();
                }
            }
            if (!this.store.isNativeStoreClosed()) {
                this.nativeDestroy(this.transaction);
            } else {
                isActive = this.nativeIsActive(this.transaction);
                if (this.readOnly) {
                    System.out.printf("Info: closing read transaction after store was closed (isActive=%s, isOwnerThread=%s), this should be avoided.%n", isActive, isOwnerThread);
                    System.out.flush();
                    if (!this.nativeIsActive(this.transaction)) {
                        this.nativeDestroy(this.transaction);
                    }
                } else {
                    System.out.printf("WARN: closing write transaction after store was closed (isActive=%s, isOwnerThread=%s), this must be avoided.%n", isActive, isOwnerThread);
                    System.out.flush();
                    if (this.nativeIsActive(this.transaction) && this.store.isNativeStoreDestroyed()) {
                        throw new IllegalStateException("Internal error: cannot close active write transaction for an already destroyed store");
                    }
                    this.nativeDestroy(this.transaction);
                }
            }
        }
    }

    public void commit() {
        this.checkOpen();
        int[] entityTypeIdsAffected = this.nativeCommit(this.transaction);
        this.store.txCommitted(this, entityTypeIdsAffected);
    }

    public void commitAndClose() {
        this.commit();
        this.close();
    }

    public void abort() {
        this.checkOpen();
        this.nativeAbort(this.transaction);
    }

    @Experimental
    public void reset() {
        this.checkOpen();
        this.initialCommitCount = this.store.commitCount;
        this.nativeReset(this.transaction);
    }

    public void recycle() {
        this.checkOpen();
        this.nativeRecycle(this.transaction);
    }

    public void renew() {
        this.checkOpen();
        this.initialCommitCount = this.store.commitCount;
        this.nativeRenew(this.transaction);
    }

    public KeyValueCursor createKeyValueCursor() {
        this.checkOpen();
        long cursor = this.nativeCreateKeyValueCursor(this.transaction);
        return new KeyValueCursor(cursor);
    }

    public <T> Cursor<T> createCursor(Class<T> entityClass) {
        this.checkOpen();
        EntityInfo<T> entityInfo = this.store.getEntityInfo(entityClass);
        CursorFactory<T> factory = entityInfo.getCursorFactory();
        long cursorHandle = this.nativeCreateCursor(this.transaction, entityInfo.getDbName(), entityClass);
        if (cursorHandle == 0L) {
            throw new DbException("Could not create native cursor");
        }
        return factory.createCursor(this, cursorHandle, this.store);
    }

    public BoxStore getStore() {
        return this.store;
    }

    public boolean isActive() {
        return !this.closed && this.nativeIsActive(this.transaction);
    }

    public boolean isRecycled() {
        this.checkOpen();
        return this.nativeIsRecycled(this.transaction);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isObsolete() {
        return this.initialCommitCount != this.store.commitCount;
    }

    @Internal
    long internalHandle() {
        return this.transaction;
    }

    public String toString() {
        return "TX " + Long.toString(this.transaction, 16) + " (" + (this.readOnly ? "read-only" : "write") + ", initialCommitCount=" + this.initialCommitCount + ")";
    }
}

