/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.annotation.apihint.Internal;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.model.HnswParams;
import io.objectbox.model.IdUid;
import io.objectbox.model.Model;
import io.objectbox.model.ModelEntity;
import io.objectbox.model.ModelProperty;
import io.objectbox.model.ModelRelation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@Internal
public class ModelBuilder {
    private static final int MODEL_VERSION = 2;
    private static final String DEFAULT_NAME = "default";
    private static final int DEFAULT_VERSION = 1;
    private final FlatBufferBuilder fbb = new FlatBufferBuilder();
    private final List<Integer> entityOffsets = new ArrayList<Integer>();
    private long version = 1L;
    private Integer lastEntityId;
    private Long lastEntityUid;
    private Integer lastIndexId;
    private Long lastIndexUid;
    private Integer lastRelationId;
    private Long lastRelationUid;

    private int createVector(List<Integer> offsets) {
        int[] offsetArray = new int[offsets.size()];
        for (int i = 0; i < offsets.size(); ++i) {
            offsetArray[i] = offsets.get(i);
        }
        return this.fbb.createVectorOfTables(offsetArray);
    }

    public ModelBuilder version(long version) {
        this.version = version;
        return this;
    }

    public EntityBuilder entity(String name) {
        return new EntityBuilder(this, this.fbb, name);
    }

    public ModelBuilder lastEntityId(int lastEntityId, long lastEntityUid) {
        this.lastEntityId = lastEntityId;
        this.lastEntityUid = lastEntityUid;
        return this;
    }

    public ModelBuilder lastIndexId(int lastIndexId, long lastIndexUid) {
        this.lastIndexId = lastIndexId;
        this.lastIndexUid = lastIndexUid;
        return this;
    }

    public ModelBuilder lastRelationId(int lastRelationId, long lastRelationUid) {
        this.lastRelationId = lastRelationId;
        this.lastRelationUid = lastRelationUid;
        return this;
    }

    public byte[] build() {
        int idOffset;
        int nameOffset = this.fbb.createString(DEFAULT_NAME);
        int entityVectorOffset = this.createVector(this.entityOffsets);
        Model.startModel(this.fbb);
        Model.addName(this.fbb, nameOffset);
        Model.addModelVersion(this.fbb, 2L);
        Model.addVersion(this.fbb, this.version);
        Model.addEntities(this.fbb, entityVectorOffset);
        if (this.lastEntityId != null) {
            idOffset = IdUid.createIdUid(this.fbb, this.lastEntityId.intValue(), this.lastEntityUid);
            Model.addLastEntityId(this.fbb, idOffset);
        }
        if (this.lastIndexId != null) {
            idOffset = IdUid.createIdUid(this.fbb, this.lastIndexId.intValue(), this.lastIndexUid);
            Model.addLastIndexId(this.fbb, idOffset);
        }
        if (this.lastRelationId != null) {
            idOffset = IdUid.createIdUid(this.fbb, this.lastRelationId.intValue(), this.lastRelationUid);
            Model.addLastRelationId(this.fbb, idOffset);
        }
        int offset = Model.endModel(this.fbb);
        this.fbb.finish(offset);
        return this.fbb.sizedByteArray();
    }

    public static class EntityBuilder
    extends PartBuilder {
        private final ModelBuilder model;
        private final String name;
        private final List<Integer> propertyOffsets = new ArrayList<Integer>();
        private final List<Integer> relationOffsets = new ArrayList<Integer>();
        private Integer id;
        private Long uid;
        private Integer lastPropertyId;
        private Long lastPropertyUid;
        @Nullable
        private String externalName;
        private Integer flags;
        @Nullable
        private PropertyBuilder propertyBuilder;
        @Nullable
        private RelationBuilder relationBuilder;

        private EntityBuilder(ModelBuilder model, FlatBufferBuilder fbb, String name) {
            super(fbb);
            this.model = model;
            this.name = name;
        }

        public EntityBuilder id(int id, long uid) {
            this.checkNotFinished();
            this.id = id;
            this.uid = uid;
            return this;
        }

        public EntityBuilder lastPropertyId(int lastPropertyId, long lastPropertyUid) {
            this.checkNotFinished();
            this.lastPropertyId = lastPropertyId;
            this.lastPropertyUid = lastPropertyUid;
            return this;
        }

        public EntityBuilder externalName(String externalName) {
            this.checkNotFinished();
            this.externalName = externalName;
            return this;
        }

        public EntityBuilder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public PropertyBuilder property(String name, int type) {
            return this.property(name, null, type);
        }

        public PropertyBuilder property(String name, @Nullable String targetEntityName, int type) {
            return this.property(name, targetEntityName, null, type);
        }

        public PropertyBuilder property(String name, @Nullable String targetEntityName, @Nullable String virtualTarget, int type) {
            this.checkNotFinished();
            this.finishPropertyOrRelation();
            this.propertyBuilder = new PropertyBuilder(this.getFbb(), name, targetEntityName, virtualTarget, type);
            return this.propertyBuilder;
        }

        public RelationBuilder relation(String name, int relationId, long relationUid, int targetEntityId, long targetEntityUid) {
            RelationBuilder relationBuilder;
            this.checkNotFinished();
            this.finishPropertyOrRelation();
            this.relationBuilder = relationBuilder = new RelationBuilder(this.getFbb(), name, relationId, relationUid, targetEntityId, targetEntityUid);
            return relationBuilder;
        }

        private void finishPropertyOrRelation() {
            if (this.propertyBuilder != null && this.relationBuilder != null) {
                throw new IllegalStateException("Must not build property and relation at the same time.");
            }
            if (this.propertyBuilder != null) {
                this.propertyOffsets.add(this.propertyBuilder.finish());
                this.propertyBuilder = null;
            }
            if (this.relationBuilder != null) {
                this.relationOffsets.add(this.relationBuilder.finish());
                this.relationBuilder = null;
            }
        }

        public ModelBuilder entityDone() {
            this.checkNotFinished();
            this.finishPropertyOrRelation();
            this.model.entityOffsets.add(this.finish());
            return this.model;
        }

        @Override
        public int createFlatBufferTable(FlatBufferBuilder fbb) {
            int idOffset;
            int nameOffset = fbb.createString(this.name);
            int externalNameOffset = this.externalName != null ? fbb.createString(this.externalName) : 0;
            int propertiesOffset = this.model.createVector(this.propertyOffsets);
            int relationsOffset = this.relationOffsets.isEmpty() ? 0 : this.model.createVector(this.relationOffsets);
            ModelEntity.startModelEntity(fbb);
            ModelEntity.addName(fbb, nameOffset);
            ModelEntity.addProperties(fbb, propertiesOffset);
            if (relationsOffset != 0) {
                ModelEntity.addRelations(fbb, relationsOffset);
            }
            if (this.id != null && this.uid != null) {
                idOffset = IdUid.createIdUid(fbb, this.id.intValue(), this.uid);
                ModelEntity.addId(fbb, idOffset);
            }
            if (this.lastPropertyId != null) {
                idOffset = IdUid.createIdUid(fbb, this.lastPropertyId.intValue(), this.lastPropertyUid);
                ModelEntity.addLastPropertyId(fbb, idOffset);
            }
            if (externalNameOffset != 0) {
                ModelEntity.addExternalName(fbb, externalNameOffset);
            }
            if (this.flags != null) {
                ModelEntity.addFlags(fbb, this.flags.intValue());
            }
            return ModelEntity.endModelEntity(fbb);
        }
    }

    public static class RelationBuilder
    extends PartBuilder {
        private final String name;
        private final int relationId;
        private final long relationUid;
        private final int targetEntityId;
        private final long targetEntityUid;
        private int externalNameOffset;
        private int externalType;

        private RelationBuilder(FlatBufferBuilder fbb, String name, int relationId, long relationUid, int targetEntityId, long targetEntityUid) {
            super(fbb);
            this.name = name;
            this.relationId = relationId;
            this.relationUid = relationUid;
            this.targetEntityId = targetEntityId;
            this.targetEntityUid = targetEntityUid;
        }

        public RelationBuilder externalName(String externalName) {
            this.checkNotFinished();
            this.externalNameOffset = this.getFbb().createString(externalName);
            return this;
        }

        public RelationBuilder externalType(int externalType) {
            this.checkNotFinished();
            this.externalType = externalType;
            return this;
        }

        @Override
        public int createFlatBufferTable(FlatBufferBuilder fbb) {
            int nameOffset = fbb.createString(this.name);
            ModelRelation.startModelRelation(fbb);
            ModelRelation.addName(fbb, nameOffset);
            int relationIdOffset = IdUid.createIdUid(fbb, this.relationId, this.relationUid);
            ModelRelation.addId(fbb, relationIdOffset);
            int targetEntityIdOffset = IdUid.createIdUid(fbb, this.targetEntityId, this.targetEntityUid);
            ModelRelation.addTargetEntityId(fbb, targetEntityIdOffset);
            if (this.externalNameOffset != 0) {
                ModelRelation.addExternalName(fbb, this.externalNameOffset);
            }
            if (this.externalType != 0) {
                ModelRelation.addExternalType(fbb, this.externalType);
            }
            return ModelRelation.endModelRelation(fbb);
        }
    }

    public static class PropertyBuilder
    extends PartBuilder {
        private final int propertyNameOffset;
        private final int targetEntityOffset;
        private final int virtualTargetOffset;
        private final int type;
        private int secondaryNameOffset;
        private int id;
        private long uid;
        private int indexId;
        private long indexUid;
        private int indexMaxValueLength;
        private int externalNameOffset;
        private int externalType;
        private int hnswParamsOffset;
        private int flags;

        private PropertyBuilder(FlatBufferBuilder fbb, String name, @Nullable String targetEntityName, @Nullable String virtualTarget, int type) {
            super(fbb);
            this.propertyNameOffset = fbb.createString(name);
            this.targetEntityOffset = targetEntityName != null ? fbb.createString(targetEntityName) : 0;
            this.virtualTargetOffset = virtualTarget != null ? fbb.createString(virtualTarget) : 0;
            this.type = type;
        }

        public PropertyBuilder secondaryName(String secondaryName) {
            this.checkNotFinished();
            this.secondaryNameOffset = this.getFbb().createString(secondaryName);
            return this;
        }

        public PropertyBuilder id(int id, long uid) {
            this.checkNotFinished();
            this.id = id;
            this.uid = uid;
            return this;
        }

        public PropertyBuilder indexId(int indexId, long indexUid) {
            this.checkNotFinished();
            this.indexId = indexId;
            this.indexUid = indexUid;
            return this;
        }

        public PropertyBuilder indexMaxValueLength(int indexMaxValueLength) {
            this.checkNotFinished();
            this.indexMaxValueLength = indexMaxValueLength;
            return this;
        }

        public PropertyBuilder externalName(String externalName) {
            this.checkNotFinished();
            this.externalNameOffset = this.getFbb().createString(externalName);
            return this;
        }

        public PropertyBuilder externalType(int externalType) {
            this.checkNotFinished();
            this.externalType = externalType;
            return this;
        }

        public PropertyBuilder hnswParams(long dimensions, @Nullable Long neighborsPerNode, @Nullable Long indexingSearchCount, @Nullable Integer flags, @Nullable Short distanceType, @Nullable Float reparationBacklinkProbability, @Nullable Long vectorCacheHintSizeKb) {
            this.checkNotFinished();
            FlatBufferBuilder fbb = this.getFbb();
            HnswParams.startHnswParams(fbb);
            HnswParams.addDimensions(fbb, dimensions);
            if (neighborsPerNode != null) {
                HnswParams.addNeighborsPerNode(fbb, neighborsPerNode);
            }
            if (indexingSearchCount != null) {
                HnswParams.addIndexingSearchCount(fbb, indexingSearchCount);
            }
            if (flags != null) {
                HnswParams.addFlags(fbb, flags.intValue());
            }
            if (distanceType != null) {
                HnswParams.addDistanceType(fbb, distanceType.shortValue());
            }
            if (reparationBacklinkProbability != null) {
                HnswParams.addReparationBacklinkProbability(fbb, reparationBacklinkProbability.floatValue());
            }
            if (vectorCacheHintSizeKb != null) {
                HnswParams.addVectorCacheHintSizeKb(fbb, vectorCacheHintSizeKb);
            }
            this.hnswParamsOffset = HnswParams.endHnswParams(fbb);
            return this;
        }

        public PropertyBuilder flags(int flags) {
            this.checkNotFinished();
            this.flags = flags;
            return this;
        }

        @Override
        public int createFlatBufferTable(FlatBufferBuilder fbb) {
            ModelProperty.startModelProperty(fbb);
            ModelProperty.addName(fbb, this.propertyNameOffset);
            if (this.targetEntityOffset != 0) {
                ModelProperty.addTargetEntity(fbb, this.targetEntityOffset);
            }
            if (this.virtualTargetOffset != 0) {
                ModelProperty.addVirtualTarget(fbb, this.virtualTargetOffset);
            }
            ModelProperty.addType(fbb, this.type);
            if (this.secondaryNameOffset != 0) {
                ModelProperty.addNameSecondary(fbb, this.secondaryNameOffset);
            }
            if (this.id != 0) {
                int idOffset = IdUid.createIdUid(fbb, this.id, this.uid);
                ModelProperty.addId(fbb, idOffset);
            }
            if (this.indexId != 0) {
                int indexIdOffset = IdUid.createIdUid(fbb, this.indexId, this.indexUid);
                ModelProperty.addIndexId(fbb, indexIdOffset);
            }
            if (this.indexMaxValueLength > 0) {
                ModelProperty.addMaxIndexValueLength(fbb, this.indexMaxValueLength);
            }
            if (this.externalNameOffset != 0) {
                ModelProperty.addExternalName(fbb, this.externalNameOffset);
            }
            if (this.externalType != 0) {
                ModelProperty.addExternalType(fbb, this.externalType);
            }
            if (this.hnswParamsOffset != 0) {
                ModelProperty.addHnswParams(fbb, this.hnswParamsOffset);
            }
            if (this.flags != 0) {
                ModelProperty.addFlags(fbb, this.flags);
            }
            return ModelProperty.endModelProperty(fbb);
        }
    }

    static abstract class PartBuilder {
        private final FlatBufferBuilder fbb;
        private boolean finished;

        PartBuilder(FlatBufferBuilder fbb) {
            this.fbb = fbb;
        }

        FlatBufferBuilder getFbb() {
            return this.fbb;
        }

        void checkNotFinished() {
            if (this.finished) {
                throw new IllegalStateException("Already finished");
            }
        }

        public final int finish() {
            this.checkNotFinished();
            this.finished = true;
            return this.createFlatBufferTable(this.getFbb());
        }

        public abstract int createFlatBufferTable(FlatBufferBuilder var1);
    }
}

