/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Property;
import io.objectbox.query.Query;
import io.objectbox.query.QueryBuilder;

public class PropertyQuery {
    final Query<?> query;
    final long queryHandle;
    final Property<?> property;
    final int propertyId;
    boolean distinct;
    boolean noCaseIfDistinct = true;
    boolean enableNull;
    boolean unique;
    double nullValueDouble;
    float nullValueFloat;
    String nullValueString;
    long nullValueLong;

    PropertyQuery(Query<?> query, Property<?> property) {
        this.query = query;
        this.queryHandle = query.handle;
        this.property = property;
        this.propertyId = property.id;
    }

    native String[] nativeFindStrings(long var1, long var3, int var5, boolean var6, boolean var7, boolean var8, String var9);

    native long[] nativeFindLongs(long var1, long var3, int var5, boolean var6, boolean var7, long var8);

    native int[] nativeFindInts(long var1, long var3, int var5, boolean var6, boolean var7, int var8);

    native short[] nativeFindShorts(long var1, long var3, int var5, boolean var6, boolean var7, short var8);

    native char[] nativeFindChars(long var1, long var3, int var5, boolean var6, boolean var7, char var8);

    native byte[] nativeFindBytes(long var1, long var3, int var5, boolean var6, boolean var7, byte var8);

    native float[] nativeFindFloats(long var1, long var3, int var5, boolean var6, boolean var7, float var8);

    native double[] nativeFindDoubles(long var1, long var3, int var5, boolean var6, boolean var7, double var8);

    native Object nativeFindNumber(long var1, long var3, int var5, boolean var6, boolean var7, boolean var8, long var9, float var11, double var12);

    native String nativeFindString(long var1, long var3, int var5, boolean var6, boolean var7, boolean var8, boolean var9, String var10);

    native long nativeSum(long var1, long var3, int var5);

    native double nativeSumDouble(long var1, long var3, int var5);

    native long nativeMax(long var1, long var3, int var5);

    native double nativeMaxDouble(long var1, long var3, int var5);

    native long nativeMin(long var1, long var3, int var5);

    native double nativeMinDouble(long var1, long var3, int var5);

    native double nativeAvg(long var1, long var3, int var5);

    native long nativeAvgLong(long var1, long var3, int var5);

    native long nativeCount(long var1, long var3, int var5, boolean var6);

    public PropertyQuery reset() {
        this.distinct = false;
        this.noCaseIfDistinct = true;
        this.unique = false;
        this.enableNull = false;
        this.nullValueDouble = 0.0;
        this.nullValueFloat = 0.0f;
        this.nullValueString = null;
        this.nullValueLong = 0L;
        return this;
    }

    public PropertyQuery distinct() {
        this.distinct = true;
        return this;
    }

    public PropertyQuery distinct(QueryBuilder.StringOrder stringOrder) {
        if (this.property.type != String.class) {
            throw new RuntimeException("Reserved for string properties, but got " + this.property);
        }
        this.distinct = true;
        this.noCaseIfDistinct = stringOrder == QueryBuilder.StringOrder.CASE_INSENSITIVE;
        return this;
    }

    public PropertyQuery unique() {
        this.unique = true;
        return this;
    }

    public PropertyQuery nullValue(Object nullValue) {
        if (nullValue == null) {
            throw new IllegalArgumentException("Null values are not allowed");
        }
        boolean isString = nullValue instanceof String;
        boolean isNumber = nullValue instanceof Number;
        if (!isString && !isNumber) {
            throw new IllegalArgumentException("Unsupported value class: " + nullValue.getClass());
        }
        this.enableNull = true;
        this.nullValueString = isString ? (String)nullValue : null;
        boolean isFloat = nullValue instanceof Float;
        this.nullValueFloat = isFloat ? ((Float)nullValue).floatValue() : 0.0f;
        boolean isDouble = nullValue instanceof Double;
        this.nullValueDouble = isDouble ? (Double)nullValue : 0.0;
        this.nullValueLong = isNumber && !isFloat && !isDouble ? ((Number)nullValue).longValue() : 0L;
        return this;
    }

    public String[] findStrings() {
        return this.query.callInReadTx(() -> {
            boolean distinctNoCase = this.distinct && this.noCaseIfDistinct;
            long cursorHandle = this.query.cursorHandle();
            return this.nativeFindStrings(this.queryHandle, cursorHandle, this.propertyId, this.distinct, distinctNoCase, this.enableNull, this.nullValueString);
        });
    }

    public long[] findLongs() {
        return this.query.callInReadTx(() -> this.nativeFindLongs(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.distinct, this.enableNull, this.nullValueLong));
    }

    public int[] findInts() {
        return this.query.callInReadTx(() -> this.nativeFindInts(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.distinct, this.enableNull, (int)this.nullValueLong));
    }

    public short[] findShorts() {
        return this.query.callInReadTx(() -> this.nativeFindShorts(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.distinct, this.enableNull, (short)this.nullValueLong));
    }

    public char[] findChars() {
        return this.query.callInReadTx(() -> this.nativeFindChars(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.distinct, this.enableNull, (char)this.nullValueLong));
    }

    public byte[] findBytes() {
        return this.query.callInReadTx(() -> this.nativeFindBytes(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.distinct, this.enableNull, (byte)this.nullValueLong));
    }

    public float[] findFloats() {
        return this.query.callInReadTx(() -> this.nativeFindFloats(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.distinct, this.enableNull, this.nullValueFloat));
    }

    public double[] findDoubles() {
        return this.query.callInReadTx(() -> this.nativeFindDoubles(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.distinct, this.enableNull, this.nullValueDouble));
    }

    public String findString() {
        return this.query.callInReadTx(() -> {
            boolean distinctCase = this.distinct && !this.noCaseIfDistinct;
            return this.nativeFindString(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.unique, this.distinct, distinctCase, this.enableNull, this.nullValueString);
        });
    }

    private Object findNumber() {
        return this.query.callInReadTx(() -> this.nativeFindNumber(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.unique, this.distinct, this.enableNull, this.nullValueLong, this.nullValueFloat, this.nullValueDouble));
    }

    public Long findLong() {
        return (Long)this.findNumber();
    }

    public Integer findInt() {
        return (Integer)this.findNumber();
    }

    public Short findShort() {
        return (Short)this.findNumber();
    }

    public Character findChar() {
        return (Character)this.findNumber();
    }

    public Byte findByte() {
        return (Byte)this.findNumber();
    }

    public Boolean findBoolean() {
        return (Boolean)this.findNumber();
    }

    public Float findFloat() {
        return (Float)this.findNumber();
    }

    public Double findDouble() {
        return (Double)this.findNumber();
    }

    public long sum() {
        return this.query.callInReadTx(() -> this.nativeSum(this.queryHandle, this.query.cursorHandle(), this.propertyId));
    }

    public double sumDouble() {
        return this.query.callInReadTx(() -> this.nativeSumDouble(this.queryHandle, this.query.cursorHandle(), this.propertyId));
    }

    public long max() {
        return this.query.callInReadTx(() -> this.nativeMax(this.queryHandle, this.query.cursorHandle(), this.propertyId));
    }

    public double maxDouble() {
        return this.query.callInReadTx(() -> this.nativeMaxDouble(this.queryHandle, this.query.cursorHandle(), this.propertyId));
    }

    public long min() {
        return this.query.callInReadTx(() -> this.nativeMin(this.queryHandle, this.query.cursorHandle(), this.propertyId));
    }

    public double minDouble() {
        return this.query.callInReadTx(() -> this.nativeMinDouble(this.queryHandle, this.query.cursorHandle(), this.propertyId));
    }

    public double avg() {
        return this.query.callInReadTx(() -> this.nativeAvg(this.queryHandle, this.query.cursorHandle(), this.propertyId));
    }

    public long avgLong() {
        return this.query.callInReadTx(() -> this.nativeAvgLong(this.queryHandle, this.query.cursorHandle(), this.propertyId));
    }

    public long count() {
        return this.query.callInReadTx(() -> this.nativeCount(this.queryHandle, this.query.cursorHandle(), this.propertyId, this.distinct));
    }
}

