/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.relation;

import io.objectbox.EntityInfo;
import io.objectbox.Property;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.internal.ToManyGetter;
import io.objectbox.internal.ToOneGetter;
import io.objectbox.query.QueryCondition;
import io.objectbox.query.RelationCountCondition;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;

@Internal
@Immutable
public class RelationInfo<SOURCE, TARGET>
implements Serializable {
    private static final long serialVersionUID = 7412962174183812632L;
    public final EntityInfo<SOURCE> sourceInfo;
    public final EntityInfo<TARGET> targetInfo;
    public final Property<?> targetIdProperty;
    public final int targetRelationId;
    public final ToOneGetter<SOURCE, TARGET> toOneGetter;
    public final ToManyGetter<SOURCE, TARGET> toManyGetter;
    public final ToOneGetter<TARGET, SOURCE> backlinkToOneGetter;
    public final ToManyGetter<TARGET, SOURCE> backlinkToManyGetter;
    public final int relationId;

    public RelationInfo(EntityInfo<SOURCE> sourceInfo, EntityInfo<TARGET> targetInfo, Property<SOURCE> targetIdProperty, ToOneGetter<SOURCE, TARGET> toOneGetter) {
        this.sourceInfo = sourceInfo;
        this.targetInfo = targetInfo;
        this.targetIdProperty = targetIdProperty;
        this.toOneGetter = toOneGetter;
        this.targetRelationId = 0;
        this.backlinkToOneGetter = null;
        this.backlinkToManyGetter = null;
        this.toManyGetter = null;
        this.relationId = 0;
    }

    public RelationInfo(EntityInfo<SOURCE> sourceInfo, EntityInfo<TARGET> targetInfo, ToManyGetter<SOURCE, TARGET> toManyGetter, Property<TARGET> targetIdProperty, ToOneGetter<TARGET, SOURCE> backlinkToOneGetter) {
        this.sourceInfo = sourceInfo;
        this.targetInfo = targetInfo;
        this.targetIdProperty = targetIdProperty;
        this.toManyGetter = toManyGetter;
        this.backlinkToOneGetter = backlinkToOneGetter;
        this.targetRelationId = 0;
        this.toOneGetter = null;
        this.backlinkToManyGetter = null;
        this.relationId = 0;
    }

    public RelationInfo(EntityInfo<SOURCE> sourceInfo, EntityInfo<TARGET> targetInfo, ToManyGetter<SOURCE, TARGET> toManyGetter, ToManyGetter<TARGET, SOURCE> backlinkToManyGetter, int targetRelationId) {
        this.sourceInfo = sourceInfo;
        this.targetInfo = targetInfo;
        this.toManyGetter = toManyGetter;
        this.targetRelationId = targetRelationId;
        this.backlinkToManyGetter = backlinkToManyGetter;
        this.targetIdProperty = null;
        this.toOneGetter = null;
        this.backlinkToOneGetter = null;
        this.relationId = 0;
    }

    public RelationInfo(EntityInfo<SOURCE> sourceInfo, EntityInfo<TARGET> targetInfo, ToManyGetter<SOURCE, TARGET> toManyGetter, int relationId) {
        this.sourceInfo = sourceInfo;
        this.targetInfo = targetInfo;
        this.toManyGetter = toManyGetter;
        this.relationId = relationId;
        this.targetRelationId = 0;
        this.targetIdProperty = null;
        this.toOneGetter = null;
        this.backlinkToOneGetter = null;
        this.backlinkToManyGetter = null;
    }

    public boolean isBacklink() {
        return this.backlinkToManyGetter != null || this.backlinkToOneGetter != null;
    }

    public String toString() {
        return "RelationInfo from " + this.sourceInfo.getEntityClass() + " to " + this.targetInfo.getEntityClass();
    }

    public QueryCondition<SOURCE> relationCount(int relationCount) {
        if (this.targetIdProperty == null) {
            throw new IllegalStateException("The relation count condition is only supported for 1:N (ToMany using @Backlink) relations.");
        }
        return new RelationCountCondition(this, relationCount);
    }
}

