/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle;

import io.objectbox.gradle.GradleBuildTracker;
import io.objectbox.gradle.ObjectBoxGradlePlugin;
import io.objectbox.gradle.ObjectBoxGradlePlugin$createPlainJavaTransformTask$1$$special$;
import io.objectbox.gradle.ProjectEnv;
import io.objectbox.gradle.transform.ObjectBoxAndroidTransform;
import io.objectbox.gradle.transform.ObjectBoxJavaTransform;
import io.objectbox.gradle.transform.TransformException;
import io.objectbox.gradle.util.GradleCompat;
import io.objectbox.reporting.ObjectBoxBuildConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u001a\u001a\u00020\t*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0014\u0010\u001d\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u001e\u0010\u001e\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lio/objectbox/gradle/ObjectBoxGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "buildTracker", "Lio/objectbox/gradle/GradleBuildTracker;", "getBuildTracker", "()Lio/objectbox/gradle/GradleBuildTracker;", "addDependencies", "", "env", "Lio/objectbox/gradle/ProjectEnv;", "addDependenciesAnnotationProcessor", "addNativeDependency", "config", "", "searchTestConfigs", "", "apply", "project", "createPlainJavaTransformTask", "createPrepareTask", "findObjectBoxDependency", "Lorg/gradle/api/artifacts/Dependency;", "name", "writeBuildConfig", "addDep", "configurationName", "dep", "hasConfig", "hasObjectBoxDep", "Companion", "objectbox-gradle-plugin"})
public final class ObjectBoxGradlePlugin
implements Plugin<Project> {
    @NotNull
    private final GradleBuildTracker buildTracker = new GradleBuildTracker("GradlePlugin");
    public static final boolean DEBUG = false;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final GradleBuildTracker getBuildTracker() {
        return this.buildTracker;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        try {
            ProjectEnv env = new ProjectEnv(project);
            if (!(env.getHasAndroidPlugin() || env.getHasJavaPlugin() || env.getHasKotlinPlugin())) {
                throw (Throwable)new InvalidPluginException("'io.objectbox' expects one of the following plugins to be applied to the project:\n\t* java\n\t* kotlin\n" + '\t' + CollectionsKt.joinToString$default((Iterable)env.getAndroidPluginIds(), (CharSequence)"\n\t", null, null, (int)0, null, (Function1)apply.1.INSTANCE, (int)30, null));
            }
            this.addDependenciesAnnotationProcessor(env);
            this.addDependencies(env);
            if (env.getHasAndroidPlugin()) {
                Collection collection = ObjectBoxAndroidTransform.Registration.INSTANCE.getAndroidExtensionClasses(project);
                boolean bl = false;
                if (!collection.isEmpty()) {
                    ObjectBoxAndroidTransform.Registration.INSTANCE.to(project, env.getOptions());
                }
            } else {
                this.createPlainJavaTransformTask(env);
            }
            this.createPrepareTask(env);
        }
        catch (Throwable e) {
            if (e instanceof TransformException) {
                this.buildTracker.trackError("Transform preparation failed", e);
            } else if (!(e instanceof InvalidPluginException)) {
                this.buildTracker.trackFatal("Applying plugin failed", e);
            }
            throw e;
        }
    }

    private final void createPlainJavaTransformTask(ProjectEnv env) {
        Project project = env.getProject();
        project.afterEvaluate((Action)new Action<Project>(project, env){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectEnv $env;

            public final void execute(Project $noName_0) {
                JavaPluginConvention javaPlugin;
                JavaPluginConvention javaPluginConvention = javaPlugin = (JavaPluginConvention)this.$project.getConvention().getPlugin(JavaPluginConvention.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention, (String)"javaPlugin");
                SourceSetContainer sourceSetContainer = javaPluginConvention.getSourceSets();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceSetContainer, (String)"javaPlugin.sourceSets");
                Iterable $this$forEach$iv = (Iterable)sourceSetContainer;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Object object;
                    String string;
                    SourceSet sourceSet = (SourceSet)element$iv;
                    boolean bl = false;
                    SourceSet sourceSet2 = sourceSet;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet2, (String)"sourceSet");
                    String sourceSetName = sourceSet2.getName();
                    StringBuilder stringBuilder = new StringBuilder().append("objectboxJavaTransform");
                    if (Intrinsics.areEqual((Object)sourceSetName, (Object)"main") ^ true) {
                        String string2 = sourceSetName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sourceSetName");
                        string = StringsKt.capitalize((String)string2);
                    } else {
                        string = "";
                    }
                    String taskName = stringBuilder.append(string).toString();
                    Object transformTask = GradleCompat.Companion.get().registerTask(this.$project, taskName);
                    if (this.$env.getDebug()) {
                        String string3 = "### Registered " + transformTask + " in " + this.$project;
                        boolean bl2 = false;
                        System.out.println((Object)string3);
                    }
                    try {
                        GradleCompat gradleCompat = GradleCompat.Companion.get();
                        String string4 = sourceSet.getClassesTaskName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sourceSet.classesTaskName");
                        gradleCompat.configureTask(this.$project, string4, (Action<? super Task>)((Action)new Action<Task>(transformTask){
                            final /* synthetic */ Object $transformTask;

                            public final void execute(Task it) {
                                it.dependsOn(new Object[]{this.$transformTask});
                            }
                            {
                                this.$transformTask = object;
                            }
                        }));
                    }
                    catch (UnknownDomainObjectException e) {
                        throw (Throwable)new RuntimeException("Could not find classes task '" + sourceSet.getClassesTaskName() + "'.", e);
                    }
                    try {
                        GradleCompat gradleCompat = GradleCompat.Companion.get();
                        String string5 = sourceSet.getCompileJavaTaskName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceSet.compileJavaTaskName");
                        object = gradleCompat.getTask(this.$project, string5);
                    }
                    catch (UnknownTaskException e) {
                        throw (Throwable)new RuntimeException("Could not find compileJava task '" + sourceSet.getCompileJavaTaskName() + "'.", e);
                    }
                    Object compileJavaTask = object;
                    GradleCompat.Companion.get().configureTask(this.$project, taskName, (Action<? super Task>)((Action)new Action<Task>(compileJavaTask, transformTask, sourceSet, this){
                        final /* synthetic */ Object $compileJavaTask;
                        final /* synthetic */ Object $transformTask;
                        final /* synthetic */ SourceSet $sourceSet;
                        final /* synthetic */ createPlainJavaTransformTask.1 this$0;
                        {
                            this.$compileJavaTask = object;
                            this.$transformTask = object2;
                            this.$sourceSet = sourceSet;
                            this.this$0 = var4_4;
                        }

                        public final void execute(Task it) {
                            Task task = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                            task.setGroup("objectbox");
                            it.setDescription("Transforms Java bytecode");
                            it.mustRunAfter(new Object[]{this.$compileJavaTask});
                            it.doLast((Action)new Action<Task>(this){
                                final /* synthetic */ createPlainJavaTransformTask$1$$special$$inlined$forEach$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final void execute(Task it) {
                                    if (this.this$0.this$0.$env.getDebug()) {
                                        String string = "### Executing " + this.this$0.$transformTask + " in " + this.this$0.this$0.$project;
                                        boolean bl = false;
                                        System.out.println((Object)string);
                                    }
                                    GradleCompat gradleCompat = GradleCompat.Companion.get();
                                    Project project = this.this$0.this$0.$project;
                                    SourceSet sourceSet = this.this$0.$sourceSet;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet, (String)"sourceSet");
                                    String string = sourceSet.getCompileJavaTaskName();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceSet.compileJavaTaskName");
                                    File compileJavaTaskOutputDir = gradleCompat.getTask(project, JavaCompile.class, string).getDestinationDir();
                                    new ObjectBoxJavaTransform(this.this$0.this$0.$env.getDebug()).transform(CollectionsKt.listOf((Object)compileJavaTaskOutputDir));
                                }
                            });
                        }
                    }));
                }
            }
            {
                this.$project = project;
                this.$env = projectEnv;
            }
        });
    }

    private final void createPrepareTask(ProjectEnv env) {
        Project project = env.getProject();
        String prepareTaskName = "objectboxPrepareBuild";
        Object prepareTask = GradleCompat.Companion.get().registerTask(project, prepareTaskName);
        Action configureDepends2 = (Action)new Action<Task>(prepareTask){
            final /* synthetic */ Object $prepareTask;

            public final void execute(Task it) {
                it.dependsOn(new Object[]{this.$prepareTask});
            }
            {
                this.$prepareTask = object;
            }
        };
        try {
            GradleCompat.Companion.get().configureTask(project, "preBuild", (Action<? super Task>)configureDepends2);
        }
        catch (Exception e) {
            GradleCompat.Companion.get().configureTask(project, "build", (Action<? super Task>)configureDepends2);
        }
        GradleCompat.Companion.get().configureTask(project, prepareTaskName, (Action<? super Task>)((Action)new Action<Task>(this, env, prepareTask, project){
            final /* synthetic */ ObjectBoxGradlePlugin this$0;
            final /* synthetic */ ProjectEnv $env;
            final /* synthetic */ Object $prepareTask;
            final /* synthetic */ Project $project;

            public final void execute(Task it) {
                Task task = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                task.setGroup("objectbox");
                it.doFirst((Action)new Action<Task>(this){
                    final /* synthetic */ createPrepareTask.1 this$0;

                    public final void execute(Task it) {
                        Dependency foundDependency;
                        Dependency dependency;
                        Configuration aptConf;
                        Configuration configuration;
                        Configuration configuration2;
                        if (this.this$0.$env.getDebug()) {
                            String string = "### Executing " + this.this$0.$prepareTask + " in " + this.this$0.$project;
                            boolean bl = false;
                            System.out.println((Object)string);
                        }
                        this.this$0.this$0.getBuildTracker().trackBuild(this.this$0.$env);
                        Configuration configuration3 = (Configuration)this.this$0.$project.getConfigurations().findByName("kapt");
                        if (configuration3 == null) {
                            configuration3 = configuration2 = (Configuration)this.this$0.$project.getConfigurations().findByName("annotationProcessor");
                        }
                        if (configuration3 == null) {
                            configuration2 = (Configuration)this.this$0.$project.getConfigurations().findByName("apt");
                        }
                        if ((configuration = (aptConf = configuration2)) != null && (configuration = configuration.getDependencies()) != null) {
                            Object v4;
                            block8: {
                                Iterable $this$firstOrNull$iv = (Iterable)configuration;
                                boolean $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    Dependency dep = (Dependency)element$iv;
                                    boolean bl = false;
                                    Dependency dependency2 = dep;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)dependency2, (String)"dep");
                                    if (!Intrinsics.areEqual((Object)dependency2.getGroup(), (Object)"io.objectbox")) continue;
                                    v4 = element$iv;
                                    break block8;
                                }
                                v4 = null;
                            }
                            dependency = v4;
                        } else {
                            dependency = foundDependency = null;
                        }
                        if (foundDependency == null) {
                            String msg = "No ObjectBox annotation processor configuration found. Please check your build scripts.";
                            if (!this.this$0.$env.getHasAndroidPlugin()) {
                                msg = msg + "Currently only Android projects are fully supported.";
                            }
                            throw (Throwable)new RuntimeException(msg);
                        }
                        ObjectBoxGradlePlugin.access$writeBuildConfig(this.this$0.this$0, this.this$0.$env);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = objectBoxGradlePlugin;
                this.$env = projectEnv;
                this.$prepareTask = object;
                this.$project = project;
            }
        }));
    }

    private final void writeBuildConfig(ProjectEnv env) {
        File buildDir = env.getProject().getBuildDir();
        if (!buildDir.exists()) {
            buildDir.mkdirs();
        }
        File file = env.getProject().getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"env.project.projectDir");
        String string = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"env.project.projectDir.absolutePath");
        ObjectBoxBuildConfig objectBoxBuildConfig = new ObjectBoxBuildConfig(string, null);
        File file2 = buildDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"buildDir");
        objectBoxBuildConfig.writeInto(file2);
    }

    private final void addDependenciesAnnotationProcessor(ProjectEnv env) {
        Project project = env.getProject();
        if ((env.getHasKotlinPlugin() || env.getHasKotlinAndroidPlugin()) && !this.hasConfig(project, "kapt")) {
            project.getPlugins().apply("kotlin-kapt");
        }
        String processorDep = "io.objectbox:objectbox-processor:2.5.1";
        if (this.hasConfig(project, "kapt")) {
            this.addDep(project, "kapt", processorDep);
        } else if (this.hasConfig(project, "annotationProcessor")) {
            this.addDep(project, "annotationProcessor", processorDep);
        } else if (this.hasConfig(project, "apt")) {
            this.addDep(project, "apt", processorDep);
        } else {
            project.getLogger().warn("ObjectBox: Could not add dependency on objectbox-processor, no supported configuration (kapt, annotationProcessor, apt) found.");
        }
    }

    private final boolean hasConfig(@NotNull Project $this$hasConfig, String name) {
        return $this$hasConfig.getConfigurations().findByName(name) != null;
    }

    private final void addDep(@NotNull Project $this$addDep, String configurationName, String dep) {
        $this$addDep.getDependencies().add(configurationName, (Object)dep);
    }

    private final void addDependencies(ProjectEnv env) {
        Project project;
        String compileConfig;
        String runtimeVersion;
        block9: {
            block8: {
                runtimeVersion = "2.5.1";
                compileConfig = env.getConfigApiOrCompile();
                project = env.getProject();
                if (env.getHasKotlinPlugin()) break block8;
                if (!env.getHasKotlinAndroidPlugin()) break block9;
            }
            if (!ObjectBoxGradlePlugin.hasObjectBoxDep$default(this, project, "objectbox-kotlin", false, 2, null)) {
                this.addDep(project, compileConfig, "io.objectbox:objectbox-kotlin:" + runtimeVersion);
            }
        }
        if (env.getHasAndroidPlugin()) {
            if (!ObjectBoxGradlePlugin.hasObjectBoxDep$default(this, project, "objectbox-android", false, 2, null) && !ObjectBoxGradlePlugin.hasObjectBoxDep$default(this, project, "objectbox-android-objectbrowser", false, 2, null)) {
                this.addDep(project, compileConfig, "io.objectbox:objectbox-android:" + runtimeVersion);
            }
            this.addDep(project, env.getConfigAndroidTestImplOrCompile(), "com.google.code.findbugs:jsr305:3.0.2");
            this.addNativeDependency(env, env.getConfigTestImplOrCompile(), true);
        } else {
            if (!ObjectBoxGradlePlugin.hasObjectBoxDep$default(this, project, "objectbox-java", false, 2, null)) {
                this.addDep(project, compileConfig, "io.objectbox:objectbox-java:" + runtimeVersion);
            }
            this.addNativeDependency(env, compileConfig, false);
        }
    }

    private final void addNativeDependency(ProjectEnv env, String config, boolean searchTestConfigs) {
        String runtimeVersion = "2.5.1";
        Project project = env.getProject();
        if (!(this.hasObjectBoxDep(project, "objectbox-linux", searchTestConfigs) || this.hasObjectBoxDep(project, "objectbox-windows", searchTestConfigs) || this.hasObjectBoxDep(project, "objectbox-macos", searchTestConfigs))) {
            if (env.isLinux64()) {
                this.addDep(project, config, "io.objectbox:objectbox-linux:" + runtimeVersion);
            } else if (env.isWindows64()) {
                this.addDep(project, config, "io.objectbox:objectbox-windows:" + runtimeVersion);
            } else if (env.isMac64()) {
                this.addDep(project, config, "io.objectbox:objectbox-macos:" + runtimeVersion);
            } else {
                env.logInfo("Could not set up native dependency for " + env.getOsName());
            }
        }
    }

    private final boolean hasObjectBoxDep(@NotNull Project $this$hasObjectBoxDep, String name, boolean searchTestConfigs) {
        Dependency dependency = this.findObjectBoxDependency($this$hasObjectBoxDep, name, searchTestConfigs);
        return dependency != null;
    }

    static /* synthetic */ boolean hasObjectBoxDep$default(ObjectBoxGradlePlugin objectBoxGradlePlugin, Project project, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return objectBoxGradlePlugin.hasObjectBoxDep(project, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Dependency findObjectBoxDependency(Project project, String name, boolean searchTestConfigs) {
        Collection collection;
        if (searchTestConfigs) {
            collection = (Collection)project.getConfigurations();
        } else {
            void $this$filterNotTo$iv$iv;
            ConfigurationContainer configurationContainer = project.getConfigurations();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.configurations");
            Iterable $this$filterNot$iv = (Iterable)configurationContainer;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Configuration it = (Configuration)element$iv$iv;
                boolean bl = false;
                Configuration configuration = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"it");
                String string = configuration.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                if (StringsKt.contains((CharSequence)string, (CharSequence)"test", (boolean)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"if (searchTestConfigs) {\u2026eCase = true) }\n        }");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v7;
            boolean bl;
            Iterable iterable;
            block5: {
                Configuration config = (Configuration)element$iv;
                boolean bl2 = false;
                Configuration configuration = config;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
                DependencySet dependencySet = configuration.getDependencies();
                Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"config.dependencies");
                iterable = (Iterable)dependencySet;
                bl = false;
                Iterable iterable2 = iterable;
                boolean bl3 = false;
                for (Object t : iterable2) {
                    Dependency it = (Dependency)t;
                    boolean bl4 = false;
                    Dependency dependency = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"it");
                    if (!(Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"io.objectbox") && Intrinsics.areEqual((Object)it.getName(), (Object)name))) continue;
                    v7 = t;
                    break block5;
                }
                v7 = null;
            }
            Dependency dependency = v7;
            if (dependency == null) continue;
            iterable = dependency;
            bl = false;
            boolean bl5 = false;
            Iterable it = iterable;
            boolean bl6 = false;
            return it;
        }
        return null;
    }

    public static final /* synthetic */ void access$writeBuildConfig(ObjectBoxGradlePlugin $this, ProjectEnv env) {
        $this.writeBuildConfig(env);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/objectbox/gradle/ObjectBoxGradlePlugin$Companion;", "", "()V", "DEBUG", "", "objectbox-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

