/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.TextUtil;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.HasParsedElement;

public abstract class ToManyBase
implements HasParsedElement {
    private final String name;
    private final String targetEntityName;
    private final boolean fieldAccessible;
    private Entity sourceEntity;
    private Entity targetEntity;
    private Object parsedElement;

    ToManyBase(String name, String targetEntityName, boolean isFieldAccessible) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (targetEntityName == null) {
            throw new IllegalArgumentException("targetEntityName must not be null");
        }
        this.name = name;
        this.targetEntityName = targetEntityName;
        this.fieldAccessible = isFieldAccessible;
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    void setSourceAndTargetEntity(Entity sourceEntity, Entity targetEntity) {
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
    }

    public String getName() {
        return this.name;
    }

    public String getValueExpression() {
        return this.fieldAccessible ? this.name : "get" + TextUtil.capFirst(this.name) + "()";
    }

    @Override
    public Object getParsedElement() {
        return this.parsedElement;
    }

    @Override
    public void setParsedElement(Object parsedElement) {
        this.parsedElement = parsedElement;
    }

    void init3rdPass() {
        if (this.sourceEntity == null || this.targetEntity == null) {
            throw new IllegalStateException("Source and target entity are not set for " + this + ".");
        }
    }

    public String toString() {
        String sourceName = this.sourceEntity != null ? this.sourceEntity.getClassName() : null;
        String targetName = this.targetEntity != null ? this.targetEntity.getClassName() : null;
        return "ToMany '" + this.name + "' from " + sourceName + " to " + targetName;
    }
}

