/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.android;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import io.objectbox.reactive.RunWithParam;
import io.objectbox.reactive.Scheduler;
import java.util.ArrayDeque;
import java.util.Deque;

public class AndroidScheduler
extends Handler
implements Scheduler {
    private static AndroidScheduler MAIN_THREAD;
    private final Deque<Runner> freeRunners = new ArrayDeque<Runner>();

    public static synchronized Scheduler mainThread() {
        if (MAIN_THREAD == null) {
            MAIN_THREAD = new AndroidScheduler(Looper.getMainLooper());
        }
        return MAIN_THREAD;
    }

    public AndroidScheduler(Looper looper) {
        super(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void run(@NonNull RunWithParam<T> runnable, @NonNull T param) {
        Runner runner;
        Deque<Runner> deque = this.freeRunners;
        synchronized (deque) {
            runner = this.freeRunners.poll();
        }
        if (runner == null) {
            runner = new Runner();
        }
        runner.runWithParam = runnable;
        runner.param = param;
        this.post(runner);
    }

    class Runner
    implements Runnable {
        RunWithParam<Object> runWithParam;
        Object param;

        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runWithParam.run(this.param);
            this.runWithParam = null;
            this.param = null;
            Deque deque = AndroidScheduler.this.freeRunners;
            synchronized (deque) {
                if (AndroidScheduler.this.freeRunners.size() < 20) {
                    AndroidScheduler.this.freeRunners.add(this);
                }
            }
        }
    }
}

