/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.android;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import io.objectbox.android.Admin;
import io.objectbox.android.R;
import javax.annotation.Nullable;

public class AdminKeepAliveService
extends Service {
    private static final String ACTION_STOP = "objectBox_keepAliveStop";
    static final String EXTRA_KEY_PORT = "port";
    static final String EXTRA_KEY_URL = "url";
    static final String EXTRA_KEY_NOTIFICATION_ID = "notificationId";
    private static final String TAG = AdminKeepAliveService.class.getSimpleName();

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (ACTION_STOP.equals(intent.getAction())) {
            Log.d((String)TAG, (String)"Stopping");
            this.stopForeground(true);
            this.stopSelf();
            return 2;
        }
        String url = intent.getStringExtra(EXTRA_KEY_URL);
        int port = intent.getIntExtra(EXTRA_KEY_PORT, 0);
        int notificationId = intent.getIntExtra(EXTRA_KEY_NOTIFICATION_ID, 0);
        if (url != null && url.startsWith("http") && port > 0 && notificationId > 0) {
            Intent stopIntent = new Intent((Context)this, ((Object)((Object)this)).getClass());
            stopIntent.setAction(ACTION_STOP);
            PendingIntent stopPendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)stopIntent, (int)Admin.buildPendingIntentFlags(0x10000000));
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)Admin.viewIntent(url), (int)Admin.buildPendingIntentFlags(0));
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            Notification.Builder builder = Admin.buildBaseNotification((Context)this, port, manager);
            builder.setContentIntent(pendingIntent);
            builder.setDeleteIntent(stopPendingIntent);
            if (Build.VERSION.SDK_INT >= 20) {
                builder.addAction(new Notification.Action.Builder(R.drawable.objectbox_stop, (CharSequence)"Stop", stopPendingIntent).build());
            }
            this.startForeground(notificationId, builder.getNotification());
            Log.d((String)TAG, (String)"Started");
            return 3;
        }
        Log.w((String)TAG, (String)"Ignoring start command due to incomplete data");
        return 2;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }
}

