/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.svm;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringBufferRingAllocator;
import io.netty.channel.uring.IoUringBufferRingConfig;
import io.netty.channel.uring.IoUringFixedBufferRingAllocator;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringIoHandlerConfig;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.channel.uring.IoUringSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.testsuite.svm.HttpNativeClient;
import io.netty.testsuite.svm.HttpNativeServerInitializer;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;

public final class HttpNativeServer {
    private HttpNativeServer() {
    }

    public static void main(String[] args) throws Exception {
        for (TransportType value : TransportType.values()) {
            for (AllocatorType allocatorType : AllocatorType.values()) {
                boolean serverStartSucess = HttpNativeServer.testTransport(value, allocatorType);
                System.out.println("Server started with transport type " + (Object)((Object)value) + ": " + serverStartSucess);
                if (serverStartSucess) continue;
                System.exit(1);
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testTransport(TransportType ioType, AllocatorType allocatorType) throws Exception {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(HttpNativeServer.chooseFactory(ioType));
        boolean serverStartSucess = false;
        try {
            CompletableFuture<Void> httpRequestFuture = new CompletableFuture<Void>();
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)group).channel(HttpNativeServer.chooseServerChannelClass(ioType))).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childOption(ChannelOption.ALLOCATOR, (Object)HttpNativeServer.chooseAllocator(allocatorType)).childHandler((ChannelHandler)new HttpNativeServerInitializer(httpRequestFuture));
            Channel channel = b.bind(0).sync().channel();
            System.err.println("Server started, will shutdown now.");
            Channel httpClient = new HttpNativeClient(((InetSocketAddress)channel.localAddress()).getPort(), (EventLoopGroup)group, HttpNativeServer.chooseChannelClass(ioType)).initClient();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/hello");
            httpClient.writeAndFlush((Object)request).sync();
            httpRequestFuture.get();
            channel.close().sync();
            httpClient.close().sync();
            serverStartSucess = true;
        }
        finally {
            group.shutdownGracefully();
        }
        return serverStartSucess;
    }

    public static IoHandlerFactory chooseFactory(TransportType ioType) {
        if (ioType == TransportType.EPOLL) {
            return EpollIoHandler.newFactory();
        }
        if (ioType == TransportType.IO_URING) {
            IoUringIoHandlerConfig config = new IoUringIoHandlerConfig();
            if (IoUring.isRegisterBufferRingSupported()) {
                config.setBufferRingConfig(new IoUringBufferRingConfig[]{IoUringBufferRingConfig.builder().bufferGroupId((short)0).bufferRingSize((short)16).batchSize(16).allocator((IoUringBufferRingAllocator)new IoUringFixedBufferRingAllocator(1024)).batchAllocation(false).build()});
            }
            return IoUringIoHandler.newFactory((IoUringIoHandlerConfig)config);
        }
        return NioIoHandler.newFactory();
    }

    public static ByteBufAllocator chooseAllocator(AllocatorType allocatorType) {
        switch (allocatorType) {
            case POOLED: {
                return PooledByteBufAllocator.DEFAULT;
            }
            case UNPOOLED: {
                return UnpooledByteBufAllocator.DEFAULT;
            }
            case ADAPTIVE: {
                return new AdaptiveByteBufAllocator();
            }
        }
        return PooledByteBufAllocator.DEFAULT;
    }

    public static Class<? extends ServerSocketChannel> chooseServerChannelClass(TransportType ioType) {
        if (ioType == TransportType.EPOLL) {
            return EpollServerSocketChannel.class;
        }
        if (ioType == TransportType.IO_URING) {
            return IoUringServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends Channel> chooseChannelClass(TransportType ioType) {
        if (ioType == TransportType.EPOLL) {
            return EpollSocketChannel.class;
        }
        if (ioType == TransportType.IO_URING) {
            return IoUringSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    static enum AllocatorType {
        POOLED,
        UNPOOLED,
        ADAPTIVE;

    }

    static enum TransportType {
        NIO,
        EPOLL,
        IO_URING;

    }
}

