/*
 * Decompiled with CFR 0.152.
 */
package io.netty.pkitesting;

import io.netty.util.NetUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;

final class GeneralNameUtils {
    private GeneralNameUtils() {
    }

    static GeneralName otherName(String oid, byte[] value) {
        try {
            DERSequence wrappedValue = new DERSequence(new ASN1Encodable[]{new ASN1ObjectIdentifier(oid), new DERTaggedObject(true, 0, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])value))});
            return new GeneralName(0, (ASN1Encodable)wrappedValue);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static GeneralName rfc822Name(String emailAddress) {
        return new GeneralName(1, emailAddress);
    }

    static GeneralName dnsName(String dnsName) {
        URI uri = URI.create("ip://" + dnsName);
        String host = uri.getHost();
        return new GeneralName(2, host);
    }

    static GeneralName directoryName(String x500Name) {
        return GeneralNameUtils.directoryName(new X500Principal(x500Name));
    }

    static GeneralName directoryName(X500Principal name) {
        try {
            return new GeneralName(4, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])name.getEncoded()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static GeneralName uriName(String uri) throws URISyntaxException {
        return GeneralNameUtils.uriName(new URI(uri));
    }

    static GeneralName uriName(URI uri) {
        return new GeneralName(6, uri.toASCIIString());
    }

    static GeneralName ipAddress(String ipAddress) {
        if (!NetUtil.isValidIpV4Address((String)ipAddress) && !NetUtil.isValidIpV6Address((String)ipAddress)) {
            throw new IllegalArgumentException("Not a valid IP address: " + ipAddress);
        }
        return new GeneralName(7, ipAddress);
    }

    static GeneralName registeredId(String oid) {
        return new GeneralName(8, oid);
    }
}

