/*
 * Decompiled with CFR 0.152.
 */
package io.netty.pkitesting;

import io.netty.pkitesting.X509Bundle;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;

final class CertificateList {
    private final X509Bundle issuer;
    private final Instant thisUpdate;
    private final Instant nextUpdate;
    private final Iterable<Map.Entry<BigInteger, Instant>> revokedCerts;

    CertificateList(X509Bundle issuer, Instant thisUpdate, Instant nextUpdate, Iterable<Map.Entry<BigInteger, Instant>> revokedCerts) {
        this.issuer = issuer;
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.revokedCerts = revokedCerts;
    }

    byte[] getEncoded() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        X509Certificate cert = this.issuer.getCertificate();
        vec.add((ASN1Encodable)new ASN1Integer(1L));
        vec.add((ASN1Encodable)new AlgorithmIdentifier(new ASN1ObjectIdentifier(cert.getSigAlgOID())));
        vec.add((ASN1Encodable)X500Name.getInstance((Object)cert.getSubjectX500Principal().getEncoded()));
        vec.add((ASN1Encodable)new Time(Date.from(this.thisUpdate)));
        if (this.nextUpdate != null) {
            vec.add((ASN1Encodable)new Time(Date.from(this.nextUpdate)));
        }
        ASN1EncodableVector revokedVec = new ASN1EncodableVector();
        for (Map.Entry<BigInteger, Instant> revokedCert : this.revokedCerts) {
            revokedVec.add((ASN1Encodable)TBSCertList.CRLEntry.getInstance((Object)new DERSequence(new ASN1Encodable[]{new ASN1Integer(revokedCert.getKey()), new Time(Date.from(revokedCert.getValue()))})));
        }
        vec.add((ASN1Encodable)new DERSequence(revokedVec));
        TBSCertList list = new TBSCertList((ASN1Sequence)new DERSequence(vec));
        try {
            return list.getEncoded("DER");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

