/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.stomp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.stomp.DefaultStompFrame;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeadersSubframe;
import io.netty.handler.codec.stomp.StompSubframeEncoder;
import io.netty.microbench.channel.EmbeddedChannelWriteReleaseHandlerContext;
import io.netty.microbench.stomp.ExampleStompHeadersSubframe;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@State(value=Scope.Benchmark)
@Fork(value=2)
@Threads(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class StompEncoderBenchmark
extends AbstractMicrobenchmark {
    private StompSubframeEncoder stompEncoder;
    private ByteBuf content;
    private StompFrame stompFrame;
    private ChannelHandlerContext context;
    @Param(value={"true", "false"})
    public boolean pooledAllocator;
    @Param(value={"true", "false"})
    public boolean voidPromise;
    @Param
    public ExampleStompHeadersSubframe.HeadersType headersType;
    @Param(value={"0", "100", "1000"})
    public int contentLength;

    @Setup(value=Level.Trial)
    public void setup() {
        byte[] bytes = new byte[this.contentLength];
        ThreadLocalRandom.current().nextBytes(bytes);
        this.content = Unpooled.wrappedBuffer((byte[])bytes);
        ByteBuf testContent = Unpooled.unreleasableBuffer((ByteBuf)this.content.asReadOnly());
        StompHeadersSubframe headersSubframe = ExampleStompHeadersSubframe.EXAMPLES.get((Object)this.headersType);
        this.stompFrame = new DefaultStompFrame(headersSubframe.command(), testContent);
        this.stompFrame.headers().setAll((Headers)headersSubframe.headers());
        this.stompEncoder = new StompSubframeEncoder();
        this.context = new EmbeddedChannelWriteReleaseHandlerContext((ByteBufAllocator)(this.pooledAllocator ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT), (ChannelHandler)this.stompEncoder){

            @Override
            protected void handleException(Throwable t) {
                AbstractMicrobenchmarkBase.handleUnexpectedException(t);
            }
        };
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.content.release();
        this.content = null;
    }

    @Benchmark
    public void writeStompFrame() throws Exception {
        this.stompEncoder.write(this.context, (Object)this.stompFrame.retain(), this.newPromise());
    }

    private ChannelPromise newPromise() {
        return this.voidPromise ? this.context.voidPromise() : this.context.newPromise();
    }

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        return super.newOptionsBuilder().addProfiler(GCProfiler.class);
    }
}

