/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.internal;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@Threads(value=1)
@Warmup(iterations=3)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class EscapeCsvBenchmark
extends AbstractMicrobenchmark {
    private static final String value1024;
    private static final String value1024commaAtEnd;
    @Param(value={"netty"})
    private String value;

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        return super.newOptionsBuilder().param("value", new String[]{"netty"}).param("value", new String[]{"\"123\"", "need\"escape", "need,quotes", "  trim-me  ", "short-comma-ended,"}).param("value", new String[]{value1024}).param("value", new String[]{value1024commaAtEnd});
    }

    /*
     * Enabled aggressive block sorting
     */
    private static CharSequence escapeCsvOld(CharSequence value, boolean trimWhiteSpace) {
        StringBuilder stringBuilder;
        int length = ((CharSequence)ObjectUtil.checkNotNull((Object)value, (String)"value")).length();
        if (length == 0) {
            return value;
        }
        int start = 0;
        int last = length - 1;
        boolean trimmed = false;
        if (trimWhiteSpace) {
            start = EscapeCsvBenchmark.indexOfFirstNonOwsChar(value, length);
            if (start == length) {
                return "";
            }
            last = EscapeCsvBenchmark.indexOfLastNonOwsChar(value, start, length);
            boolean bl = trimmed = start > 0 || last < length - 1;
            if (trimmed) {
                length = last - start + 1;
            }
        }
        StringBuilder result = new StringBuilder(length + 7);
        boolean quoted = EscapeCsvBenchmark.isDoubleQuote(value.charAt(start)) && EscapeCsvBenchmark.isDoubleQuote(value.charAt(last)) && length != 1;
        boolean foundSpecialCharacter = false;
        boolean escapedDoubleQuote = false;
        block4: for (int i = start; i <= last; ++i) {
            char current = value.charAt(i);
            switch (current) {
                case '\"': {
                    if (i == start || i == last) {
                        if (quoted) continue block4;
                        result.append('\"');
                    } else {
                        boolean isNextCharDoubleQuote = EscapeCsvBenchmark.isDoubleQuote(value.charAt(i + 1));
                        if (EscapeCsvBenchmark.isDoubleQuote(value.charAt(i - 1)) || isNextCharDoubleQuote && i + 1 != last) break;
                        result.append('\"');
                        escapedDoubleQuote = true;
                        break;
                    }
                }
                case '\n': 
                case '\r': 
                case ',': {
                    foundSpecialCharacter = true;
                }
            }
            result.append(current);
        }
        if (escapedDoubleQuote) return EscapeCsvBenchmark.quote(result);
        if (foundSpecialCharacter && !quoted) {
            return EscapeCsvBenchmark.quote(result);
        }
        if (!trimmed) return value;
        if (quoted) {
            stringBuilder = EscapeCsvBenchmark.quote(result);
            return stringBuilder;
        }
        stringBuilder = result;
        return stringBuilder;
    }

    private static StringBuilder quote(StringBuilder builder) {
        return builder.insert(0, '\"').append('\"');
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    private static int indexOfFirstNonOwsChar(CharSequence value, int length) {
        int i;
        for (i = 0; i < length && EscapeCsvBenchmark.isOws(value.charAt(i)); ++i) {
        }
        return i;
    }

    private static int indexOfLastNonOwsChar(CharSequence value, int start, int length) {
        int i;
        for (i = length - 1; i > start && EscapeCsvBenchmark.isOws(value.charAt(i)); --i) {
        }
        return i;
    }

    private static boolean isOws(char c) {
        return c == ' ' || c == '\t';
    }

    @Benchmark
    public CharSequence escapeCsvOld() {
        return EscapeCsvBenchmark.escapeCsvOld(this.value, true);
    }

    @Benchmark
    public CharSequence escapeCsvNew() {
        return StringUtil.escapeCsv((CharSequence)this.value, (boolean)true);
    }

    static {
        StringBuilder s1024 = new StringBuilder(1024);
        while (s1024.length() < 1024) {
            s1024.append(65 + s1024.length() % 10);
        }
        value1024 = s1024.toString();
        value1024commaAtEnd = value1024 + ',';
    }
}

