/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.netty.microbench.channel.EmbeddedChannelWriteReleaseHandlerContext;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@State(value=Scope.Benchmark)
@Fork(value=2)
@Threads(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class WebSocketFrame08EncoderBenchmark
extends AbstractMicrobenchmark {
    private WebSocket08FrameEncoder websocketEncoder;
    private ChannelHandlerContext context;
    private ByteBuf content;
    private BinaryWebSocketFrame webSocketFrame;
    @Param(value={"0", "2", "4", "8", "32", "100", "1000", "3000"})
    public int contentLength;
    @Param(value={"true", "false"})
    public boolean pooledAllocator;
    @Param(value={"true"})
    public boolean masking;
    @Param(value={"true", "false"})
    public boolean voidPromise;

    @Setup(value=Level.Trial)
    public void setUp() {
        byte[] bytes = new byte[this.contentLength];
        ThreadLocalRandom.current().nextBytes(bytes);
        PooledByteBufAllocator allocator = this.pooledAllocator ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        this.content = allocator.buffer(this.contentLength).writeBytes(bytes);
        ByteBuf testContent = Unpooled.unreleasableBuffer((ByteBuf)this.content.asReadOnly());
        this.webSocketFrame = new BinaryWebSocketFrame(testContent);
        this.websocketEncoder = new WebSocket08FrameEncoder(this.masking);
        this.context = new EmbeddedChannelWriteReleaseHandlerContext((ByteBufAllocator)allocator, (ChannelHandler)this.websocketEncoder){

            @Override
            protected void handleException(Throwable t) {
                AbstractMicrobenchmarkBase.handleUnexpectedException(t);
            }
        };
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.content.release();
        this.content = null;
    }

    @Benchmark
    public ChannelFuture writeWebSocketFrame() throws Exception {
        ChannelPromise promise = this.newPromise();
        this.websocketEncoder.write(this.context, (Object)this.webSocketFrame, promise);
        return promise;
    }

    private ChannelPromise newPromise() {
        return this.voidPromise ? this.context.voidPromise() : this.context.newPromise();
    }

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        return super.newOptionsBuilder().addProfiler(GCProfiler.class);
    }
}

