/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.SplittableRandom;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Warmup(iterations=10)
@Measurement(iterations=10)
@Fork(value=5)
@State(value=Scope.Thread)
public class DefaultChannelPipelineBenchmark
extends AbstractMicrobenchmark {
    private static final Object MESSAGE = new Object();
    private static final ChannelHandler INBOUND_CONSUMING_HANDLER = new SharableInboundHandlerAdapter(){

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
        }
    };
    private static final ChannelHandler OUTBOUND_CONSUMING_HANDLER = new SharableOutboundHandlerAdapter(){

        public void read(ChannelHandlerContext ctx) throws Exception {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
        }
    };
    private static final ChannelHandler[] HANDLERS = new ChannelHandler[]{new SharableInboundHandlerAdapter(){

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelActive();
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelInactive();
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.fireChannelRead(msg);
        }
    }, new SharableInboundHandlerAdapter(){

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            ctx.fireUserEventTriggered(evt);
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelInactive();
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelActive();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.fireChannelRead(msg);
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelActive();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            ctx.fireUserEventTriggered(evt);
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelActive();
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelInactive();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.fireChannelRead(msg);
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelInactive();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            ctx.fireUserEventTriggered(evt);
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelInactive();
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.fireChannelRead(msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            ctx.fireUserEventTriggered(evt);
        }
    }, new SharableInboundHandlerAdapter(){

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.fireChannelRead(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
        }
    }, new SharableInboundHandlerAdapter(){

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            ctx.fireUserEventTriggered(evt);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
        }
    }, new SharableOutboundHandlerAdapter(){

        public void read(ChannelHandlerContext ctx) throws Exception {
            ctx.read();
        }
    }, new SharableOutboundHandlerAdapter(){

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            ctx.write(msg, promise);
        }
    }, new SharableOutboundHandlerAdapter(){

        public void flush(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }
    }, new SharableOutboundHandlerAdapter(){

        public void read(ChannelHandlerContext ctx) throws Exception {
            ctx.read();
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            ctx.write(msg, promise);
        }
    }, new SharableOutboundHandlerAdapter(){

        public void read(ChannelHandlerContext ctx) throws Exception {
            ctx.read();
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }
    }, new SharableOutboundHandlerAdapter(){

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            ctx.write(msg, promise);
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }
    }};
    private static final int CALL_TYPE_ARRAY_SIZE = 1024;
    private static final int CALL_TYPE_ARRAY_MASK = 1023;
    @Param(value={"1024"})
    private int pipelineArrayLength;
    private int pipelineArrayMask;
    @Param(value={"16"})
    public int extraHandlers;
    private ChannelPipeline[] pipelines;
    private ChannelPromise[] promises;
    private int pipelineCounter;
    private int[] callTypes;
    private int callTypeCounter;

    @Setup(value=Level.Iteration)
    public void setup() {
        SplittableRandom rng = new SplittableRandom();
        this.pipelineArrayMask = this.pipelineArrayLength - 1;
        this.pipelines = new ChannelPipeline[this.pipelineArrayLength];
        this.promises = new ChannelPromise[this.pipelineArrayLength];
        for (int i = 0; i < this.pipelineArrayLength; ++i) {
            EmbeddedChannel channel = new EmbeddedChannel();
            channel.config().setAutoRead(false);
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{OUTBOUND_CONSUMING_HANDLER});
            for (int j = 0; j < this.extraHandlers; ++j) {
                pipeline.addLast(new ChannelHandler[]{HANDLERS[rng.nextInt(0, HANDLERS.length)]});
            }
            pipeline.addLast(new ChannelHandler[]{INBOUND_CONSUMING_HANDLER});
            this.pipelines[i] = pipeline;
            this.promises[i] = pipeline.newPromise();
        }
    }

    @TearDown
    public void tearDown() {
        for (ChannelPipeline pipeline : this.pipelines) {
            pipeline.channel().close();
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    @Benchmark
    public void propagateEvent(Blackhole hole) {
        ChannelPipeline pipeline = this.pipelines[this.pipelineCounter++ & this.pipelineArrayMask];
        hole.consume((Object)pipeline.fireChannelReadComplete());
    }

    @OperationsPerInvocation(value=12)
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    @Benchmark
    public void propagateVariety(Blackhole hole) {
        int index = this.pipelineCounter++ & this.pipelineArrayMask;
        ChannelPipeline pipeline = this.pipelines[index];
        hole.consume((Object)pipeline.fireChannelActive());
        hole.consume((Object)pipeline.fireChannelRead(MESSAGE));
        hole.consume((Object)pipeline.fireChannelRead(MESSAGE));
        hole.consume((Object)pipeline.write(MESSAGE, this.promises[index]));
        hole.consume((Object)pipeline.fireChannelRead(MESSAGE));
        hole.consume((Object)pipeline.fireChannelRead(MESSAGE));
        hole.consume((Object)pipeline.write(MESSAGE, this.promises[index]));
        hole.consume((Object)pipeline.fireChannelReadComplete());
        hole.consume((Object)pipeline.fireUserEventTriggered(MESSAGE));
        hole.consume((Object)pipeline.fireChannelWritabilityChanged());
        hole.consume((Object)pipeline.flush());
        hole.consume((Object)pipeline.fireChannelInactive());
    }

    private static abstract class SharableOutboundHandlerAdapter
    extends ChannelOutboundHandlerAdapter {
        private SharableOutboundHandlerAdapter() {
        }

        public final boolean isSharable() {
            return true;
        }
    }

    private static abstract class SharableInboundHandlerAdapter
    extends ChannelInboundHandlerAdapter {
        private SharableInboundHandlerAdapter() {
        }

        public final boolean isSharable() {
            return true;
        }
    }
}

