/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.nio.ByteOrder;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=10)
@Measurement(iterations=25)
public class SwappedByteBufBenchmark
extends AbstractMicrobenchmark {
    private ByteBuf swappedByteBuf;
    private ByteBuf unsafeSwappedByteBuf;
    @Param(value={"16384"})
    public int size;

    @Setup
    public void setup() {
        this.swappedByteBuf = new SwappedByteBuf(Unpooled.directBuffer((int)8));
        this.unsafeSwappedByteBuf = Unpooled.directBuffer((int)8).order(ByteOrder.LITTLE_ENDIAN);
        if (this.unsafeSwappedByteBuf.getClass().equals(SwappedByteBuf.class)) {
            throw new IllegalStateException("Should not use " + SwappedByteBuf.class.getSimpleName());
        }
    }

    @Benchmark
    public void swappedByteBufSetInt() {
        this.swappedByteBuf.setLong(0, (long)this.size);
    }

    @Benchmark
    public void swappedByteBufSetShort() {
        this.swappedByteBuf.setShort(0, this.size);
    }

    @Benchmark
    public void swappedByteBufSetLong() {
        this.swappedByteBuf.setLong(0, (long)this.size);
    }

    @Benchmark
    public void unsafeSwappedByteBufSetInt() {
        this.unsafeSwappedByteBuf.setInt(0, this.size);
    }

    @Benchmark
    public void unsafeSwappedByteBufSetShort() {
        this.unsafeSwappedByteBuf.setShort(0, this.size);
    }

    @Benchmark
    public void unsafeSwappedByteBufSetLong() {
        this.unsafeSwappedByteBuf.setLong(0, (long)this.size);
    }
}

