/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.CleanableDirectBuffer;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Warmup(iterations=10, time=1)
@Measurement(iterations=10, time=1)
@Fork(value=2)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ByteBufAccessBenchmark
extends AbstractMicrobenchmark {
    @Param
    public ByteBufType bufferType;
    @Param(value={"true", "false"})
    public String checkAccessible;
    @Param(value={"true", "false"})
    public String checkBounds;
    @Param(value={"8"})
    public int batchSize;
    private ByteBuf buffer;
    private byte byteToWrite;
    private int intToWrite;
    private long longToWrite;
    private short shortToWrite;

    @Setup
    public void setup() {
        System.setProperty("io.netty.buffer.checkAccessible", this.checkAccessible);
        System.setProperty("io.netty.buffer.checkBounds", this.checkBounds);
        this.buffer = this.bufferType.newBuffer();
    }

    @TearDown
    public void tearDown() {
        this.buffer.release();
        System.clearProperty("io.netty.buffer.checkAccessible");
        System.clearProperty("io.netty.buffer.checkBounds");
    }

    @Benchmark
    public long setGetLong() {
        return this.buffer.setLong(0, 1L).getLong(0);
    }

    @Benchmark
    public ByteBuf setLong() {
        return this.buffer.setLong(0, 1L);
    }

    @Benchmark
    public int readBatch() {
        this.buffer.readerIndex(0);
        int result = 0;
        int size = this.batchSize;
        for (int i = 0; i < size; ++i) {
            result += this.buffer.readByte();
        }
        return result;
    }

    @Benchmark
    public void getByteBatch(Blackhole bh) {
        ByteBuf buffer = this.buffer;
        int size = this.batchSize;
        for (int i = 0; i < size; ++i) {
            bh.consume(buffer.getByte(i));
        }
    }

    @Benchmark
    public void setByteBatch(Blackhole bh) {
        ByteBuf buffer = this.buffer;
        byte byteToWrite = this.byteToWrite;
        buffer.resetWriterIndex();
        int size = this.batchSize;
        for (int i = 0; i < size; ++i) {
            bh.consume((Object)buffer.setByte(i, (int)byteToWrite));
        }
    }

    @Benchmark
    public void readByteBatch(Blackhole bh) {
        ByteBuf buffer = this.buffer;
        buffer.readerIndex(0);
        int size = this.batchSize;
        for (int i = 0; i < size; ++i) {
            bh.consume(buffer.readByte());
        }
    }

    @Benchmark
    public void setBytes(Blackhole bh) {
        ByteBuf buffer = this.buffer;
        byte byteToWrite = this.byteToWrite;
        int intToWrite = this.intToWrite;
        long longToWrite = this.longToWrite;
        short shortToWrite = this.shortToWrite;
        buffer.resetWriterIndex();
        int index = buffer.writerIndex();
        bh.consume((Object)buffer.setByte(index, (int)byteToWrite));
        bh.consume((Object)buffer.setShortLE(++index, (int)shortToWrite));
        bh.consume((Object)buffer.setIntLE(index += 2, intToWrite));
        bh.consume((Object)buffer.setLongLE(index += 4, longToWrite));
    }

    @Benchmark
    public void getBytes(Blackhole bh) {
        ByteBuf buffer = this.buffer;
        int readerIndex = buffer.readerIndex();
        bh.consume(buffer.getByte(readerIndex));
        bh.consume(buffer.getShortLE(++readerIndex));
        bh.consume(buffer.getIntLE(readerIndex += 2));
        bh.consume(buffer.getLongLE(readerIndex += 4));
    }

    @Benchmark
    public void setBytesConstantOffset(Blackhole bh) {
        ByteBuf buffer = this.buffer;
        buffer.resetWriterIndex();
        byte byteToWrite = this.byteToWrite;
        int intToWrite = this.intToWrite;
        long longToWrite = this.longToWrite;
        short shortToWrite = this.shortToWrite;
        bh.consume((Object)buffer.setByte(0, (int)byteToWrite));
        bh.consume((Object)buffer.setShortLE(1, (int)shortToWrite));
        bh.consume((Object)buffer.setIntLE(3, intToWrite));
        bh.consume((Object)buffer.setLongLE(7, longToWrite));
    }

    @Benchmark
    public void getBytesConstantOffset(Blackhole bh) {
        ByteBuf buffer = this.buffer;
        bh.consume(buffer.getByte(0));
        bh.consume(buffer.getShortLE(1));
        bh.consume(buffer.getIntLE(3));
        bh.consume(buffer.getLongLE(7));
    }

    @Benchmark
    public void readBytes(Blackhole bh) {
        this.buffer.readerIndex(0);
        ByteBuf buffer = this.buffer;
        bh.consume(buffer.readByte());
        bh.consume(buffer.readShortLE());
        bh.consume(buffer.readIntLE());
        bh.consume(buffer.readLongLE());
    }

    public static enum ByteBufType {
        UNSAFE{

            @Override
            ByteBuf newBuffer() {
                return new UnpooledUnsafeDirectByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 64, 64).setIndex(0, 64);
            }
        }
        ,
        UNSAFE_SLICE{

            @Override
            ByteBuf newBuffer() {
                return UNSAFE.newBuffer().slice(16, 48);
            }
        }
        ,
        UNSAFE_RETAINED_SLICE{

            @Override
            ByteBuf newBuffer() {
                ByteBuf pooledBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(64, 64).setIndex(0, 64);
                if (!(pooledBuffer instanceof PooledUnsafeDirectByteBuf)) {
                    throw new IllegalStateException("Expected PooledUnsafeDirectByteBuf");
                }
                try {
                    ByteBuf byteBuf = pooledBuffer.retainedSlice(16, 48);
                    return byteBuf;
                }
                finally {
                    pooledBuffer.release();
                }
            }
        }
        ,
        HEAP{

            @Override
            ByteBuf newBuffer() {
                return new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 64, 64).setIndex(0, 64);
            }
        }
        ,
        COMPOSITE{

            @Override
            ByteBuf newBuffer() {
                return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{UNSAFE.newBuffer(), HEAP.newBuffer()});
            }
        }
        ,
        NIO{

            @Override
            ByteBuf newBuffer() {
                return new NioFacade(PlatformDependent.allocateDirect((int)64));
            }
        };


        abstract ByteBuf newBuffer();
    }

    static final class NioFacade
    extends WrappedByteBuf {
        private final ByteBuffer byteBuffer;
        private final CleanableDirectBuffer cleanable;

        NioFacade(CleanableDirectBuffer buffer) {
            super(Unpooled.EMPTY_BUFFER);
            this.byteBuffer = buffer.buffer();
            this.cleanable = buffer;
        }

        public ByteBuf setLong(int index, long value) {
            this.byteBuffer.putLong(index, value);
            return this;
        }

        public long getLong(int index) {
            return this.byteBuffer.getLong(index);
        }

        public byte readByte() {
            return this.byteBuffer.get();
        }

        public ByteBuf touch() {
            this.byteBuffer.position(0);
            return this;
        }

        public boolean release() {
            this.cleanable.clean();
            return true;
        }
    }
}

