/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.localecho;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalIoHandler;
import io.netty.channel.local.LocalServerChannel;
import io.netty.example.localecho.LocalEchoClientHandler;
import io.netty.example.localecho.LocalEchoServerHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.SocketAddress;

public final class LocalEcho {
    static final String PORT = System.getProperty("port", "test_port");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LocalAddress addr = new LocalAddress(PORT);
        MultiThreadIoEventLoopGroup serverGroup = new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory());
        MultiThreadIoEventLoopGroup clientGroup = new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory());
        try {
            String line;
            ServerBootstrap sb = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)sb.group((EventLoopGroup)serverGroup).channel(LocalServerChannel.class)).handler((ChannelHandler)new ChannelInitializer<LocalServerChannel>(){

                public void initChannel(LocalServerChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
                }
            })).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                public void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new LocalEchoServerHandler()});
                }
            });
            Bootstrap cb = new Bootstrap();
            ((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)clientGroup)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                public void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new LocalEchoClientHandler()});
                }
            });
            sb.bind((SocketAddress)addr).sync();
            Channel ch = cb.connect((SocketAddress)addr).sync().channel();
            System.out.println("Enter text (quit to end)");
            ChannelFuture lastWriteFuture = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null && !"quit".equalsIgnoreCase(line)) {
                lastWriteFuture = ch.writeAndFlush((Object)line);
            }
            if (lastWriteFuture != null) {
                lastWriteFuture.awaitUninterruptibly();
            }
        }
        finally {
            serverGroup.shutdownGracefully();
            clientGroup.shutdownGracefully();
        }
    }
}

