/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.spdy.client.HttpResponseClientHandler;
import io.netty.example.spdy.client.SpdyClientStreamIdHandler;
import io.netty.example.spdy.client.SpdyFrameLogger;
import io.netty.handler.codec.spdy.SpdyFrameCodec;
import io.netty.handler.codec.spdy.SpdyHttpDecoder;
import io.netty.handler.codec.spdy.SpdyHttpEncoder;
import io.netty.handler.codec.spdy.SpdySessionHandler;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.logging.InternalLogLevel;

public class SpdyClientInitializer
extends ChannelInitializer<SocketChannel> {
    private static final int MAX_SPDY_CONTENT_LENGTH = 0x100000;
    private final SslContext sslCtx;
    private final HttpResponseClientHandler httpResponseHandler;

    public SpdyClientInitializer(SslContext sslCtx, HttpResponseClientHandler httpResponseHandler) {
        this.sslCtx = sslCtx;
        this.httpResponseHandler = httpResponseHandler;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        pipeline.addLast("spdyFrameCodec", (ChannelHandler)new SpdyFrameCodec(SpdyVersion.SPDY_3_1));
        pipeline.addLast("spdyFrameLogger", (ChannelHandler)new SpdyFrameLogger(InternalLogLevel.INFO));
        pipeline.addLast("spdySessionHandler", (ChannelHandler)new SpdySessionHandler(SpdyVersion.SPDY_3_1, false));
        pipeline.addLast("spdyHttpEncoder", (ChannelHandler)new SpdyHttpEncoder(SpdyVersion.SPDY_3_1));
        pipeline.addLast("spdyHttpDecoder", (ChannelHandler)new SpdyHttpDecoder(SpdyVersion.SPDY_3_1, 0x100000));
        pipeline.addLast("spdyStreamIdHandler", (ChannelHandler)new SpdyClientStreamIdHandler());
        pipeline.addLast("httpHandler", (ChannelHandler)this.httpResponseHandler);
    }
}

