/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.stomp.StompClientHandler;
import io.netty.handler.codec.stomp.StompSubframeAggregator;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import io.netty.handler.codec.stomp.StompSubframeEncoder;

public final class StompClient {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", "61613"));
    static final String LOGIN = System.getProperty("login", "guest");
    static final String PASSCODE = System.getProperty("passcode", "guest");
    static final String TOPIC = System.getProperty("topic", "jms.topic.exampleTopic");

    public static void main(String[] args) throws Exception {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("decoder", (ChannelHandler)new StompSubframeDecoder());
                    pipeline.addLast("encoder", (ChannelHandler)new StompSubframeEncoder());
                    pipeline.addLast("aggregator", (ChannelHandler)new StompSubframeAggregator(0x100000));
                    pipeline.addLast("handler", (ChannelHandler)new StompClientHandler());
                }
            });
            b.connect(HOST, PORT).sync().channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

