/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.springdata.v4.config;

import com.mongodb.ReadConcern;
import io.mongock.api.config.MongockConfiguration;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.mongodb.springdata.v4.SpringDataMongoV4DriverBase;
import io.mongock.driver.mongodb.springdata.v4.config.MongoDBConfiguration;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class SpringDataMongoV4ContextBase<CONFIG extends MongockConfiguration, DRIVER extends SpringDataMongoV4DriverBase> {
    @Bean
    public ConnectionDriver connectionDriver(MongoTemplate mongoTemplate, CONFIG config, MongoDBConfiguration mongoDbConfig, Optional<PlatformTransactionManager> txManagerOpt) {
        DRIVER driver = this.buildDriver(mongoTemplate, config, mongoDbConfig, txManagerOpt);
        this.setGenericDriverConfig(config, txManagerOpt, driver);
        this.setMongoDBConfig(mongoDbConfig, driver);
        driver.initialize();
        return driver;
    }

    protected abstract DRIVER buildDriver(MongoTemplate var1, CONFIG var2, MongoDBConfiguration var3, Optional<PlatformTransactionManager> var4);

    private void setGenericDriverConfig(CONFIG config, Optional<PlatformTransactionManager> txManagerOpt, DRIVER driver) {
        txManagerOpt.filter(tx -> config.getTransactionEnabled().orElse(true)).ifPresent(tx -> driver.enableTransaction());
        driver.setMigrationRepositoryName(config.getMigrationRepositoryName());
        driver.setLockRepositoryName(config.getLockRepositoryName());
        driver.setIndexCreation(config.isIndexCreation());
    }

    private void setMongoDBConfig(MongoDBConfiguration mongoDbConfig, DRIVER driver) {
        driver.setWriteConcern(mongoDbConfig.getBuiltMongoDBWriteConcern());
        driver.setReadConcern(new ReadConcern(mongoDbConfig.getReadConcern()));
        driver.setReadPreference(mongoDbConfig.getReadPreference().getValue());
    }
}

