/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.springdata.v3.config;

import io.mongock.api.config.MongockConfiguration;
import io.mongock.driver.mongodb.springdata.v3.SpringDataMongoV3Driver;
import io.mongock.driver.mongodb.springdata.v3.config.MongoDBConfiguration;
import io.mongock.driver.mongodb.springdata.v3.config.SpringDataMongoV3ContextBase;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
@ConditionalOnExpression(value="${mongock.enabled:true}")
@ConditionalOnBean(value={MongockConfiguration.class})
@EnableConfigurationProperties(value={MongoDBConfiguration.class})
public class SpringDataMongoV3Context
extends SpringDataMongoV3ContextBase<MongockConfiguration, SpringDataMongoV3Driver> {
    @Override
    protected SpringDataMongoV3Driver buildDriver(MongoTemplate mongoTemplate, MongockConfiguration config, MongoDBConfiguration mongoDbConfig) {
        return SpringDataMongoV3Driver.withLockStrategy(mongoTemplate, config.getLockAcquiredForMillis(), config.getLockQuitTryingAfterMillis(), config.getLockTryFrequencyMillis());
    }
}

