/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.api.entry;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.RepositoryIndexable;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.api.entry.ChangeEntryExecuted;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.utils.Process;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface ChangeEntryService
extends RepositoryIndexable,
Process {
    @Deprecated
    default public boolean isAlreadyExecuted(String changeSetId, String author) {
        throw new UnsupportedOperationException("THIS IS DEPRECATED AND WILL BE REMOVED");
    }

    default public List<ChangeEntryExecuted> getExecuted() throws MongockException {
        Predicate<ChangeEntry> cleanIrrelevantState = entry -> entry.getState() != ChangeState.IGNORED && entry.getState() != ChangeState.FAILED && entry.getState() != ChangeState.ROLLBACK_FAILED;
        return this.getEntriesMap().values().stream().map(duplicatedEntries -> duplicatedEntries.stream().filter(cleanIrrelevantState).collect(Collectors.toList())).filter(duplicatedEntries -> !duplicatedEntries.isEmpty()).map(duplicatedEntries -> (ChangeEntry)duplicatedEntries.get(0)).sorted(Comparator.comparing(ChangeEntry::getOriginalTimestamp)).filter(ChangeEntry::isExecuted).map(ChangeEntryExecuted::new).collect(Collectors.toList());
    }

    default public List<ChangeEntry> getAllEntriesWithCurrentState() throws MongockException {
        return this.getEntriesMap().values().stream().map(duplicatedEntries -> duplicatedEntries.stream().filter(ChangeEntry::hasRelevantState).collect(Collectors.toList())).filter(duplicatedEntries -> !duplicatedEntries.isEmpty()).map(duplicatedEntries -> (ChangeEntry)duplicatedEntries.get(0)).sorted(Comparator.comparing(ChangeEntry::getOriginalTimestamp)).collect(Collectors.toList());
    }

    default public Map<String, List<ChangeEntry>> getEntriesMap() {
        Map<String, List<ChangeEntry>> log = this.getEntriesLog().stream().collect(Collectors.groupingBy(ChangeEntry::getChangeId));
        log.values().forEach(entries -> {
            entries.sort((c1, c2) -> c2.getTimestamp().compareTo(c1.getTimestamp()));
            Date originalTimestamp = ((ChangeEntry)entries.get(entries.size() - 1)).getTimestamp();
            entries.forEach(entry -> entry.setOriginalTimestamp(originalTimestamp));
        });
        return log;
    }

    public List<ChangeEntry> getEntriesLog();

    public void saveOrUpdate(ChangeEntry var1) throws MongockException;

    public void deleteAll();
}

