/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import io.modelcontextprotocol.util.Assert;
import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.publisher.Mono;

@Deprecated
public class WebMvcSseServerTransport
implements ServerMcpTransport {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcSseServerTransport.class);
    public static final String MESSAGE_EVENT_TYPE = "message";
    public static final String ENDPOINT_EVENT_TYPE = "endpoint";
    public static final String DEFAULT_SSE_ENDPOINT = "/sse";
    private final ObjectMapper objectMapper;
    private final String messageEndpoint;
    private final String sseEndpoint;
    private final RouterFunction<ServerResponse> routerFunction;
    private final ConcurrentHashMap<String, ClientSession> sessions = new ConcurrentHashMap();
    private volatile boolean isClosing = false;
    private Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> connectHandler;

    public WebMvcSseServerTransport(ObjectMapper objectMapper, String messageEndpoint, String sseEndpoint) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)messageEndpoint, (String)"Message endpoint must not be null");
        Assert.notNull((Object)sseEndpoint, (String)"SSE endpoint must not be null");
        this.objectMapper = objectMapper;
        this.messageEndpoint = messageEndpoint;
        this.sseEndpoint = sseEndpoint;
        this.routerFunction = RouterFunctions.route().GET(this.sseEndpoint, this::handleSseConnection).POST(this.messageEndpoint, this::handleMessage).build();
    }

    public WebMvcSseServerTransport(ObjectMapper objectMapper, String messageEndpoint) {
        this(objectMapper, messageEndpoint, DEFAULT_SSE_ENDPOINT);
    }

    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> connectionHandler) {
        this.connectHandler = connectionHandler;
        return Mono.empty();
    }

    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        return Mono.fromRunnable(() -> {
            if (this.sessions.isEmpty()) {
                logger.debug("No active sessions to broadcast message to");
                return;
            }
            try {
                String jsonText = this.objectMapper.writeValueAsString((Object)message);
                logger.debug("Attempting to broadcast message to {} active sessions", (Object)this.sessions.size());
                this.sessions.values().forEach(session -> {
                    try {
                        session.sseBuilder.id(session.id).event(MESSAGE_EVENT_TYPE).data((Object)jsonText);
                    }
                    catch (Exception e) {
                        logger.error("Failed to send message to session {}: {}", (Object)session.id, (Object)e.getMessage());
                        session.sseBuilder.error((Throwable)e);
                    }
                });
            }
            catch (IOException e) {
                logger.error("Failed to serialize message: {}", (Object)e.getMessage());
            }
        });
    }

    private ServerResponse handleSseConnection(ServerRequest request) {
        if (this.isClosing) {
            return ServerResponse.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)"Server is shutting down");
        }
        String sessionId = UUID.randomUUID().toString();
        logger.debug("Creating new SSE connection for session: {}", (Object)sessionId);
        try {
            return ServerResponse.sse(sseBuilder -> {
                sseBuilder.onComplete(() -> {
                    logger.debug("SSE connection completed for session: {}", (Object)sessionId);
                    this.sessions.remove(sessionId);
                });
                sseBuilder.onTimeout(() -> {
                    logger.debug("SSE connection timed out for session: {}", (Object)sessionId);
                    this.sessions.remove(sessionId);
                });
                ClientSession session = new ClientSession(sessionId, (ServerResponse.SseBuilder)sseBuilder);
                this.sessions.put(sessionId, session);
                try {
                    session.sseBuilder.id(session.id).event(ENDPOINT_EVENT_TYPE).data((Object)this.messageEndpoint);
                }
                catch (Exception e) {
                    logger.error("Failed to poll event from session queue: {}", (Object)e.getMessage());
                    sseBuilder.error((Throwable)e);
                }
            }, (Duration)Duration.ZERO);
        }
        catch (Exception e) {
            logger.error("Failed to send initial endpoint event to session {}: {}", (Object)sessionId, (Object)e.getMessage());
            this.sessions.remove(sessionId);
            return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private ServerResponse handleMessage(ServerRequest request) {
        if (this.isClosing) {
            return ServerResponse.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)"Server is shutting down");
        }
        try {
            String body = (String)request.body(String.class);
            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)body);
            McpSchema.JSONRPCMessage response = (McpSchema.JSONRPCMessage)Mono.just((Object)message).transform(this.connectHandler).block();
            return ServerResponse.ok().build();
        }
        catch (IOException | IllegalArgumentException e) {
            logger.error("Failed to deserialize message: {}", (Object)e.getMessage());
            return ServerResponse.badRequest().body((Object)new McpError((Object)"Invalid message format"));
        }
        catch (Exception e) {
            logger.error("Error handling message: {}", (Object)e.getMessage());
            return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new McpError((Object)e.getMessage()));
        }
    }

    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }

    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> {
            this.isClosing = true;
            logger.debug("Initiating graceful shutdown with {} active sessions", (Object)this.sessions.size());
            this.sessions.values().forEach(session -> {
                String sessionId = session.id;
                session.close();
                this.sessions.remove(sessionId);
            });
            logger.debug("Graceful shutdown completed");
        });
    }

    public RouterFunction<ServerResponse> getRouterFunction() {
        return this.routerFunction;
    }

    private static class ClientSession {
        private final String id;
        private final ServerResponse.SseBuilder sseBuilder;

        ClientSession(String id, ServerResponse.SseBuilder sseBuilder) {
            this.id = id;
            this.sseBuilder = sseBuilder;
            logger.debug("Session {} initialized with SSE emitter", (Object)id);
        }

        void close() {
            logger.debug("Closing session: {}", (Object)this.id);
            try {
                this.sseBuilder.complete();
                logger.debug("Successfully completed SSE emitter for session {}", (Object)this.id);
            }
            catch (Exception e) {
                logger.warn("Failed to complete SSE emitter for session {}: {}", (Object)this.id, (Object)e.getMessage());
            }
        }
    }
}

