/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.reflect.TypeToken;
import io.grpc.StatusRuntimeException;
import io.milvus.client.MilvusClient;
import io.milvus.common.utils.GTsDict;
import io.milvus.common.utils.JsonUtils;
import io.milvus.common.utils.VectorUtils;
import io.milvus.exception.ClientNotConnectedException;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ServerException;
import io.milvus.grpc.AlterAliasRequest;
import io.milvus.grpc.AlterCollectionRequest;
import io.milvus.grpc.AlterDatabaseRequest;
import io.milvus.grpc.AlterIndexRequest;
import io.milvus.grpc.BoolResponse;
import io.milvus.grpc.CheckHealthRequest;
import io.milvus.grpc.CheckHealthResponse;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.CreateAliasRequest;
import io.milvus.grpc.CreateCollectionRequest;
import io.milvus.grpc.CreateCredentialRequest;
import io.milvus.grpc.CreateDatabaseRequest;
import io.milvus.grpc.CreateIndexRequest;
import io.milvus.grpc.CreatePartitionRequest;
import io.milvus.grpc.CreateResourceGroupRequest;
import io.milvus.grpc.CreateRoleRequest;
import io.milvus.grpc.DeleteCredentialRequest;
import io.milvus.grpc.DeleteRequest;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DescribeDatabaseRequest;
import io.milvus.grpc.DescribeDatabaseResponse;
import io.milvus.grpc.DescribeIndexRequest;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.DescribeResourceGroupRequest;
import io.milvus.grpc.DescribeResourceGroupResponse;
import io.milvus.grpc.DropAliasRequest;
import io.milvus.grpc.DropCollectionRequest;
import io.milvus.grpc.DropDatabaseRequest;
import io.milvus.grpc.DropIndexRequest;
import io.milvus.grpc.DropPartitionRequest;
import io.milvus.grpc.DropResourceGroupRequest;
import io.milvus.grpc.DropRoleRequest;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.FlushAllRequest;
import io.milvus.grpc.FlushAllResponse;
import io.milvus.grpc.FlushRequest;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.GetCollectionStatisticsRequest;
import io.milvus.grpc.GetCollectionStatisticsResponse;
import io.milvus.grpc.GetCompactionPlansRequest;
import io.milvus.grpc.GetCompactionPlansResponse;
import io.milvus.grpc.GetCompactionStateRequest;
import io.milvus.grpc.GetCompactionStateResponse;
import io.milvus.grpc.GetFlushAllStateRequest;
import io.milvus.grpc.GetFlushAllStateResponse;
import io.milvus.grpc.GetFlushStateRequest;
import io.milvus.grpc.GetFlushStateResponse;
import io.milvus.grpc.GetImportStateRequest;
import io.milvus.grpc.GetImportStateResponse;
import io.milvus.grpc.GetIndexBuildProgressRequest;
import io.milvus.grpc.GetIndexBuildProgressResponse;
import io.milvus.grpc.GetIndexStateRequest;
import io.milvus.grpc.GetIndexStateResponse;
import io.milvus.grpc.GetLoadStateRequest;
import io.milvus.grpc.GetLoadStateResponse;
import io.milvus.grpc.GetLoadingProgressRequest;
import io.milvus.grpc.GetLoadingProgressResponse;
import io.milvus.grpc.GetMetricsRequest;
import io.milvus.grpc.GetMetricsResponse;
import io.milvus.grpc.GetPartitionStatisticsRequest;
import io.milvus.grpc.GetPartitionStatisticsResponse;
import io.milvus.grpc.GetPersistentSegmentInfoRequest;
import io.milvus.grpc.GetPersistentSegmentInfoResponse;
import io.milvus.grpc.GetQuerySegmentInfoRequest;
import io.milvus.grpc.GetQuerySegmentInfoResponse;
import io.milvus.grpc.GetReplicasRequest;
import io.milvus.grpc.GetReplicasResponse;
import io.milvus.grpc.GetVersionRequest;
import io.milvus.grpc.GetVersionResponse;
import io.milvus.grpc.GrantEntity;
import io.milvus.grpc.GrantorEntity;
import io.milvus.grpc.HasCollectionRequest;
import io.milvus.grpc.HasPartitionRequest;
import io.milvus.grpc.HybridSearchRequest;
import io.milvus.grpc.ImportRequest;
import io.milvus.grpc.ImportResponse;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.IndexState;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.ListAliasesRequest;
import io.milvus.grpc.ListAliasesResponse;
import io.milvus.grpc.ListCredUsersRequest;
import io.milvus.grpc.ListCredUsersResponse;
import io.milvus.grpc.ListDatabasesRequest;
import io.milvus.grpc.ListDatabasesResponse;
import io.milvus.grpc.ListImportTasksRequest;
import io.milvus.grpc.ListImportTasksResponse;
import io.milvus.grpc.ListResourceGroupsRequest;
import io.milvus.grpc.ListResourceGroupsResponse;
import io.milvus.grpc.LoadBalanceRequest;
import io.milvus.grpc.LoadCollectionRequest;
import io.milvus.grpc.LoadPartitionsRequest;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.ManualCompactionRequest;
import io.milvus.grpc.ManualCompactionResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgType;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.ObjectEntity;
import io.milvus.grpc.OperatePrivilegeRequest;
import io.milvus.grpc.OperatePrivilegeType;
import io.milvus.grpc.OperateUserRoleRequest;
import io.milvus.grpc.OperateUserRoleType;
import io.milvus.grpc.PrivilegeEntity;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.ReleaseCollectionRequest;
import io.milvus.grpc.ReleasePartitionsRequest;
import io.milvus.grpc.RenameCollectionRequest;
import io.milvus.grpc.RoleEntity;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.SelectGrantRequest;
import io.milvus.grpc.SelectGrantResponse;
import io.milvus.grpc.SelectRoleRequest;
import io.milvus.grpc.SelectRoleResponse;
import io.milvus.grpc.SelectUserRequest;
import io.milvus.grpc.SelectUserResponse;
import io.milvus.grpc.ShowCollectionsRequest;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.ShowPartitionsRequest;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.grpc.ShowType;
import io.milvus.grpc.Status;
import io.milvus.grpc.TransferNodeRequest;
import io.milvus.grpc.TransferReplicaRequest;
import io.milvus.grpc.UpdateCredentialRequest;
import io.milvus.grpc.UpdateResourceGroupsRequest;
import io.milvus.grpc.UpsertRequest;
import io.milvus.grpc.UserEntity;
import io.milvus.orm.iterator.QueryIterator;
import io.milvus.orm.iterator.SearchIterator;
import io.milvus.param.LogLevel;
import io.milvus.param.ParamUtils;
import io.milvus.param.R;
import io.milvus.param.RpcStatus;
import io.milvus.param.alias.AlterAliasParam;
import io.milvus.param.alias.CreateAliasParam;
import io.milvus.param.alias.DropAliasParam;
import io.milvus.param.alias.ListAliasesParam;
import io.milvus.param.bulkinsert.BulkInsertParam;
import io.milvus.param.bulkinsert.GetBulkInsertStateParam;
import io.milvus.param.bulkinsert.ListBulkInsertTasksParam;
import io.milvus.param.collection.AlterCollectionParam;
import io.milvus.param.collection.AlterDatabaseParam;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.CreateDatabaseParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DescribeDatabaseParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.DropDatabaseParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.FlushParam;
import io.milvus.param.collection.GetCollectionStatisticsParam;
import io.milvus.param.collection.GetLoadStateParam;
import io.milvus.param.collection.GetLoadingProgressParam;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.collection.RenameCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.control.GetCompactionPlansParam;
import io.milvus.param.control.GetCompactionStateParam;
import io.milvus.param.control.GetFlushAllStateParam;
import io.milvus.param.control.GetFlushStateParam;
import io.milvus.param.control.GetMetricsParam;
import io.milvus.param.control.GetPersistentSegmentInfoParam;
import io.milvus.param.control.GetQuerySegmentInfoParam;
import io.milvus.param.control.GetReplicasParam;
import io.milvus.param.control.LoadBalanceParam;
import io.milvus.param.control.ManualCompactParam;
import io.milvus.param.credential.CreateCredentialParam;
import io.milvus.param.credential.DeleteCredentialParam;
import io.milvus.param.credential.ListCredUsersParam;
import io.milvus.param.credential.UpdateCredentialParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.HybridSearchParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryIteratorParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchIteratorParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.dml.UpsertParam;
import io.milvus.param.highlevel.collection.CreateSimpleCollectionParam;
import io.milvus.param.highlevel.collection.ListCollectionsParam;
import io.milvus.param.highlevel.collection.response.ListCollectionsResponse;
import io.milvus.param.highlevel.dml.DeleteIdsParam;
import io.milvus.param.highlevel.dml.GetIdsParam;
import io.milvus.param.highlevel.dml.InsertRowsParam;
import io.milvus.param.highlevel.dml.QuerySimpleParam;
import io.milvus.param.highlevel.dml.SearchSimpleParam;
import io.milvus.param.highlevel.dml.response.DeleteResponse;
import io.milvus.param.highlevel.dml.response.GetResponse;
import io.milvus.param.highlevel.dml.response.InsertResponse;
import io.milvus.param.highlevel.dml.response.QueryResponse;
import io.milvus.param.highlevel.dml.response.SearchResponse;
import io.milvus.param.index.AlterIndexParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DescribeIndexParam;
import io.milvus.param.index.DropIndexParam;
import io.milvus.param.index.GetIndexBuildProgressParam;
import io.milvus.param.index.GetIndexStateParam;
import io.milvus.param.partition.CreatePartitionParam;
import io.milvus.param.partition.DropPartitionParam;
import io.milvus.param.partition.GetPartitionStatisticsParam;
import io.milvus.param.partition.HasPartitionParam;
import io.milvus.param.partition.LoadPartitionsParam;
import io.milvus.param.partition.ReleasePartitionsParam;
import io.milvus.param.partition.ShowPartitionsParam;
import io.milvus.param.resourcegroup.CreateResourceGroupParam;
import io.milvus.param.resourcegroup.DescribeResourceGroupParam;
import io.milvus.param.resourcegroup.DropResourceGroupParam;
import io.milvus.param.resourcegroup.ListResourceGroupsParam;
import io.milvus.param.resourcegroup.TransferNodeParam;
import io.milvus.param.resourcegroup.TransferReplicaParam;
import io.milvus.param.resourcegroup.UpdateResourceGroupsParam;
import io.milvus.param.role.AddUserToRoleParam;
import io.milvus.param.role.CreateRoleParam;
import io.milvus.param.role.DropRoleParam;
import io.milvus.param.role.GrantRolePrivilegeParam;
import io.milvus.param.role.RemoveUserFromRoleParam;
import io.milvus.param.role.RevokeRolePrivilegeParam;
import io.milvus.param.role.SelectGrantForRoleAndObjectParam;
import io.milvus.param.role.SelectGrantForRoleParam;
import io.milvus.param.role.SelectRoleParam;
import io.milvus.param.role.SelectUserParam;
import io.milvus.response.DescCollResponseWrapper;
import io.milvus.response.MutationResultWrapper;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import io.milvus.response.ShowCollResponseWrapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMilvusGrpcClient
implements MilvusClient {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMilvusGrpcClient.class);
    protected LogLevel logLevel = LogLevel.Info;
    protected ConcurrentHashMap<String, DescribeCollectionResponse> cacheCollectionInfo = new ConcurrentHashMap();

    protected abstract MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub();

    protected abstract MilvusServiceGrpc.MilvusServiceFutureStub futureStub();

    protected abstract boolean clientIsReady();

    protected abstract String currentDbName();

    private String actualDbName(String overwriteName) {
        if (StringUtils.isNotEmpty((CharSequence)overwriteName)) {
            return overwriteName;
        }
        return this.currentDbName();
    }

    private DescribeCollectionResponse getCollectionInfo(String databaseName, String collectionName, boolean forceUpdate) {
        String key = GTsDict.CombineCollectionName(this.actualDbName(databaseName), collectionName);
        DescribeCollectionResponse info = this.cacheCollectionInfo.get(key);
        if (info == null || forceUpdate) {
            String msg = String.format("Fail to describe collection '%s'", collectionName);
            DescribeCollectionRequest.Builder builder = DescribeCollectionRequest.newBuilder().setCollectionName(collectionName);
            if (StringUtils.isNotEmpty((CharSequence)databaseName)) {
                builder.setDbName(databaseName);
                msg = String.format("Fail to describe collection '%s' in database '%s'", collectionName, databaseName);
            }
            DescribeCollectionRequest describeCollectionRequest = builder.build();
            DescribeCollectionResponse response = this.blockingStub().describeCollection(describeCollectionRequest);
            this.handleResponse(msg, response.getStatus());
            info = response;
            this.cacheCollectionInfo.put(key, info);
        }
        return info;
    }

    private void cleanCacheIfFailed(Status status, String databaseName, String collectionName) {
        if (status.getCode() != 0 && status.getCode() != 8 || !status.getErrorCode().equals((Object)ErrorCode.Success) && status.getErrorCode() != ErrorCode.RateLimit) {
            this.removeCollectionCache(databaseName, collectionName);
        }
    }

    private void removeCollectionCache(String databaseName, String collectionName) {
        String key = GTsDict.CombineCollectionName(this.actualDbName(databaseName), collectionName);
        this.cacheCollectionInfo.remove(key);
    }

    private void waitForLoadingCollection(String databaseName, String collectionName, List<String> partitionNames, long waitingInterval, long timeout) throws IllegalResponseException {
        block19: {
            long tsBegin = System.currentTimeMillis();
            if (partitionNames == null || partitionNames.isEmpty()) {
                ShowCollectionsRequest.Builder builder = ShowCollectionsRequest.newBuilder().addCollectionNames(collectionName).setType(ShowType.InMemory);
                if (StringUtils.isNotEmpty((CharSequence)databaseName)) {
                    builder.setDbName(databaseName);
                }
                ShowCollectionsRequest showCollectionRequest = builder.build();
                while (true) {
                    long tsNow;
                    if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                        this.logWarning("Waiting load thread is timeout, loading process may not be finished", new Object[0]);
                        break block19;
                    }
                    ShowCollectionsResponse response = this.blockingStub().showCollections(showCollectionRequest);
                    int namesCount = response.getCollectionNamesCount();
                    int percentagesCount = response.getInMemoryPercentagesCount();
                    if (namesCount != 1) {
                        throw new IllegalResponseException("ShowCollectionsResponse is illegal. Collection count: " + namesCount);
                    }
                    if (namesCount != percentagesCount) {
                        String msg = "ShowCollectionsResponse is illegal. Collection count: " + namesCount + " memory percentages count: " + percentagesCount;
                        throw new IllegalResponseException(msg);
                    }
                    long percentage = response.getInMemoryPercentages(0);
                    String responseCollection = response.getCollectionNames(0);
                    if (responseCollection.compareTo(collectionName) == 0 && percentage >= 100L) break block19;
                    try {
                        this.logDebug("Waiting load, interval: {} ms, percentage: {}%", waitingInterval, percentage);
                        TimeUnit.MILLISECONDS.sleep(waitingInterval);
                    }
                    catch (InterruptedException e) {
                        this.logWarning("Waiting load thread is interrupted, loading process may not be finished", new Object[0]);
                        break block19;
                    }
                }
            }
            ShowPartitionsRequest.Builder builder = ShowPartitionsRequest.newBuilder().setCollectionName(collectionName).addAllPartitionNames(partitionNames);
            if (StringUtils.isNotEmpty((CharSequence)databaseName)) {
                builder.setDbName(databaseName);
            }
            ShowPartitionsRequest showPartitionsRequest = builder.setType(ShowType.InMemory).build();
            while (true) {
                int percentagesCount;
                long tsNow;
                if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                    this.logWarning("Waiting load thread is timeout, loading process may not be finished", new Object[0]);
                    break;
                }
                ShowPartitionsResponse response = this.blockingStub().showPartitions(showPartitionsRequest);
                int namesCount = response.getPartitionNamesCount();
                if (namesCount != (percentagesCount = response.getInMemoryPercentagesCount())) {
                    String msg = "ShowPartitionsResponse is illegal. Partition count: " + namesCount + " memory percentages count: " + percentagesCount;
                    throw new IllegalResponseException(msg);
                }
                HashMap<String, Long> percentages = new HashMap<String, Long>();
                for (int i = 0; i < response.getInMemoryPercentagesCount(); ++i) {
                    percentages.put(response.getPartitionNames(i), response.getInMemoryPercentages(i));
                }
                String partitionNoMemState = "";
                String partitionNotFullyLoad = "";
                boolean allLoaded = true;
                for (String name : partitionNames) {
                    if (!percentages.containsKey(name)) {
                        allLoaded = false;
                        partitionNoMemState = name;
                        break;
                    }
                    if ((Long)percentages.get(name) >= 100L) continue;
                    allLoaded = false;
                    partitionNotFullyLoad = name;
                    break;
                }
                if (allLoaded) break;
                try {
                    String msg = "Waiting load, interval: " + waitingInterval + "ms";
                    if (!partitionNoMemState.isEmpty()) {
                        msg = msg + "Partition " + partitionNoMemState + " has no memory state";
                    }
                    if (!partitionNotFullyLoad.isEmpty()) {
                        msg = msg + "Partition " + partitionNotFullyLoad + " has not fully loaded";
                    }
                    this.logDebug(msg, new Object[0]);
                    TimeUnit.MILLISECONDS.sleep(waitingInterval);
                }
                catch (InterruptedException e) {
                    this.logWarning("Waiting load thread is interrupted, load process may not be finished", new Object[0]);
                    break;
                }
            }
        }
    }

    private void waitForFlush(FlushResponse flushResponse, long waitingInterval, long timeout) {
        long tsBegin = System.currentTimeMillis();
        Map<String, LongArray> collectionSegIDs = flushResponse.getCollSegIDsMap();
        Map<String, Long> flushTsMap = flushResponse.getCollFlushTsMap();
        String dbName = flushResponse.getDbName();
        collectionSegIDs.forEach((collectionName, segmentIDs) -> {
            while (segmentIDs.getDataCount() > 0) {
                String msg;
                GetFlushStateResponse response;
                long tsNow = System.currentTimeMillis();
                if (tsNow - tsBegin >= timeout * 1000L) {
                    this.logWarning("Waiting flush thread is timeout, flush process may not be finished", new Object[0]);
                    break;
                }
                GetFlushStateRequest.Builder builder = GetFlushStateRequest.newBuilder().addAllSegmentIDs(segmentIDs.getDataList()).setCollectionName((String)collectionName).setFlushTs((Long)flushTsMap.get(collectionName));
                if (StringUtils.isNotEmpty((CharSequence)dbName)) {
                    builder.setDbName(dbName);
                }
                if ((response = this.blockingStub().getFlushState(builder.build())).getFlushed()) {
                    msg = segmentIDs.getDataCount() + " segments of " + collectionName + " has been flushed";
                    this.logDebug(msg, new Object[0]);
                    break;
                }
                try {
                    msg = "Waiting flush for " + collectionName + ", interval: " + waitingInterval + "ms";
                    this.logDebug(msg, new Object[0]);
                    TimeUnit.MILLISECONDS.sleep(waitingInterval);
                }
                catch (InterruptedException e) {
                    this.logWarning("Waiting flush thread is interrupted, flush process may not be finished", new Object[0]);
                    break;
                }
            }
        });
    }

    private void waitForFlushAll(FlushAllResponse flushAllResponse, long waitingInterval, long timeout) {
        long tsBegin = System.currentTimeMillis();
        long flushAllTs = flushAllResponse.getFlushAllTs();
        while (true) {
            long tsNow;
            if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                this.logWarning("waitForFlushAll timeout", new Object[0]);
                break;
            }
            GetFlushAllStateRequest getFlushAllStateRequest = GetFlushAllStateRequest.newBuilder().setFlushAllTs(flushAllTs).build();
            GetFlushAllStateResponse response = this.blockingStub().getFlushAllState(getFlushAllStateRequest);
            if (response.getFlushed()) {
                this.logDebug("waitForFlushAll done, all flushed!", new Object[0]);
                break;
            }
            try {
                String msg = "waitForFlushAll, interval: " + waitingInterval + "ms";
                this.logDebug(msg, new Object[0]);
                TimeUnit.MILLISECONDS.sleep(waitingInterval);
            }
            catch (InterruptedException e) {
                this.logWarning("waitForFlushAll interrupted", new Object[0]);
                break;
            }
        }
    }

    private R<Boolean> waitForIndex(String databaseName, String collectionName, String indexName, String fieldName, long waitingInterval, long timeout) {
        long tsBegin = System.currentTimeMillis();
        while (true) {
            String msg;
            long tsNow;
            if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                String msg2 = "Waiting index thread is timeout, index process may not be finished";
                this.logWarning(msg2, new Object[0]);
                return R.failed(R.Status.UnexpectedError, msg2);
            }
            DescribeIndexRequest.Builder builder = DescribeIndexRequest.newBuilder().setCollectionName(collectionName).setIndexName(indexName);
            if (StringUtils.isNotEmpty((CharSequence)databaseName)) {
                builder.setDbName(databaseName);
            }
            DescribeIndexRequest request = builder.build();
            DescribeIndexResponse response = this.blockingStub().describeIndex(request);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return R.failed(response.getStatus().getErrorCode(), response.getStatus().getReason());
            }
            if (response.getIndexDescriptionsList().size() == 0) {
                return R.failed(R.Status.UnexpectedError, response.getStatus().getReason());
            }
            IndexDescription index = response.getIndexDescriptionsList().stream().filter(x -> x.getFieldName().equals(fieldName)).findFirst().orElse(response.getIndexDescriptions(0));
            if (index.getState() == IndexState.Finished) {
                return R.success(true);
            }
            if (index.getState() == IndexState.Failed) {
                msg = "Get index state failed: " + index.getState().toString();
                this.logError(msg, new Object[0]);
                return R.failed(R.Status.UnexpectedError, msg);
            }
            try {
                msg = "Waiting index, interval: " + waitingInterval + "ms";
                this.logDebug(msg, new Object[0]);
                TimeUnit.MILLISECONDS.sleep(waitingInterval);
            }
            catch (InterruptedException e) {
                String msg3 = "Waiting index thread is interrupted, index process may not be finished";
                this.logWarning(msg3, new Object[0]);
                return R.failed(R.Status.Success, msg3);
            }
        }
    }

    private void handleResponse(String requestInfo, Status status) {
        if (status.getCode() != 0 || !status.getErrorCode().equals((Object)ErrorCode.Success)) {
            this.logError("{} failed, error code: {}, reason: {}", requestInfo, status.getCode() > 0 ? status.getCode() : status.getErrorCode().getNumber(), status.getReason());
            int code = status.getCode();
            if (code == 0) {
                code = status.getErrorCode().getNumber();
            }
            throw new ServerException(status.getReason(), code, status.getErrorCode());
        }
        this.logDebug("{} successfully!", requestInfo);
    }

    @Override
    public R<Boolean> hasCollection(@NonNull HasCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("HasCollectionRequest collectionName:%s", requestParam.getCollectionName());
        try {
            HasCollectionRequest.Builder builder = HasCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            HasCollectionRequest hasCollectionRequest = builder.build();
            BoolResponse response = this.blockingStub().hasCollection(hasCollectionRequest);
            this.handleResponse(title, response.getStatus());
            Boolean value = Optional.of(response).map(BoolResponse::getValue).orElse(false);
            return R.success(value);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createDatabase(CreateDatabaseParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("CreateDatabaseRequest databaseName:%s", requestParam.getDatabaseName());
        try {
            List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(requestParam.getProperties());
            CreateDatabaseRequest createDatabaseRequest = CreateDatabaseRequest.newBuilder().setDbName(requestParam.getDatabaseName()).addAllProperties(propertiesList).build();
            Status response = this.blockingStub().createDatabase(createDatabaseRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ListDatabasesResponse> listDatabases() {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug("ListDatabasesRequest", new Object[0]);
        String title = "ListDatabasesRequest";
        try {
            ListDatabasesRequest listDatabasesRequest = ListDatabasesRequest.newBuilder().build();
            ListDatabasesResponse response = this.blockingStub().listDatabases(listDatabasesRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropDatabase(DropDatabaseParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DropDatabaseRequest databaseName:%s", requestParam.getDatabaseName());
        try {
            DropDatabaseRequest dropDatabaseRequest = DropDatabaseRequest.newBuilder().setDbName(requestParam.getDatabaseName()).build();
            Status response = this.blockingStub().dropDatabase(dropDatabaseRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> alterDatabase(AlterDatabaseParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("AlterDatabaseRequest databaseName:%s", requestParam.getDatabaseName());
        try {
            List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(requestParam.getProperties());
            AlterDatabaseRequest alterDatabaseRequest = AlterDatabaseRequest.newBuilder().setDbName(requestParam.getDatabaseName()).addAllProperties(propertiesList).build();
            Status response = this.blockingStub().alterDatabase(alterDatabaseRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<DescribeDatabaseResponse> describeDatabase(DescribeDatabaseParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DescribeDatabaseRequest databaseName:%s", requestParam.getDatabaseName());
        try {
            DescribeDatabaseRequest describeDatabaseRequest = DescribeDatabaseRequest.newBuilder().setDbName(requestParam.getDatabaseName()).build();
            DescribeDatabaseResponse response = this.blockingStub().describeDatabase(describeDatabaseRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createCollection(@NonNull CreateCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("CreateCollectionRequest collectionName:%s", requestParam.getCollectionName());
        try {
            CollectionSchema.Builder collectionSchemaBuilder = CollectionSchema.newBuilder();
            collectionSchemaBuilder.setName(requestParam.getCollectionName()).setDescription(requestParam.getDescription()).setEnableDynamicField(requestParam.isEnableDynamicField());
            for (FieldType fieldType : requestParam.getFieldTypes()) {
                collectionSchemaBuilder.addFields(ParamUtils.ConvertField(fieldType));
            }
            List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(requestParam.getProperties());
            CreateCollectionRequest.Builder builder = CreateCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setShardsNum(requestParam.getShardsNum()).setConsistencyLevelValue(requestParam.getConsistencyLevel().getCode()).setSchema(collectionSchemaBuilder.build().toByteString()).addAllProperties(propertiesList);
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            if (requestParam.getPartitionsNum() > 0) {
                builder.setNumPartitions(requestParam.getPartitionsNum());
            }
            CreateCollectionRequest createCollectionRequest = builder.build();
            Status response = this.blockingStub().createCollection(createCollectionRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropCollection(@NonNull DropCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String dbName = requestParam.getDatabaseName();
        String collectionName = requestParam.getCollectionName();
        String title = String.format("DropCollectionRequest collectionName:%s", collectionName);
        try {
            DropCollectionRequest.Builder builder = DropCollectionRequest.newBuilder().setCollectionName(collectionName);
            if (StringUtils.isNotEmpty((CharSequence)dbName)) {
                builder.setDbName(dbName);
            }
            DropCollectionRequest dropCollectionRequest = builder.build();
            Status response = this.blockingStub().dropCollection(dropCollectionRequest);
            this.handleResponse(title, response);
            this.removeCollectionCache(dbName, collectionName);
            String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
            GTsDict.getInstance().removeCollectionTs(key);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadCollection(@NonNull LoadCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("LoadCollectionRequest collectionName:%s", requestParam.getCollectionName());
        try {
            LoadCollectionRequest.Builder builder = LoadCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setReplicaNumber(requestParam.getReplicaNumber()).addAllResourceGroups(requestParam.getResourceGroups()).setRefresh(requestParam.isRefresh()).addAllLoadFields(requestParam.getLoadFields()).setSkipLoadDynamicField(requestParam.isSkipLoadDynamicField());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().loadCollection(builder.build());
            this.handleResponse(title, response);
            if (requestParam.isSyncLoad()) {
                this.waitForLoadingCollection(requestParam.getDatabaseName(), requestParam.getCollectionName(), null, requestParam.getSyncLoadWaitingInterval(), requestParam.getSyncLoadWaitingTimeout());
            }
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exceptione:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> releaseCollection(@NonNull ReleaseCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("ReleaseCollectionRequest collectionName:%s", requestParam.getCollectionName());
        try {
            ReleaseCollectionRequest.Builder builder = ReleaseCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().releaseCollection(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> renameCollection(RenameCollectionParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("RenameCollectionRequest collectionName:%s", requestParam.getOldCollectionName());
        try {
            RenameCollectionRequest.Builder builder = RenameCollectionRequest.newBuilder().setOldName(requestParam.getOldCollectionName()).setNewName(requestParam.getNewCollectionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getOldDatabaseName())) {
                builder.setDbName(requestParam.getOldDatabaseName());
            }
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getNewDatabaseName())) {
                builder.setNewDBName(requestParam.getNewDatabaseName());
            }
            Status response = this.blockingStub().renameCollection(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<DescribeCollectionResponse> describeCollection(@NonNull DescribeCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DescribeCollectionRequest collectionName:%s", requestParam.getCollectionName());
        try {
            DescribeCollectionRequest.Builder builder = DescribeCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            DescribeCollectionRequest describeCollectionRequest = builder.build();
            DescribeCollectionResponse response = this.blockingStub().describeCollection(describeCollectionRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetCollectionStatisticsResponse> getCollectionStatistics(@NonNull GetCollectionStatisticsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetCollectionStatisticsRequest collectionName:%s", requestParam.getCollectionName());
        try {
            R<FlushResponse> response;
            if (requestParam.isFlushCollection() && (response = this.flush(FlushParam.newBuilder().withDatabaseName(requestParam.getDatabaseName()).addCollectionName(requestParam.getCollectionName()).withSyncFlush(Boolean.TRUE).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(R.Status.valueOf(response.getStatus()), response.getMessage());
            }
            GetCollectionStatisticsRequest.Builder builder = GetCollectionStatisticsRequest.newBuilder().setCollectionName(requestParam.getCollectionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            GetCollectionStatisticsRequest getCollectionStatisticsRequest = builder.build();
            GetCollectionStatisticsResponse response2 = this.blockingStub().getCollectionStatistics(getCollectionStatisticsRequest);
            this.handleResponse(title, response2.getStatus());
            return R.success(response2);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ShowCollectionsResponse> showCollections(@NonNull ShowCollectionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "ShowCollectionsRequest";
        try {
            ShowCollectionsRequest.Builder builder = ShowCollectionsRequest.newBuilder().addAllCollectionNames(requestParam.getCollectionNames()).setType(requestParam.getShowType());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            ShowCollectionsRequest showCollectionsRequest = builder.build();
            ShowCollectionsResponse response = this.blockingStub().showCollections(showCollectionsRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> alterCollection(AlterCollectionParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("AlterCollectionRequest collectionName:%s", requestParam.getCollectionName());
        try {
            AlterCollectionRequest.Builder builder = AlterCollectionRequest.newBuilder();
            List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(requestParam.getProperties());
            if (CollectionUtils.isNotEmpty(propertiesList)) {
                propertiesList.forEach(builder::addProperties);
            }
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            AlterCollectionRequest alterCollectionRequest = builder.setCollectionName(requestParam.getCollectionName()).build();
            Status response = this.blockingStub().alterCollection(alterCollectionRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<FlushResponse> flush(@NonNull FlushParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "FlushRequest";
        try {
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Flush).build();
            FlushRequest.Builder builder = FlushRequest.newBuilder().setBase(msgBase).addAllCollectionNames(requestParam.getCollectionNames());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            FlushRequest flushRequest = builder.build();
            FlushResponse response = this.blockingStub().flush(flushRequest);
            if (Objects.equals(requestParam.getSyncFlush(), Boolean.TRUE)) {
                this.waitForFlush(response, requestParam.getSyncFlushWaitingInterval(), requestParam.getSyncFlushWaitingTimeout());
            }
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<FlushAllResponse> flushAll(boolean syncFlushAll, long syncFlushAllWaitingInterval, long syncFlushAllTimeout) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug("FlushAllRequest", new Object[0]);
        String title = "FlushAllRequest";
        try {
            FlushAllRequest flushAllRequest = FlushAllRequest.newBuilder().build();
            FlushAllResponse response = this.blockingStub().flushAll(flushAllRequest);
            if (syncFlushAll) {
                this.waitForFlushAll(response, syncFlushAllWaitingInterval, syncFlushAllTimeout);
            }
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createPartition(@NonNull CreatePartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("CreatePartitionRequest collectionName:%s, partitionName:%s", requestParam.getCollectionName(), requestParam.getPartitionName());
        try {
            CreatePartitionRequest.Builder builder = CreatePartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().createPartition(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropPartition(@NonNull DropPartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DropPartitionRequest collectionName:%s, partitionName:%s", requestParam.getCollectionName(), requestParam.getPartitionName());
        try {
            DropPartitionRequest.Builder builder = DropPartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().dropPartition(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<Boolean> hasPartition(@NonNull HasPartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("HasPartitionRequest collectionName:%s, partitionName:%s", requestParam.getCollectionName(), requestParam.getPartitionName());
        try {
            HasPartitionRequest.Builder builder = HasPartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            BoolResponse response = this.blockingStub().hasPartition(builder.build());
            this.handleResponse(title, response.getStatus());
            Boolean result = response.getValue();
            return R.success(result);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadPartitions(@NonNull LoadPartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("LoadPartitionsRequest collectionName:%s", requestParam.getCollectionName());
        try {
            LoadPartitionsRequest.Builder builder = LoadPartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setReplicaNumber(requestParam.getReplicaNumber()).addAllPartitionNames(requestParam.getPartitionNames()).addAllResourceGroups(requestParam.getResourceGroups()).setRefresh(requestParam.isRefresh()).addAllLoadFields(requestParam.getLoadFields()).setSkipLoadDynamicField(requestParam.isSkipLoadDynamicField());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().loadPartitions(builder.build());
            this.handleResponse(title, response);
            if (requestParam.isSyncLoad()) {
                this.waitForLoadingCollection(requestParam.getDatabaseName(), requestParam.getCollectionName(), requestParam.getPartitionNames(), requestParam.getSyncLoadWaitingInterval(), requestParam.getSyncLoadWaitingTimeout());
            }
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> releasePartitions(@NonNull ReleasePartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("ReleasePartitionsRequest collectionName:%s", requestParam.getCollectionName());
        try {
            ReleasePartitionsRequest.Builder builder = ReleasePartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().releasePartitions(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetPartitionStatisticsResponse> getPartitionStatistics(@NonNull GetPartitionStatisticsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetPartitionStatisticsRequest collectionName:%s, partitionName:%s", requestParam.getCollectionName(), requestParam.getPartitionName());
        try {
            R<FlushResponse> response;
            if (requestParam.isFlushCollection() && (response = this.flush(FlushParam.newBuilder().addCollectionName(requestParam.getCollectionName()).withSyncFlush(Boolean.TRUE).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(R.Status.valueOf(response.getStatus()), response.getMessage());
            }
            GetPartitionStatisticsRequest.Builder builder = GetPartitionStatisticsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            GetPartitionStatisticsResponse response2 = this.blockingStub().getPartitionStatistics(builder.build());
            this.handleResponse(title, response2.getStatus());
            return R.success(response2);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ShowPartitionsResponse> showPartitions(@NonNull ShowPartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("ShowPartitionsRequest collectionName:%s", requestParam.getCollectionName());
        try {
            ShowPartitionsRequest.Builder builder = ShowPartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            ShowPartitionsResponse response = this.blockingStub().showPartitions(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createAlias(@NonNull CreateAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("CreateAliasRequest collectionName:%s, alias:%s", requestParam.getCollectionName(), requestParam.getAlias());
        try {
            CreateAliasRequest.Builder builder = CreateAliasRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setAlias(requestParam.getAlias());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().createAlias(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropAlias(@NonNull DropAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DropAliasRequest alias:%s", requestParam.getAlias());
        try {
            DropAliasRequest.Builder builder = DropAliasRequest.newBuilder().setAlias(requestParam.getAlias());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().dropAlias(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> alterAlias(@NonNull AlterAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("AlterAliasRequest collectionName:%s, alias:%s", requestParam.getCollectionName(), requestParam.getAlias());
        try {
            AlterAliasRequest.Builder builder = AlterAliasRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setAlias(requestParam.getAlias());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().alterAlias(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ListAliasesResponse> listAliases(ListAliasesParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("ListAliasesRequest collectionName:%s", requestParam.getCollectionName());
        try {
            ListAliasesRequest.Builder builder = ListAliasesRequest.newBuilder().setCollectionName(requestParam.getCollectionName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            ListAliasesResponse response = this.blockingStub().listAliases(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createIndex(@NonNull CreateIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("CreateIndexRequest collectionName:%s, fieldName:%s", requestParam.getCollectionName(), requestParam.getFieldName());
        try {
            R<Boolean> res;
            CreateIndexRequest.Builder createIndexRequestBuilder = CreateIndexRequest.newBuilder();
            Map<String, String> extraParams = requestParam.getExtraParam();
            for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                if (entry.getKey().equals("params")) {
                    Map tempParams = (Map)JsonUtils.fromJson(entry.getValue(), new TypeToken<Map<String, String>>(){}.getType());
                    for (String key : tempParams.keySet()) {
                        createIndexRequestBuilder.addExtraParams(KeyValuePair.newBuilder().setKey(key).setValue((String)tempParams.get(key)).build());
                    }
                    continue;
                }
                createIndexRequestBuilder.addExtraParams(KeyValuePair.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
            }
            CreateIndexRequest.Builder builder = createIndexRequestBuilder.setCollectionName(requestParam.getCollectionName()).setFieldName(requestParam.getFieldName()).setIndexName(requestParam.getIndexName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().createIndex(builder.build());
            this.handleResponse(title, response);
            if (requestParam.isSyncMode() && (res = this.waitForIndex(requestParam.getDatabaseName(), requestParam.getCollectionName(), requestParam.getIndexName(), requestParam.getFieldName(), requestParam.getSyncWaitingInterval(), requestParam.getSyncWaitingTimeout())).getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("CreateIndexRequest in sync mode failed:{}", res.getMessage());
                return R.failed(R.Status.valueOf(res.getStatus()), res.getMessage());
            }
            this.logDebug("{} in sync mode successfully!", title);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropIndex(@NonNull DropIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DropIndexRequest collectionName:%s, indexName:%s", requestParam.getCollectionName(), requestParam.getIndexName());
        try {
            DropIndexRequest.Builder builder = DropIndexRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().dropIndex(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<DescribeIndexResponse> describeIndex(@NonNull DescribeIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DescribeIndexRequest collectionName:%s, indexName:%s", requestParam.getCollectionName(), requestParam.getIndexName());
        try {
            DescribeIndexRequest.Builder builder = DescribeIndexRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName()).setFieldName(requestParam.getFieldName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            DescribeIndexResponse response = this.blockingStub().describeIndex(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    @Deprecated
    public R<GetIndexStateResponse> getIndexState(@NonNull GetIndexStateParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetIndexStateRequest collectionName:%s, indexName:%s", requestParam.getCollectionName(), requestParam.getIndexName());
        try {
            GetIndexStateRequest.Builder builder = GetIndexStateRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            GetIndexStateResponse response = this.blockingStub().getIndexState(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    @Deprecated
    public R<GetIndexBuildProgressResponse> getIndexBuildProgress(@NonNull GetIndexBuildProgressParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetIndexBuildProgressRequest collectionName:%s, indexName:%s", requestParam.getCollectionName(), requestParam.getIndexName());
        try {
            GetIndexBuildProgressRequest.Builder builder = GetIndexBuildProgressRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            GetIndexBuildProgressResponse response = this.blockingStub().getIndexBuildProgress(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> alterIndex(AlterIndexParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("AlterIndexRequest indexName:%s", requestParam.getIndexName());
        try {
            AlterIndexRequest.Builder builder = AlterIndexRequest.newBuilder();
            List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(requestParam.getProperties());
            if (CollectionUtils.isNotEmpty(propertiesList)) {
                propertiesList.forEach(builder::addExtraParams);
            }
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            AlterIndexRequest alterIndexRequest = builder.setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName()).build();
            Status response = this.blockingStub().alterIndex(alterIndexRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<MutationResult> delete(@NonNull DeleteParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String dbName = requestParam.getDatabaseName();
        String collectionName = requestParam.getCollectionName();
        String title = String.format("DeleteRequest collectionName:%s", collectionName);
        try {
            DeleteRequest.Builder builder = DeleteRequest.newBuilder().setBase(MsgBase.newBuilder().setMsgType(MsgType.Delete).build()).setCollectionName(collectionName).setPartitionName(requestParam.getPartitionName()).setExpr(requestParam.getExpr());
            if (StringUtils.isNotEmpty((CharSequence)dbName)) {
                builder.setDbName(dbName);
            }
            MutationResult response = this.blockingStub().delete(builder.build());
            this.handleResponse(title, response.getStatus());
            String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
            GTsDict.getInstance().updateCollectionTs(key, response.getTimestamp());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    private InsertRequest buildInsertRequest(InsertParam requestParam, DescribeCollectionResponse descResp) {
        DescCollResponseWrapper wrapper = new DescCollResponseWrapper(descResp);
        ParamUtils.InsertBuilderWrapper builderWraper = new ParamUtils.InsertBuilderWrapper(requestParam, wrapper);
        InsertRequest rpcRequest = builderWraper.buildInsertRequest();
        return rpcRequest.toBuilder().setSchemaTimestamp(descResp.getUpdateTimestamp()).build();
    }

    @Override
    public R<MutationResult> insert(@NonNull InsertParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String dbName = requestParam.getDatabaseName();
        String collectionName = requestParam.getCollectionName();
        String title = String.format("InsertRequest collectionName:%s", collectionName);
        try {
            InsertRequest rpcRequest;
            DescribeCollectionResponse descResp = this.getCollectionInfo(dbName, collectionName, false);
            try {
                rpcRequest = this.buildInsertRequest(requestParam, descResp);
            }
            catch (Exception ignored) {
                descResp = this.getCollectionInfo(dbName, collectionName, true);
                rpcRequest = this.buildInsertRequest(requestParam, descResp);
            }
            MutationResult response = this.blockingStub().insert(rpcRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.SchemaMismatch) {
                this.getCollectionInfo(dbName, collectionName, true);
                return this.insert(requestParam);
            }
            this.cleanCacheIfFailed(response.getStatus(), dbName, collectionName);
            this.handleResponse(title, response.getStatus());
            String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
            GTsDict.getInstance().updateCollectionTs(key, response.getTimestamp());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            this.removeCollectionCache(dbName, collectionName);
            return R.failed(e);
        }
    }

    @Override
    public ListenableFuture<R<MutationResult>> insertAsync(InsertParam requestParam) {
        InsertRequest rpcRequest;
        if (!this.clientIsReady()) {
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Client rpc channel is not ready")));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        final String dbName = requestParam.getDatabaseName();
        final String collectionName = requestParam.getCollectionName();
        final String title = String.format("InsertAsyncRequest collectionName:%s", collectionName);
        DescribeCollectionResponse descResp = this.getCollectionInfo(dbName, collectionName, false);
        try {
            rpcRequest = this.buildInsertRequest(requestParam, descResp);
        }
        catch (Exception ignored) {
            descResp = this.getCollectionInfo(dbName, collectionName, true);
            rpcRequest = this.buildInsertRequest(requestParam, descResp);
        }
        ListenableFuture<MutationResult> response = this.futureStub().insert(rpcRequest);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<MutationResult>(){

            public void onSuccess(MutationResult result) {
                AbstractMilvusGrpcClient.this.cleanCacheIfFailed(result.getStatus(), dbName, collectionName);
                if (result.getStatus().getErrorCode() == ErrorCode.Success) {
                    AbstractMilvusGrpcClient.this.logDebug("{} successfully!", title);
                    String key = GTsDict.CombineCollectionName(AbstractMilvusGrpcClient.this.actualDbName(dbName), collectionName);
                    GTsDict.getInstance().updateCollectionTs(key, result.getTimestamp());
                } else {
                    AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, result.getStatus().getReason());
                }
            }

            public void onFailure(@Nonnull Throwable t) {
                AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, t.getMessage());
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<MutationResult, R> transformFunc = results -> {
            Status status = results.getStatus();
            if (status.getCode() != 0 || status.getErrorCode() != ErrorCode.Success) {
                return R.failed(new ServerException(status.getReason(), status.getCode(), status.getErrorCode()));
            }
            return R.success(results);
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    private UpsertRequest buildUpsertRequest(UpsertParam requestParam, DescribeCollectionResponse descResp) {
        DescCollResponseWrapper wrapper = new DescCollResponseWrapper(descResp);
        ParamUtils.InsertBuilderWrapper builderWraper = new ParamUtils.InsertBuilderWrapper(requestParam, wrapper);
        UpsertRequest rpcRequest = builderWraper.buildUpsertRequest();
        return rpcRequest.toBuilder().setSchemaTimestamp(descResp.getUpdateTimestamp()).build();
    }

    @Override
    public R<MutationResult> upsert(UpsertParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String dbName = requestParam.getDatabaseName();
        String collectionName = requestParam.getCollectionName();
        String title = String.format("UpsertRequest collectionName:%s", collectionName);
        try {
            UpsertRequest rpcRequest;
            DescribeCollectionResponse descResp = this.getCollectionInfo(dbName, collectionName, false);
            try {
                rpcRequest = this.buildUpsertRequest(requestParam, descResp);
            }
            catch (Exception ignored) {
                descResp = this.getCollectionInfo(dbName, collectionName, true);
                rpcRequest = this.buildUpsertRequest(requestParam, descResp);
            }
            MutationResult response = this.blockingStub().upsert(rpcRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.SchemaMismatch) {
                this.getCollectionInfo(dbName, collectionName, true);
                return this.upsert(requestParam);
            }
            this.cleanCacheIfFailed(response.getStatus(), dbName, collectionName);
            this.handleResponse(title, response.getStatus());
            String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
            GTsDict.getInstance().updateCollectionTs(key, response.getTimestamp());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            this.removeCollectionCache(dbName, collectionName);
            return R.failed(e);
        }
    }

    @Override
    public ListenableFuture<R<MutationResult>> upsertAsync(UpsertParam requestParam) {
        UpsertRequest rpcRequest;
        if (!this.clientIsReady()) {
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Client rpc channel is not ready")));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        final String dbName = requestParam.getDatabaseName();
        final String collectionName = requestParam.getCollectionName();
        final String title = String.format("UpsertAsyncRequest collectionName:%s", collectionName);
        DescribeCollectionResponse descResp = this.getCollectionInfo(dbName, collectionName, false);
        try {
            rpcRequest = this.buildUpsertRequest(requestParam, descResp);
        }
        catch (Exception ignored) {
            descResp = this.getCollectionInfo(dbName, collectionName, true);
            rpcRequest = this.buildUpsertRequest(requestParam, descResp);
        }
        ListenableFuture<MutationResult> response = this.futureStub().upsert(rpcRequest);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<MutationResult>(){

            public void onSuccess(MutationResult result) {
                AbstractMilvusGrpcClient.this.cleanCacheIfFailed(result.getStatus(), dbName, collectionName);
                if (result.getStatus().getErrorCode() == ErrorCode.Success) {
                    AbstractMilvusGrpcClient.this.logDebug("{} successfully!", title);
                    String key = GTsDict.CombineCollectionName(AbstractMilvusGrpcClient.this.actualDbName(dbName), collectionName);
                    GTsDict.getInstance().updateCollectionTs(key, result.getTimestamp());
                } else {
                    AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, result.getStatus().getReason());
                }
            }

            public void onFailure(@Nonnull Throwable t) {
                AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, t.getMessage());
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<MutationResult, R> transformFunc = results -> {
            Status status = results.getStatus();
            if (status.getCode() != 0 || status.getErrorCode() != ErrorCode.Success) {
                return R.failed(new ServerException(status.getReason(), status.getCode(), status.getErrorCode()));
            }
            return R.success(results);
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public R<SearchResults> search(@NonNull SearchParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("SearchRequest collectionName:%s", requestParam.getCollectionName());
        try {
            requestParam.setDatabaseName(this.actualDbName(requestParam.getDatabaseName()));
            SearchRequest searchRequest = ParamUtils.convertSearchParam(requestParam);
            SearchResults response = this.blockingStub().search(searchRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public ListenableFuture<R<SearchResults>> searchAsync(SearchParam requestParam) {
        if (!this.clientIsReady()) {
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Client rpc channel is not ready")));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        final String title = String.format("SearchAsyncRequest collectionName:%s", requestParam.getCollectionName());
        requestParam.setDatabaseName(this.actualDbName(requestParam.getDatabaseName()));
        SearchRequest searchRequest = ParamUtils.convertSearchParam(requestParam);
        ListenableFuture<SearchResults> response = this.futureStub().search(searchRequest);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<SearchResults>(){

            public void onSuccess(SearchResults result) {
                if (result.getStatus().getErrorCode() == ErrorCode.Success) {
                    AbstractMilvusGrpcClient.this.logDebug("{} successfully!", title);
                } else {
                    AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, result.getStatus().getReason());
                }
            }

            public void onFailure(@Nonnull Throwable t) {
                AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, t.getMessage());
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<SearchResults, R> transformFunc = results -> {
            Status status = results.getStatus();
            if (status.getCode() != 0 || status.getErrorCode() != ErrorCode.Success) {
                return R.failed(new ServerException(status.getReason(), status.getCode(), status.getErrorCode()));
            }
            return R.success(results);
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public R<SearchResults> hybridSearch(HybridSearchParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("HybridSearchRequest collectionName:%s", requestParam.getCollectionName());
        try {
            requestParam.setDatabaseName(this.actualDbName(requestParam.getDatabaseName()));
            HybridSearchRequest searchRequest = ParamUtils.convertHybridSearchParam(requestParam);
            SearchResults response = this.blockingStub().hybridSearch(searchRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public ListenableFuture<R<SearchResults>> hybridSearchAsync(HybridSearchParam requestParam) {
        if (!this.clientIsReady()) {
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Client rpc channel is not ready")));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        final String title = String.format("HybridSearchAsyncRequest collectionName:%s", requestParam.getCollectionName());
        requestParam.setDatabaseName(this.actualDbName(requestParam.getDatabaseName()));
        HybridSearchRequest searchRequest = ParamUtils.convertHybridSearchParam(requestParam);
        ListenableFuture<SearchResults> response = this.futureStub().hybridSearch(searchRequest);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<SearchResults>(){

            public void onSuccess(SearchResults result) {
                if (result.getStatus().getErrorCode() == ErrorCode.Success) {
                    AbstractMilvusGrpcClient.this.logDebug("{} successfully!", title);
                } else {
                    AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, result.getStatus().getReason());
                }
            }

            public void onFailure(@Nonnull Throwable t) {
                AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, t.getMessage());
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<SearchResults, R> transformFunc = results -> {
            Status status = results.getStatus();
            if (status.getCode() != 0 || status.getErrorCode() != ErrorCode.Success) {
                return R.failed(new ServerException(status.getReason(), status.getCode(), status.getErrorCode()));
            }
            return R.success(results);
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public R<QueryResults> query(@NonNull QueryParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("QueryRequest collectionName:%s, expr:%s", requestParam.getCollectionName(), requestParam.getExpr());
        try {
            requestParam.setDatabaseName(this.actualDbName(requestParam.getDatabaseName()));
            QueryRequest queryRequest = ParamUtils.convertQueryParam(requestParam);
            QueryResults response = this.blockingStub().query(queryRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.EmptyCollection) {
                this.logWarning("QueryRequest returns nothing: empty collection or improper expression", new Object[0]);
                return R.failed(ErrorCode.EmptyCollection, "empty collection or improper expression");
            }
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public ListenableFuture<R<QueryResults>> queryAsync(QueryParam requestParam) {
        if (!this.clientIsReady()) {
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Client rpc channel is not ready")));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        final String title = String.format("QueryAsyncRequest collectionName:%s, expr:%s", requestParam.getCollectionName(), requestParam.getExpr());
        requestParam.setDatabaseName(this.actualDbName(requestParam.getDatabaseName()));
        QueryRequest queryRequest = ParamUtils.convertQueryParam(requestParam);
        ListenableFuture<QueryResults> response = this.futureStub().query(queryRequest);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<QueryResults>(){

            public void onSuccess(QueryResults result) {
                if (result.getStatus().getErrorCode() == ErrorCode.Success) {
                    AbstractMilvusGrpcClient.this.logDebug("{} successfully!", title);
                } else {
                    AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, result.getStatus().getReason());
                }
            }

            public void onFailure(@Nonnull Throwable t) {
                AbstractMilvusGrpcClient.this.logError("{} failed:\n{}", title, t.getMessage());
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<QueryResults, R> transformFunc = results -> {
            Status status = results.getStatus();
            if (status.getCode() != 0 || status.getErrorCode() != ErrorCode.Success) {
                return R.failed(new ServerException(status.getReason(), status.getCode(), status.getErrorCode()));
            }
            return R.success(results);
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public R<GetMetricsResponse> getMetrics(@NonNull GetMetricsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("QueryAsyncRequest request:%s", requestParam.getRequest());
        try {
            GetMetricsRequest getMetricsRequest = GetMetricsRequest.newBuilder().setRequest(requestParam.getRequest()).build();
            GetMetricsResponse response = this.blockingStub().getMetrics(getMetricsRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetFlushStateResponse> getFlushState(@NonNull GetFlushStateParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetFlushState collectionName:%s", requestParam.getCollectionName());
        try {
            GetFlushStateRequest.Builder builder = GetFlushStateRequest.newBuilder().addAllSegmentIDs(requestParam.getSegmentIDs()).setCollectionName(requestParam.getCollectionName()).setFlushTs(requestParam.getFlushTs());
            if (StringUtils.isNotBlank((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            GetFlushStateResponse response = this.blockingStub().getFlushState(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetFlushAllStateResponse> getFlushAllState(GetFlushAllStateParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "GetFlushAllState";
        try {
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Flush).build();
            GetFlushAllStateRequest getFlushStateRequest = GetFlushAllStateRequest.newBuilder().setBase(msgBase).setFlushAllTs(requestParam.getFlushAllTs()).build();
            GetFlushAllStateResponse response = this.blockingStub().getFlushAllState(getFlushStateRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetPersistentSegmentInfoResponse> getPersistentSegmentInfo(@NonNull GetPersistentSegmentInfoParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetPersistentSegmentInfoRequest collectionName:%s", requestParam.getCollectionName());
        try {
            GetPersistentSegmentInfoRequest getSegmentInfoRequest = GetPersistentSegmentInfoRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetPersistentSegmentInfoResponse response = this.blockingStub().getPersistentSegmentInfo(getSegmentInfoRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetQuerySegmentInfoResponse> getQuerySegmentInfo(@NonNull GetQuerySegmentInfoParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetQuerySegmentInfoRequest collectionName:%s", requestParam.getCollectionName());
        try {
            GetQuerySegmentInfoRequest getSegmentInfoRequest = GetQuerySegmentInfoRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetQuerySegmentInfoResponse response = this.blockingStub().getQuerySegmentInfo(getSegmentInfoRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetReplicasResponse> getReplicas(GetReplicasParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetReplicasRequest collectionName:%s", requestParam.getCollectionName());
        try {
            GetReplicasRequest.Builder builder = GetReplicasRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setWithShardNodes(requestParam.isWithShardNodes());
            if (StringUtils.isNotBlank((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            GetReplicasRequest getReplicasRequest = builder.build();
            GetReplicasResponse response = this.blockingStub().getReplicas(getReplicasRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadBalance(LoadBalanceParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "LoadBalanceRequest";
        try {
            LoadBalanceRequest.Builder builder = LoadBalanceRequest.newBuilder().setSrcNodeID(requestParam.getSrcNodeID()).addAllDstNodeIDs(requestParam.getDestNodeIDs()).addAllSealedSegmentIDs(requestParam.getSegmentIDs());
            if (StringUtils.isNotBlank((CharSequence)requestParam.getCollectionName())) {
                builder.setCollectionName(requestParam.getCollectionName());
            }
            if (StringUtils.isNotBlank((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            Status response = this.blockingStub().loadBalance(builder.build());
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetCompactionStateResponse> getCompactionState(GetCompactionStateParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetCompactionStateRequest compactionID:%d", requestParam.getCompactionID());
        try {
            GetCompactionStateRequest getCompactionStateRequest = GetCompactionStateRequest.newBuilder().setCompactionID(requestParam.getCompactionID()).build();
            GetCompactionStateResponse response = this.blockingStub().getCompactionState(getCompactionStateRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ManualCompactionResponse> manualCompact(ManualCompactParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("ManualCompactionRequest collectionName:%s", requestParam.getCollectionName());
        try {
            R<DescribeCollectionResponse> descResp = this.describeCollection(DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName()).build());
            if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(descResp.getException());
            }
            ManualCompactionRequest manualCompactionRequest = ManualCompactionRequest.newBuilder().setCollectionID(descResp.getData().getCollectionID()).build();
            ManualCompactionResponse response = this.blockingStub().manualCompaction(manualCompactionRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetCompactionPlansResponse> getCompactionStateWithPlans(GetCompactionPlansParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetCompactionPlansRequest compactionID:%d", requestParam.getCompactionID());
        try {
            GetCompactionPlansRequest getCompactionPlansRequest = GetCompactionPlansRequest.newBuilder().setCompactionID(requestParam.getCompactionID()).build();
            GetCompactionPlansResponse response = this.blockingStub().getCompactionStateWithPlans(getCompactionPlansRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createCredential(CreateCredentialParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("CreateCredentialRequest userName:%s", requestParam.getUsername());
        try {
            CreateCredentialRequest createCredentialRequest = CreateCredentialRequest.newBuilder().setUsername(requestParam.getUsername()).setPassword(this.getBase64EncodeString(requestParam.getPassword())).build();
            Status response = this.blockingStub().createCredential(createCredentialRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> updateCredential(UpdateCredentialParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("UpdateCredentialRequest userName:%s", requestParam.getUsername());
        try {
            UpdateCredentialRequest updateCredentialRequest = UpdateCredentialRequest.newBuilder().setUsername(requestParam.getUsername()).setOldPassword(this.getBase64EncodeString(requestParam.getOldPassword())).setNewPassword(this.getBase64EncodeString(requestParam.getNewPassword())).build();
            Status response = this.blockingStub().updateCredential(updateCredentialRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> deleteCredential(DeleteCredentialParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DeleteCredentialRequest userName:%s", requestParam.getUsername());
        try {
            DeleteCredentialRequest deleteCredentialRequest = DeleteCredentialRequest.newBuilder().setUsername(requestParam.getUsername()).build();
            Status response = this.blockingStub().deleteCredential(deleteCredentialRequest);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ListCredUsersResponse> listCredUsers(ListCredUsersParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "ListCredUsersRequest";
        try {
            ListCredUsersRequest listCredUsersRequest = ListCredUsersRequest.newBuilder().build();
            ListCredUsersResponse response = this.blockingStub().listCredUsers(listCredUsersRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    private String getBase64EncodeString(String str) {
        return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public R<RpcStatus> addUserToRole(AddUserToRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("AddUserToRoleRequest userName:%s, roleName:%s", requestParam.getUserName(), requestParam.getRoleName());
        try {
            OperateUserRoleRequest request = OperateUserRoleRequest.newBuilder().setUsername(requestParam.getUserName()).setRoleName(requestParam.getRoleName()).setType(OperateUserRoleType.AddUserToRole).build();
            Status response = this.blockingStub().operateUserRole(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> removeUserFromRole(RemoveUserFromRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("RemoveUserFromRoleRequest userName:%s, roleName:%s", requestParam.getUserName(), requestParam.getRoleName());
        try {
            OperateUserRoleRequest request = OperateUserRoleRequest.newBuilder().setUsername(requestParam.getUserName()).setRoleName(requestParam.getRoleName()).setType(OperateUserRoleType.RemoveUserFromRole).build();
            Status response = this.blockingStub().operateUserRole(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createRole(CreateRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("RemoveUserFromRoleRequest roleName:%s", requestParam.getRoleName());
        try {
            CreateRoleRequest request = CreateRoleRequest.newBuilder().setEntity(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).build();
            Status response = this.blockingStub().createRole(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropRole(DropRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DropRoleRequest roleName:%s", requestParam.getRoleName());
        try {
            DropRoleRequest request = DropRoleRequest.newBuilder().setRoleName(requestParam.getRoleName()).build();
            Status response = this.blockingStub().dropRole(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<SelectRoleResponse> selectRole(SelectRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("SelectRoleRequest roleName:%s", requestParam.getRoleName());
        try {
            SelectRoleRequest request = SelectRoleRequest.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).setIncludeUserInfo(requestParam.isIncludeUserInfo()).build();
            SelectRoleResponse response = this.blockingStub().selectRole(request);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<SelectUserResponse> selectUser(SelectUserParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("SelectUserRequest userName:%s", requestParam.getUserName());
        try {
            SelectUserRequest request = SelectUserRequest.newBuilder().setUser(UserEntity.newBuilder().setName(requestParam.getUserName()).build()).setIncludeRoleInfo(requestParam.isIncludeRoleInfo()).build();
            SelectUserResponse response = this.blockingStub().selectUser(request);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> grantRolePrivilege(GrantRolePrivilegeParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GrantRolePrivilegeRequest roleName:%s", requestParam.getRoleName());
        GrantEntity.Builder builder = GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).setObjectName(requestParam.getObjectName()).setObject(ObjectEntity.newBuilder().setName(requestParam.getObject()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(requestParam.getPrivilege()).build()).build());
        if (StringUtils.isNotBlank((CharSequence)requestParam.getDatabaseName())) {
            builder.setDbName(requestParam.getDatabaseName());
        }
        try {
            OperatePrivilegeRequest request = OperatePrivilegeRequest.newBuilder().setType(OperatePrivilegeType.Grant).setEntity(builder.build()).build();
            Status response = this.blockingStub().operatePrivilege(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> revokeRolePrivilege(RevokeRolePrivilegeParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("RevokeRolePrivilegeRequest roleName:%s", requestParam.getRoleName());
        try {
            GrantEntity.Builder builder = GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).setObjectName(requestParam.getObjectName()).setObject(ObjectEntity.newBuilder().setName(requestParam.getObject()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(requestParam.getPrivilege()).build()).build());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            OperatePrivilegeRequest request = OperatePrivilegeRequest.newBuilder().setType(OperatePrivilegeType.Revoke).setEntity(builder.build()).build();
            Status response = this.blockingStub().operatePrivilege(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<SelectGrantResponse> selectGrantForRole(SelectGrantForRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("SelectGrantForRoleRequest roleName:%s", requestParam.getRoleName());
        try {
            GrantEntity.Builder builder = GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            SelectGrantRequest request = SelectGrantRequest.newBuilder().setEntity(builder.build()).build();
            SelectGrantResponse response = this.blockingStub().selectGrant(request);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<SelectGrantResponse> selectGrantForRoleAndObject(SelectGrantForRoleAndObjectParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("SelectGrantForRoleAndObjectRequest roleName:%s", requestParam.getRoleName());
        try {
            SelectGrantRequest request = SelectGrantRequest.newBuilder().setEntity(GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).setObjectName(requestParam.getObjectName()).setObject(ObjectEntity.newBuilder().setName(requestParam.getObject()).build()).build()).build();
            SelectGrantResponse response = this.blockingStub().selectGrant(request);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ImportResponse> bulkInsert(BulkInsertParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("BulkInsertRequest collectionName:%s", requestParam.getCollectionName());
        try {
            List<KeyValuePair> options;
            ImportRequest.Builder builder = ImportRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllFiles(requestParam.getFiles());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getPartitionName())) {
                builder.setPartitionName(requestParam.getPartitionName());
            }
            if (CollectionUtils.isNotEmpty(options = ParamUtils.AssembleKvPair(requestParam.getOptions()))) {
                options.forEach(builder::addOptions);
            }
            ImportResponse response = this.blockingStub().import_(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetImportStateResponse> getBulkInsertState(GetBulkInsertStateParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetBulkInsertStateRequest taskID:%d", requestParam.getTask());
        try {
            GetImportStateRequest getImportStateRequest = GetImportStateRequest.newBuilder().setTask(requestParam.getTask()).build();
            GetImportStateResponse response = this.blockingStub().getImportState(getImportStateRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ListImportTasksResponse> listBulkInsertTasks(ListBulkInsertTasksParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("ListBulkInsertTasksRequest collectionName:%s", requestParam.getCollectionName());
        try {
            ListImportTasksRequest.Builder builder = ListImportTasksRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setLimit(requestParam.getLimit());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            ListImportTasksResponse response = this.blockingStub().listImportTasks(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetLoadingProgressResponse> getLoadingProgress(GetLoadingProgressParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetLoadingProgressRequest collectionName:%s", requestParam.getCollectionName());
        try {
            GetLoadingProgressRequest.Builder builder = GetLoadingProgressRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            GetLoadingProgressResponse response = this.blockingStub().getLoadingProgress(builder.build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetLoadStateResponse> getLoadState(GetLoadStateParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("GetLoadStateRequest collectionName:%s", requestParam.getCollectionName());
        try {
            GetLoadStateRequest.Builder builder = GetLoadStateRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                builder.setDbName(requestParam.getDatabaseName());
            }
            GetLoadStateRequest loadStateRequest = builder.build();
            GetLoadStateResponse response = this.blockingStub().getLoadState(loadStateRequest);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<CheckHealthResponse> checkHealth() {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        String title = "CheckHealthRequest";
        try {
            CheckHealthResponse response = this.blockingStub().checkHealth(CheckHealthRequest.newBuilder().build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetVersionResponse> getVersion() {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        String title = "GetVersionRequest";
        try {
            GetVersionResponse response = this.blockingStub().getVersion(GetVersionRequest.newBuilder().build());
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createResourceGroup(CreateResourceGroupParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("CreateResourceGroupRequest groupName:%s", requestParam.getGroupName());
        try {
            CreateResourceGroupRequest request = CreateResourceGroupRequest.newBuilder().setResourceGroup(requestParam.getGroupName()).setConfig(requestParam.getConfig().toGRPC()).build();
            Status response = this.blockingStub().createResourceGroup(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropResourceGroup(DropResourceGroupParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DropResourceGroupRequest groupName:%s", requestParam.getGroupName());
        try {
            DropResourceGroupRequest request = DropResourceGroupRequest.newBuilder().setResourceGroup(requestParam.getGroupName()).build();
            Status response = this.blockingStub().dropResourceGroup(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ListResourceGroupsResponse> listResourceGroups(ListResourceGroupsParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "ListResourceGroupsRequest";
        try {
            ListResourceGroupsRequest request = ListResourceGroupsRequest.newBuilder().build();
            ListResourceGroupsResponse response = this.blockingStub().listResourceGroups(request);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<DescribeResourceGroupResponse> describeResourceGroup(DescribeResourceGroupParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("DescribeResourceGroupRequest groupName:%s", requestParam.getGroupName());
        try {
            DescribeResourceGroupRequest request = DescribeResourceGroupRequest.newBuilder().setResourceGroup(requestParam.getGroupName()).build();
            DescribeResourceGroupResponse response = this.blockingStub().describeResourceGroup(request);
            this.handleResponse(title, response.getStatus());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> transferNode(TransferNodeParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("TransferNodeRequest nodeNumber:%d, sourceGroup:%s, targetGroup:%s", requestParam.getNodeNumber(), requestParam.getSourceGroupName(), requestParam.getTargetGroupName());
        try {
            TransferNodeRequest request = TransferNodeRequest.newBuilder().setSourceResourceGroup(requestParam.getSourceGroupName()).setTargetResourceGroup(requestParam.getTargetGroupName()).setNumNode(requestParam.getNodeNumber()).build();
            Status response = this.blockingStub().transferNode(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> transferReplica(TransferReplicaParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("TransferReplicaRequest replicaNumber:%d, sourceGroup:%s, targetGroup:%s", requestParam.getReplicaNumber(), requestParam.getSourceGroupName(), requestParam.getTargetGroupName());
        try {
            TransferReplicaRequest request = TransferReplicaRequest.newBuilder().setSourceResourceGroup(requestParam.getSourceGroupName()).setTargetResourceGroup(requestParam.getTargetGroupName()).setCollectionName(requestParam.getCollectionName()).setDbName(requestParam.getDatabaseName()).setNumReplica(requestParam.getReplicaNumber()).build();
            Status response = this.blockingStub().transferReplica(request);
            this.handleResponse(title, response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> updateResourceGroups(UpdateResourceGroupsParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        try {
            UpdateResourceGroupsRequest request = requestParam.toGRPC();
            Status response = this.blockingStub().updateResourceGroups(request);
            this.handleResponse(requestParam.toString(), response);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{requestParam.toString(), e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", requestParam.toString(), e);
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createCollection(CreateSimpleCollectionParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "CreateSimpleCollectionRequest";
        try {
            R<RpcStatus> createCollectionStatus = this.createCollection(requestParam.getCreateCollectionParam());
            if (!Objects.equals(createCollectionStatus.getStatus(), R.success().getStatus())) {
                this.logError("CreateCollection failed: {}", createCollectionStatus.getException().getMessage());
                return R.failed(createCollectionStatus.getException());
            }
            R<RpcStatus> createIndexStatus = this.createIndex(requestParam.getCreateIndexParam());
            if (!Objects.equals(createIndexStatus.getStatus(), R.success().getStatus())) {
                this.logError("CreateIndex failed: {}", createIndexStatus.getException().getMessage());
                return R.failed(createIndexStatus.getException());
            }
            R<RpcStatus> loadCollectionStatus = this.loadCollection(requestParam.getLoadCollectionParam());
            if (!Objects.equals(loadCollectionStatus.getStatus(), R.success().getStatus())) {
                this.logError("LoadCollection failed: {}", loadCollectionStatus.getException().getMessage());
                return R.failed(loadCollectionStatus.getException());
            }
            this.logDebug("{} successfully!", title);
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<ListCollectionsResponse> listCollections(ListCollectionsParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "ListCollectionsRequest";
        try {
            R<ShowCollectionsResponse> response = this.showCollections(requestParam.getShowCollectionsParam());
            if (!Objects.equals(response.getStatus(), R.success().getStatus())) {
                this.logError("ListCollections failed: {}", response.getException().getMessage());
                return R.failed(response.getException());
            }
            ShowCollResponseWrapper showCollResponseWrapper = new ShowCollResponseWrapper(response.getData());
            return R.success(ListCollectionsResponse.builder().collectionNames(showCollResponseWrapper.getCollectionNames()).build());
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<InsertResponse> insert(InsertRowsParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "InsertRowsRequest";
        try {
            R<MutationResult> response = this.insert(requestParam.getInsertParam());
            if (!Objects.equals(response.getStatus(), R.success().getStatus())) {
                this.logError("Insert failed: {}", response.getException().getMessage());
                return R.failed(response.getException());
            }
            this.logDebug("{} successfully!", title);
            MutationResultWrapper wrapper = new MutationResultWrapper(response.getData());
            return R.success(InsertResponse.builder().insertIds(wrapper.getInsertIDs()).insertCount(wrapper.getInsertCount()).build());
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<DeleteResponse> delete(DeleteIdsParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String collectionName = requestParam.getCollectionName();
        String title = String.format("DeleteIdsRequest collectionName:%s", collectionName);
        try {
            DescribeCollectionResponse descResp = this.getCollectionInfo("", collectionName, false);
            DescCollResponseWrapper wrapper = new DescCollResponseWrapper(descResp);
            String expr = VectorUtils.convertPksExpr(requestParam.getPrimaryIds(), wrapper);
            DeleteParam deleteParam = DeleteParam.newBuilder().withCollectionName(collectionName).withPartitionName(requestParam.getPartitionName()).withExpr(expr).build();
            R<MutationResult> resultR = this.delete(deleteParam);
            if (resultR.getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(resultR.getException());
            }
            MutationResultWrapper resultWrapper = new MutationResultWrapper(resultR.getData());
            return R.success(DeleteResponse.builder().deleteIds(resultWrapper.getDeleteIDs()).build());
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<GetResponse> get(GetIdsParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "GetIdsRequest";
        try {
            DescribeCollectionParam.Builder builder = DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName());
            R<DescribeCollectionResponse> descResp = this.describeCollection(builder.build());
            if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("Failed to describe collection: {}", requestParam.getCollectionName());
                return R.failed(descResp.getException());
            }
            DescCollResponseWrapper wrapper = new DescCollResponseWrapper(descResp.getData());
            if (CollectionUtils.isEmpty(requestParam.getOutputFields())) {
                FieldType vectorField = wrapper.getVectorField();
                requestParam.getOutputFields().addAll(Lists.newArrayList((Object[])new String[]{"*", vectorField.getName()}));
            }
            String expr = VectorUtils.convertPksExpr(requestParam.getPrimaryIds(), wrapper);
            QueryParam queryParam = QueryParam.newBuilder().withCollectionName(requestParam.getCollectionName()).withExpr(expr).withOutFields(requestParam.getOutputFields()).withConsistencyLevel(requestParam.getConsistencyLevel()).build();
            R<QueryResults> queryResp = this.query(queryParam);
            if (queryResp.getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(queryResp.getException());
            }
            QueryResultsWrapper queryResultsWrapper = new QueryResultsWrapper(queryResp.getData());
            return R.success(GetResponse.builder().rowRecords(queryResultsWrapper.getRowRecords()).build());
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<QueryResponse> query(QuerySimpleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = "QuerySimpleRequest";
        try {
            QueryParam queryParam;
            R<QueryResults> response;
            DescribeCollectionParam.Builder builder = DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName());
            R<DescribeCollectionResponse> descResp = this.describeCollection(builder.build());
            if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("Failed to describe collection: {}", requestParam.getCollectionName());
                return R.failed(descResp.getException());
            }
            DescCollResponseWrapper descCollWrapper = new DescCollResponseWrapper(descResp.getData());
            if (CollectionUtils.isEmpty(requestParam.getOutputFields())) {
                FieldType vectorField = descCollWrapper.getVectorField();
                requestParam.getOutputFields().addAll(Lists.newArrayList((Object[])new String[]{"*", vectorField.getName()}));
            }
            if (!Objects.equals((response = this.query(queryParam = QueryParam.newBuilder().withCollectionName(requestParam.getCollectionName()).withExpr(requestParam.getFilter()).withOutFields(requestParam.getOutputFields()).withOffset(requestParam.getOffset()).withLimit(requestParam.getLimit()).withConsistencyLevel(requestParam.getConsistencyLevel()).build())).getStatus(), R.success().getStatus())) {
                this.logError("Query failed: {}", response.getException().getMessage());
                return R.failed(response.getException());
            }
            QueryResultsWrapper queryWrapper = new QueryResultsWrapper(response.getData());
            return R.success(QueryResponse.builder().rowRecords(queryWrapper.getRowRecords()).build());
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<SearchResponse> search(SearchSimpleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logDebug(requestParam.toString(), new Object[0]);
        String title = String.format("SearchSimpleRequest collectionName:%s", requestParam.getCollectionName());
        try {
            DescribeCollectionParam.Builder builder = DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName());
            R<DescribeCollectionResponse> descResp = this.describeCollection(builder.build());
            if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("Failed to describe collection: {}", requestParam.getCollectionName());
                return R.failed(descResp.getException());
            }
            DescCollResponseWrapper wrapper = new DescCollResponseWrapper(descResp.getData());
            FieldType vectorField = wrapper.getVectorField();
            List<Object> vectors = new ArrayList();
            if (requestParam.getVectors().get(0) instanceof List) {
                vectors = requestParam.getVectors();
            } else {
                vectors.add(requestParam.getVectors());
            }
            SearchParam searchParam = SearchParam.newBuilder().withCollectionName(requestParam.getCollectionName()).withVectors(vectors).withVectorFieldName(vectorField.getName()).withOutFields(requestParam.getOutputFields()).withExpr(requestParam.getFilter()).withTopK(requestParam.getLimit()).withParams(JsonUtils.toJson(requestParam.getParams())).withConsistencyLevel(requestParam.getConsistencyLevel()).build();
            R<SearchResults> response = this.search(searchParam);
            if (!Objects.equals(response.getStatus(), R.success().getStatus())) {
                this.logError("Search failed: {}", response.getException().getMessage());
                return R.failed(response.getException());
            }
            SearchResultsWrapper searchResultsWrapper = new SearchResultsWrapper(response.getData().getResults());
            ArrayList<List<QueryResultsWrapper.RowRecord>> records = new ArrayList<List<QueryResultsWrapper.RowRecord>>();
            for (int i = 0; i < vectors.size(); ++i) {
                records.add(searchResultsWrapper.getRowRecords(i));
            }
            return R.success(SearchResponse.builder().rowRecords(records).build());
        }
        catch (StatusRuntimeException e) {
            this.logError("{} RPC failed! Exception:{}", new Object[]{title, e});
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("{} failed! Exception:{}", title, e);
            return R.failed(e);
        }
    }

    @Override
    public R<QueryIterator> queryIterator(QueryIteratorParam requestParam) {
        DescribeCollectionParam.Builder builder = DescribeCollectionParam.newBuilder().withDatabaseName(requestParam.getDatabaseName()).withCollectionName(requestParam.getCollectionName());
        R<DescribeCollectionResponse> descResp = this.describeCollection(builder.build());
        if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
            this.logError("Failed to describe collection: {}", requestParam.getCollectionName());
            return R.failed(descResp.getException());
        }
        DescCollResponseWrapper descCollResponseWrapper = new DescCollResponseWrapper(descResp.getData());
        QueryIterator queryIterator = new QueryIterator(requestParam, this.blockingStub(), descCollResponseWrapper.getPrimaryField());
        return R.success(queryIterator);
    }

    @Override
    public R<SearchIterator> searchIterator(SearchIteratorParam requestParam) {
        DescribeCollectionParam.Builder builder = DescribeCollectionParam.newBuilder().withDatabaseName(requestParam.getDatabaseName()).withCollectionName(requestParam.getCollectionName());
        R<DescribeCollectionResponse> descResp = this.describeCollection(builder.build());
        if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
            this.logError("Failed to describe collection: {}", requestParam.getCollectionName());
            return R.failed(descResp.getException());
        }
        DescCollResponseWrapper descCollResponseWrapper = new DescCollResponseWrapper(descResp.getData());
        SearchIterator searchIterator = new SearchIterator(requestParam, this.blockingStub(), descCollResponseWrapper.getPrimaryField());
        return R.success(searchIterator);
    }

    protected void logDebug(String msg, Object ... params) {
        if (this.logLevel.ordinal() <= LogLevel.Debug.ordinal()) {
            logger.debug(msg, params);
        }
    }

    protected void logInfo(String msg, Object ... params) {
        if (this.logLevel.ordinal() <= LogLevel.Info.ordinal()) {
            logger.info(msg, params);
        }
    }

    protected void logWarning(String msg, Object ... params) {
        if (this.logLevel.ordinal() <= LogLevel.Warning.ordinal()) {
            logger.warn(msg, params);
        }
    }

    protected void logError(String msg, Object ... params) {
        if (this.logLevel.ordinal() <= LogLevel.Error.ordinal()) {
            logger.error(msg, params);
        }
    }
}

