/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.common.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomUtils;

public class GeneratorUtils {
    public static List<Long> generatorLongValue(int count) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < count; ++i) {
            result.add(Long.valueOf(i));
        }
        return result;
    }

    public static List<Boolean> generatorBoolValue(int count) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (int i = 0; i < count; ++i) {
            result.add(i % 5 == 0);
        }
        return result;
    }

    public static List<Integer> generatorInt8Value(int count) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            result.add(i % 128);
        }
        return result;
    }

    public static List<Integer> generatorInt16Value(int count) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            result.add(i % 1000);
        }
        return result;
    }

    public static List<Integer> generatorInt32Value(int count) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            result.add(i % 100000);
        }
        return result;
    }

    public static List<Float> generatorFloatValue(int count) {
        ArrayList<Float> result = new ArrayList<Float>();
        for (int i = 0; i < count; ++i) {
            result.add(Float.valueOf((float)i / 3.0f));
        }
        return result;
    }

    public static List<Double> generatorDoubleValue(int count) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < count; ++i) {
            result.add((double)i / 7.0);
        }
        return result;
    }

    public static List<String> generatorVarcharValue(int count, int maxLength) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            result.add(UUID.randomUUID().toString().substring(0, maxLength));
        }
        return result;
    }

    public static ByteBuffer generatorBinaryVector(int dim) {
        int[] rawVector = GeneratorUtils.generateRandomBinaryVector(dim);
        return GeneratorUtils.packBits(rawVector);
    }

    private static int[] generateRandomBinaryVector(int dim) {
        int[] rawVector = new int[dim];
        Random random = new Random();
        for (int i = 0; i < dim; ++i) {
            rawVector[i] = random.nextInt(2);
        }
        return rawVector;
    }

    private static ByteBuffer packBits(int[] rawVector) {
        int byteCount = (int)Math.ceil((double)rawVector.length / 8.0);
        byte[] binaryArray = new byte[byteCount];
        for (int i = 0; i < rawVector.length; ++i) {
            if (rawVector[i] == 0) continue;
            int byteIndex = i / 8;
            int bitIndex = 7 - i % 8;
            int n = byteIndex;
            binaryArray[n] = (byte)(binaryArray[n] | 1 << bitIndex);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(byteCount);
        for (byte b : binaryArray) {
            byteBuffer.put(b);
        }
        return byteBuffer;
    }

    public static List<List<Float>> generatorFloatVector(int dim, int count) {
        ArrayList<List<Float>> floatVector = new ArrayList<List<Float>>();
        for (int i = 0; i < count; ++i) {
            ArrayList<Float> result = new ArrayList<Float>();
            for (int j = 0; j < dim; ++j) {
                result.add(Float.valueOf((float)j / 3.0f));
            }
            floatVector.add(result);
        }
        return floatVector;
    }

    public static List<Float> genFloatVector(int dim) {
        ArrayList<Float> result = new ArrayList<Float>();
        for (int i = 0; i < dim; ++i) {
            result.add(Float.valueOf(RandomUtils.nextFloat((float)100.0f, (float)10000.0f)));
        }
        return result;
    }
}

