/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.common.utils;

import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import io.milvus.v2.common.DataType;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.ArrayList;
import java.util.List;

public class V2AdapterUtils {
    private static CreateCollectionReq.FieldSchema convertV1Field(FieldType fieldType) {
        Integer maxLength = fieldType.getMaxLength() > 0 ? fieldType.getMaxLength() : 65535;
        Integer dimension = fieldType.getDimension() > 0 ? Integer.valueOf(fieldType.getDimension()) : null;
        Integer maxCapacity = fieldType.getMaxCapacity() > 0 ? Integer.valueOf(fieldType.getMaxCapacity()) : null;
        DataType elementType = fieldType.getElementType() == null ? null : DataType.valueOf((String)fieldType.getElementType().name());
        CreateCollectionReq.FieldSchema schemaV2 = CreateCollectionReq.FieldSchema.builder().name(fieldType.getName()).description(fieldType.getDescription()).dataType(DataType.valueOf((String)fieldType.getDataType().name())).maxLength(maxLength).dimension(dimension).isPrimaryKey(Boolean.valueOf(fieldType.isPrimaryKey())).isPartitionKey(Boolean.valueOf(fieldType.isPartitionKey())).isClusteringKey(Boolean.valueOf(fieldType.isClusteringKey())).autoID(Boolean.valueOf(fieldType.isAutoID())).elementType(elementType).maxCapacity(maxCapacity).isNullable(Boolean.valueOf(fieldType.isNullable())).defaultValue(fieldType.getDefaultValue()).build();
        return schemaV2;
    }

    public static CreateCollectionReq.CollectionSchema convertV1Schema(CollectionSchemaParam schemaV1) {
        ArrayList<CreateCollectionReq.FieldSchema> fieldSchemaList = new ArrayList<CreateCollectionReq.FieldSchema>();
        List fieldTypes = schemaV1.getFieldTypes();
        for (FieldType fieldType : fieldTypes) {
            fieldSchemaList.add(V2AdapterUtils.convertV1Field(fieldType));
        }
        return CreateCollectionReq.CollectionSchema.builder().enableDynamicField(schemaV1.isEnableDynamicField()).fieldSchemaList(fieldSchemaList).build();
    }

    public static List<String> getOutputFieldNames(CreateCollectionReq.CollectionSchema schema) {
        ArrayList<String> outputFieldNames = new ArrayList<String>();
        List functionList = schema.getFunctionList();
        for (CreateCollectionReq.Function function : functionList) {
            outputFieldNames.addAll(function.getOutputFieldNames());
        }
        return outputFieldNames;
    }
}

