/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.AbstractStatementAwareExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.Collection;
import java.util.Iterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class NewInstanceExpressionWriter
extends AbstractStatementAwareExpressionWriter
implements ExpressionWriter {
    private final ExpressionDef.NewInstance newInstance;

    public NewInstanceExpressionWriter(ExpressionDef.NewInstance newInstance) {
        this.newInstance = newInstance;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        Type type = TypeUtils.getType((TypeDef)this.newInstance.type(), context.objectDef());
        generatorAdapter.newInstance(type);
        generatorAdapter.dup();
        Iterator iterator = this.newInstance.parameterTypes().iterator();
        for (ExpressionDef expression : this.newInstance.values()) {
            ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, expression, (TypeDef)iterator.next());
        }
        generatorAdapter.invokeConstructor(type, new Method("<init>", NewInstanceExpressionWriter.getConstructorDescriptor(context.objectDef(), this.newInstance.parameterTypes())));
        this.popValueIfNeeded(generatorAdapter, (TypeDef)this.newInstance.type());
    }

    private static String getConstructorDescriptor(@Nullable ObjectDef objectDef, Collection<TypeDef> types) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (TypeDef argumentType : types) {
            builder.append(TypeUtils.getType(argumentType, objectDef).getDescriptor());
        }
        return builder.append(")V").toString();
    }
}

