/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.AbstractStatementAwareExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.Iterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class InvokeStaticMethodExpressionWriter
extends AbstractStatementAwareExpressionWriter
implements ExpressionWriter {
    private final ExpressionDef.InvokeStaticMethod invokeStaticMethod;

    public InvokeStaticMethodExpressionWriter(ExpressionDef.InvokeStaticMethod invokeStaticMethod) {
        this.invokeStaticMethod = invokeStaticMethod;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        Iterator iterator = this.invokeStaticMethod.method().getParameters().iterator();
        for (ExpressionDef value : this.invokeStaticMethod.values()) {
            ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, value, ((ParameterDef)iterator.next()).getType());
        }
        boolean isDeclaringTypeInterface = this.invokeStaticMethod.classDef().isInterface();
        MethodDef methodDef = this.invokeStaticMethod.method();
        Method method = new Method(methodDef.getName(), TypeUtils.getMethodDescriptor(context.objectDef(), methodDef));
        Type type = TypeUtils.getType((TypeDef)this.invokeStaticMethod.classDef(), context.objectDef());
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        generatorAdapter.visitMethodInsn(184, owner, method.getName(), method.getDescriptor(), isDeclaringTypeInterface);
        this.popValueIfNeeded(generatorAdapter, methodDef.getReturnType());
    }
}

