/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.GenericElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.GenericPlaceholderElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeVariable;

@Internal
final class JavaGenericPlaceholderElement
extends JavaClassElement
implements GenericPlaceholderElement {
    final TypeVariable realTypeVariable;
    private final JavaNativeElement.Placeholder genericNativeType;
    private final Element declaredElement;
    @Nullable
    private final JavaClassElement resolved;
    private final List<JavaClassElement> bounds;
    private final boolean isRawType;
    private final ElementAnnotationMetadata typeAnnotationMetadata;
    @Nullable
    private ElementAnnotationMetadata genericTypeAnnotationMetadata;

    JavaGenericPlaceholderElement(JavaNativeElement.Placeholder genericNativeType, TypeVariable realTypeVariable, @NonNull Element declaredElement, @Nullable JavaClassElement resolved, @NonNull List<JavaClassElement> bounds, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory, int arrayDimensions, boolean isRawType, String doc) {
        this(genericNativeType, realTypeVariable, declaredElement, resolved, bounds, JavaGenericPlaceholderElement.selectClassElementRepresentingThisPlaceholder(resolved, bounds), annotationMetadataFactory, arrayDimensions, isRawType, doc);
    }

    JavaGenericPlaceholderElement(JavaNativeElement.Placeholder genericNativeType, TypeVariable realTypeVariable, @NonNull Element declaredElement, @Nullable JavaClassElement resolved, @NonNull List<JavaClassElement> bounds, JavaClassElement classElementRepresentingThisPlaceholder, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory, int arrayDimensions, boolean isRawType, String doc) {
        super(classElementRepresentingThisPlaceholder.getNativeType(), annotationMetadataFactory, classElementRepresentingThisPlaceholder.visitorContext, classElementRepresentingThisPlaceholder.typeArguments, classElementRepresentingThisPlaceholder.getTypeArguments(), arrayDimensions, doc);
        this.genericNativeType = genericNativeType;
        this.declaredElement = declaredElement;
        this.realTypeVariable = realTypeVariable;
        this.resolved = resolved;
        this.bounds = bounds;
        this.isRawType = isRawType;
        this.typeAnnotationMetadata = new GenericPlaceholderElementAnnotationMetadata((GenericPlaceholderElement)this, (ClassElement)classElementRepresentingThisPlaceholder);
    }

    private static JavaClassElement selectClassElementRepresentingThisPlaceholder(@Nullable JavaClassElement resolved, @NonNull List<JavaClassElement> bounds) {
        if (resolved != null) {
            return resolved;
        }
        return (JavaClassElement)WildcardElement.findUpperType(bounds, bounds);
    }

    @Override
    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        return this.getGenericTypeAnnotationMetadata();
    }

    @NonNull
    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getGenericTypeAnnotationMetadata() {
        if (this.genericTypeAnnotationMetadata == null) {
            this.genericTypeAnnotationMetadata = this.elementAnnotationMetadataFactory.buildGenericTypeAnnotations((GenericElement)this);
        }
        return this.genericTypeAnnotationMetadata;
    }

    @Override
    @NonNull
    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getTypeAnnotationMetadata() {
        return this.typeAnnotationMetadata;
    }

    @Override
    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        return new AnnotationMetadataHierarchy(true, new AnnotationMetadata[]{super.getAnnotationMetadata(), this.getGenericTypeAnnotationMetadata()});
    }

    @NonNull
    public JavaNativeElement.Placeholder getGenericNativeType() {
        return this.genericNativeType;
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }

    public boolean isRawType() {
        return this.isRawType;
    }

    @NonNull
    public List<JavaClassElement> getBounds() {
        return this.bounds;
    }

    private TypeParameterElement getParameterElement() {
        return (TypeParameterElement)this.realTypeVariable.asElement();
    }

    @NonNull
    public String getVariableName() {
        return this.getParameterElement().getSimpleName().toString();
    }

    public Optional<Element> getDeclaringElement() {
        return Optional.of(this.declaredElement);
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new JavaGenericPlaceholderElement(this.genericNativeType, this.realTypeVariable, this.declaredElement, this.resolved, this.bounds, this.elementAnnotationMetadataFactory, arrayDimensions, this.isRawType, this.doc);
    }

    @Override
    protected JavaClassElement copyThis() {
        return new JavaGenericPlaceholderElement(this.genericNativeType, this.realTypeVariable, this.declaredElement, this.resolved, this.bounds, this.elementAnnotationMetadataFactory, this.arrayDimensions, this.isRawType, this.doc);
    }

    public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        Objects.requireNonNull(fold, "Function argument cannot be null");
        return fold.apply((ClassElement)this);
    }

    public Optional<ClassElement> getResolved() {
        return Optional.ofNullable(this.resolved);
    }

    @Nullable
    public JavaClassElement getResolvedInternal() {
        return this.resolved;
    }
}

